/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.impl.LocalContact;
import org.limewire.mojito.settings.NetworkSettings;
import org.limewire.mojito.util.ContactUtils;
import org.limewire.mojito.util.SameClassFilter;

public class ContactsScrubber {
    private static final Log LOG = LogFactory.getLog(ContactsScrubber.class);
    private final Collection<? extends Contact> nodes;
    private final Map<KUID, Contact> scrubbed;
    private final Collection<Contact> collisions;
    private final boolean isValidResponse;

    public static ContactsScrubber scrub(Context context, Contact sender, Collection<? extends Contact> nodes, float requiredRatio) {
        if (nodes.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return new ContactsScrubber(context, sender, nodes, requiredRatio);
    }

    private ContactsScrubber(Context context, Contact sender, Collection<? extends Contact> nodes, float requiredRatio) {
        assert (!nodes.isEmpty());
        assert (requiredRatio >= 0.0f && requiredRatio <= 1.0f);
        this.nodes = nodes;
        this.scrubbed = new LinkedHashMap<KUID, Contact>(nodes.size());
        this.collisions = new LinkedHashSet<Contact>(1);
        LocalContact localNode = context.getLocalNode();
        SameClassFilter filter = new SameClassFilter(sender);
        boolean containsLocal = false;
        for (Contact contact : nodes) {
            if (!ContactUtils.isValidSocketAddress(contact)) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info(sender + " sent us a Contact with an invalid IP:Port " + contact);
                continue;
            }
            if (ContactUtils.isPrivateAddress(contact)) {
                if (!LOG.isInfoEnabled()) continue;
                if (ContactUtils.isSameNodeID(sender, contact)) {
                    LOG.info(sender + " does not know its external address");
                    continue;
                }
                LOG.info(sender + " sent a Contact with a private IP:Port: " + contact);
                continue;
            }
            if (!ContactUtils.isSameAddressSpace(localNode, contact)) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info(contact + " is from a different IP address space than local Node");
                continue;
            }
            if (NetworkSettings.DROP_PUBLIC_IPV4_COMPATIBLE_ADDRESSES.getValue() && ContactUtils.isIPv4CompatibleAddress(contact)) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info(contact + " has an IPv4-compatible address");
                continue;
            }
            if (NetworkSettings.DROP_PRIVATE_IPV4_COMPATIBLE_ADDRESSES.getValue() && ContactUtils.isPrivateIPv4CompatibleAddress(contact)) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info(contact + " has a private IPv4-compatible address");
                continue;
            }
            if (NetworkSettings.FILTER_CLASS_C.getValue() && ContactUtils.isIPv4Address(contact) && !ContactUtils.isSameNodeID(sender, contact) && filter.isSameNetwork(contact)) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info(sender + " sent one or more Contacts from the same Network-Class: " + contact);
                continue;
            }
            if (ContactUtils.isCollision(context, contact)) {
                if (LOG.isInfoEnabled()) {
                    LOG.info(contact + " seems to collide with " + context.getLocalNode());
                }
                this.collisions.add(contact);
                continue;
            }
            if (ContactUtils.isLocalContact(context, contact)) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Skipping local Node");
                }
                containsLocal = true;
                continue;
            }
            this.scrubbed.put(contact.getNodeID(), contact);
        }
        if (requiredRatio > 0.0f) {
            float f;
            int total = this.scrubbed.size() + this.collisions.size();
            if (containsLocal) {
                ++total;
            }
            this.isValidResponse = (f = (float)total / (float)nodes.size()) >= requiredRatio;
        } else {
            this.isValidResponse = true;
        }
    }

    public Collection<? extends Contact> getContacts() {
        return this.nodes;
    }

    public Collection<Contact> getScrubbed() {
        return this.scrubbed.values();
    }

    public Collection<Contact> getCollisions() {
        return this.collisions;
    }

    public boolean isValidResponse() {
        return this.isValidResponse;
    }
}

