/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.security;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.limewire.mojito.Context;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.settings.SecuritySettings;
import org.limewire.security.SecurityToken;

public class SecurityTokenHelper {
    private static final int SUBSTITUTE_PORT = 1024;
    private final Context context;

    public SecurityTokenHelper(Context context) {
        this.context = context;
    }

    private SocketAddress getTokenSocketAddress(Contact node) {
        if (!node.isFirewalled() || !SecuritySettings.SUBSTITUTE_TOKEN_PORT.getValue()) {
            return node.getContactAddress();
        }
        InetSocketAddress isa = (InetSocketAddress)node.getContactAddress();
        InetAddress addr = isa.getAddress();
        return new InetSocketAddress(addr, 1024);
    }

    public SecurityToken createSecurityToken(Contact dst) {
        return this.context.getSecurityTokenProvider().getSecurityToken(this.getTokenSocketAddress(dst));
    }

    public SecurityToken.TokenData createTokenData(Contact src) {
        return this.context.getSecurityTokenProvider().getTokenData(this.getTokenSocketAddress(src));
    }
}

