/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.db;

import java.io.Serializable;
import java.util.Map;
import org.limewire.mojito.util.ArrayUtils;
import org.limewire.mojito.util.FixedSizeHashMap;

public final class DHTValueType
implements Comparable<DHTValueType>,
Serializable {
    private static final long serialVersionUID = -3662336008253896020L;
    private static final String UNKNOWN_NAME = "UNKNOWN";
    private static final Map<Integer, DHTValueType> TYPES = new FixedSizeHashMap<Integer, DHTValueType>(16, 0.75f, true, 254);
    public static final DHTValueType BINARY = DHTValueType.valueOf("Binary", 0);
    public static final DHTValueType LIME = DHTValueType.valueOf("LimeWire", "LIME");
    public static final DHTValueType TEXT = DHTValueType.valueOf("UTF-8 Encoded String", "TEXT");
    public static final DHTValueType TEST = DHTValueType.valueOf("Test Value", "TEST");
    public static final DHTValueType ANY = DHTValueType.valueOf("Any Type", "****");
    private final String name;
    private final int type;

    private DHTValueType(String name, int type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public int toInt() {
        return this.type;
    }

    @Override
    public int compareTo(DHTValueType o) {
        return this.type - o.type;
    }

    public int hashCode() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DHTValueType)) {
            return false;
        }
        return this.compareTo((DHTValueType)o) == 0;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.name.equals(UNKNOWN_NAME)) {
            buffer.append(ArrayUtils.toString(this.type)).append("/").append(this.name);
        } else {
            buffer.append(this.name);
        }
        buffer.append(" (0x").append(Long.toHexString((long)this.type & 0xFFFFFFFFL)).append(")");
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DHTValueType[] values() {
        Map<Integer, DHTValueType> map = TYPES;
        synchronized (map) {
            return TYPES.values().toArray(new DHTValueType[0]);
        }
    }

    public static DHTValueType valueOf(int type) {
        return DHTValueType.valueOf(UNKNOWN_NAME, type);
    }

    public static DHTValueType valueOf(String type) {
        return DHTValueType.valueOf(UNKNOWN_NAME, type);
    }

    public static DHTValueType valueOf(String name, String type) {
        return DHTValueType.valueOf(name, ArrayUtils.toInteger(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DHTValueType valueOf(String name, int type) {
        Integer key = type;
        Map<Integer, DHTValueType> map = TYPES;
        synchronized (map) {
            DHTValueType valueType = TYPES.get(key);
            if (valueType == null || DHTValueType.isBetterName(valueType, name)) {
                valueType = new DHTValueType(name, type);
                TYPES.put(key, valueType);
            }
            return valueType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readResolve() {
        Integer key = this.type;
        DHTValueType valueType = null;
        Map<Integer, DHTValueType> map = TYPES;
        synchronized (map) {
            valueType = TYPES.get(key);
            if (valueType == null || DHTValueType.isBetterName(valueType, this.name)) {
                valueType = this;
                TYPES.put(key, valueType);
            }
        }
        return valueType;
    }

    private static boolean isBetterName(DHTValueType valueType, String name) {
        return valueType.name.equals(UNKNOWN_NAME) && !name.equals(UNKNOWN_NAME);
    }
}

