/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.concurrent;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.OnewayExchanger;
import org.limewire.mojito.Context;
import org.limewire.mojito.concurrent.BlockingDHTFutureListener;
import org.limewire.mojito.concurrent.Cancellable;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureListener;
import org.limewire.mojito.concurrent.DHTTask;
import org.limewire.mojito.exceptions.LockTimeoutException;

public class DHTFutureTask<T>
implements Runnable,
DHTFuture<T>,
Cancellable {
    private static final Log LOG = LogFactory.getLog(DHTFutureTask.class);
    private final OnewayExchanger<T, ExecutionException> exchanger;
    private final Set<DHTFutureListener<T>> listeners = Collections.synchronizedSet(new LinkedHashSet());
    private final Context context;
    private final DHTTask<T> task;
    private boolean taskIsActive;
    private ScheduledFuture<?> watchdog = null;

    public DHTFutureTask(Context context, DHTTask<T> task) {
        this.task = task;
        this.context = context;
        this.exchanger = new OnewayExchanger<T, ExecutionException>(true){

            @Override
            public synchronized void setValue(T value) {
                if (!this.isDone()) {
                    super.setValue(value);
                    DHTFutureTask.this.killWatchdog();
                    DHTFutureTask.this.internalDone();
                }
            }

            @Override
            public synchronized void setException(ExecutionException exception) {
                if (!this.isDone()) {
                    super.setException(exception);
                    DHTFutureTask.this.killWatchdog();
                    DHTFutureTask.this.internalDone();
                }
            }

            @Override
            public synchronized boolean cancel() {
                if (super.cancel()) {
                    DHTFutureTask.this.killWatchdog();
                    DHTFutureTask.this.internalDone();
                    return true;
                }
                return false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            OnewayExchanger<T, ExecutionException> onewayExchanger = this.exchanger;
            synchronized (onewayExchanger) {
                if (this.isDone()) {
                    return;
                }
                this.taskIsActive = true;
            }
            this.task.start(this.exchanger);
            onewayExchanger = this.exchanger;
            synchronized (onewayExchanger) {
                if (!this.isDone()) {
                    this.initWatchdog();
                }
            }
        }
        catch (Throwable t) {
            this.exchanger.setException(new ExecutionException(t));
        }
    }

    private void initWatchdog() {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean timeout = false;
                OnewayExchanger onewayExchanger = DHTFutureTask.this.exchanger;
                synchronized (onewayExchanger) {
                    if (!DHTFutureTask.this.isDone()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Watchdog is canceling " + DHTFutureTask.this.task);
                        }
                        timeout = DHTFutureTask.this.taskIsActive;
                        DHTFutureTask.this.exchanger.setException(new ExecutionException(new LockTimeoutException(DHTFutureTask.this.task.toString())));
                    }
                }
                if (timeout) {
                    DHTFutureTask.this.task.cancel();
                }
            }
        };
        this.watchdog = this.context.getDHTExecutorService().schedule(r, this.task.getWaitOnLockTimeout(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killWatchdog() {
        OnewayExchanger<T, ExecutionException> onewayExchanger = this.exchanger;
        synchronized (onewayExchanger) {
            if (this.watchdog != null) {
                this.watchdog.cancel(true);
                this.watchdog = null;
            }
        }
    }

    protected void done() {
    }

    private void internalDone() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                DHTFutureTask.this.done();
                try {
                    Object value = DHTFutureTask.this.exchanger.get();
                    DHTFutureTask.this.fireFutureResult(value);
                }
                catch (ExecutionException e) {
                    DHTFutureTask.this.fireExecutionException(e);
                }
                catch (CancellationException e) {
                    DHTFutureTask.this.fireCancellationException(e);
                }
                catch (InterruptedException e) {
                    DHTFutureTask.this.fireInterruptedException(e);
                }
            }
        };
        this.context.getDHTExecutorService().execute(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDHTFutureListener(final DHTFutureListener<T> listener) {
        if (listener == null) {
            throw new NullPointerException("DHTFutureListener is null");
        }
        boolean done = false;
        OnewayExchanger<T, ExecutionException> onewayExchanger = this.exchanger;
        synchronized (onewayExchanger) {
            done = this.isDone();
            if (!done) {
                this.listeners.add(listener);
            }
        }
        if (done) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        Object value = DHTFutureTask.this.exchanger.get();
                        listener.handleFutureSuccess(value);
                    }
                    catch (ExecutionException e) {
                        listener.handleExecutionException(e);
                    }
                    catch (CancellationException e) {
                        listener.handleCancellationException(e);
                    }
                    catch (InterruptedException e) {
                        listener.handleInterruptedException(e);
                    }
                }
            };
            this.context.getDHTExecutorService().execute(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean cancelTask = false;
        OnewayExchanger<T, ExecutionException> onewayExchanger = this.exchanger;
        synchronized (onewayExchanger) {
            if (!(this.isDone() || this.taskIsActive && !mayInterruptIfRunning)) {
                this.exchanger.cancel();
                cancelTask = this.taskIsActive;
            }
        }
        if (cancelTask) {
            this.task.cancel();
        }
        return cancelTask;
    }

    @Override
    public final boolean isCancelled() {
        return this.exchanger.isCancelled();
    }

    @Override
    public final boolean isDone() {
        return this.exchanger.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        BlockingDHTFutureListener listener = new BlockingDHTFutureListener();
        this.addDHTFutureListener(listener);
        return listener.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        BlockingDHTFutureListener listener = new BlockingDHTFutureListener();
        this.addDHTFutureListener(listener);
        return listener.get(timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DHTFutureListener<T>[] listeners() {
        Set<DHTFutureListener<T>> set = this.listeners;
        synchronized (set) {
            return this.listeners.toArray(new DHTFutureListener[0]);
        }
    }

    protected void fireFutureResult(T value) {
        for (DHTFutureListener<T> l : this.listeners()) {
            l.handleFutureSuccess(value);
        }
    }

    protected void fireExecutionException(ExecutionException e) {
        for (DHTFutureListener<T> l : this.listeners()) {
            l.handleExecutionException(e);
        }
    }

    protected void fireCancellationException(CancellationException e) {
        for (DHTFutureListener<T> l : this.listeners()) {
            l.handleCancellationException(e);
        }
    }

    protected void fireInterruptedException(InterruptedException e) {
        for (DHTFutureListener<T> l : this.listeners) {
            l.handleInterruptedException(e);
        }
    }
}

