/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.libtorrent;

import com.sun.jna.Structure;
import org.limewire.bittorrent.ProxySetting;
import org.limewire.bittorrent.ProxySettingType;
import org.limewire.libtorrent.LibTorrentProxySettingType;

public class LibTorrentProxySetting
extends Structure
implements ProxySetting {
    public String hostname;
    public int port;
    public String username;
    public String password;
    public int type;

    public LibTorrentProxySetting(LibTorrentProxySettingType type, String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
        this.type = type.getId();
        this.username = "";
        this.password = "";
    }

    public LibTorrentProxySetting(ProxySetting proxy) {
        this.hostname = proxy.getHostname();
        this.port = proxy.getPort();
        this.username = proxy.getUsername();
        this.password = proxy.getPassword();
        this.type = LibTorrentProxySettingType.forProxySettingType(proxy.getType()).getId();
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public ProxySettingType getType() {
        return LibTorrentProxySettingType.forId(this.type).getProxySettingType();
    }

    public static LibTorrentProxySetting nullProxy() {
        LibTorrentProxySetting setting = new LibTorrentProxySetting(LibTorrentProxySettingType.NONE, "", 0);
        return setting;
    }
}

