/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.inject;

import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Stage;
import java.util.Map;
import java.util.logging.Logger;
import org.limewire.inject.MoreScopes;

public class Modules {
    private Modules() {
    }

    public static Module providersFrom(final Injector parent) {
        return new Module(){

            @Override
            public void configure(Binder binder) {
                Key<Logger> loggerKey = Key.get(Logger.class);
                Key<Injector> injectorKey = Key.get(Injector.class);
                Key<Stage> stageKey = Key.get(Stage.class);
                for (Map.Entry<Key<?>, Binding<?>> entry : parent.getAllBindings().entrySet()) {
                    Key<?> key = entry.getKey();
                    Binding<?> binding = entry.getValue();
                    Scope scope = MoreScopes.getLinkedScope(binding);
                    if (key.equals(loggerKey) || key.equals(injectorKey) || key.equals(stageKey) || key.getTypeLiteral().getRawType().equals(Provider.class)) continue;
                    binder.bind(key).toProvider(binding.getProvider()).in(scope);
                }
            }
        };
    }
}

