/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.friend.api;

import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.concurrent.ListeningExecutorService;
import org.limewire.friend.api.FriendConnectionEvent;
import org.limewire.friend.api.FriendEvent;
import org.limewire.friend.api.FriendPresenceEvent;
import org.limewire.friend.api.LibraryChangedEvent;
import org.limewire.friend.api.feature.FeatureEvent;
import org.limewire.friend.impl.address.FriendAddressRegistry;
import org.limewire.friend.impl.address.FriendAddressResolver;
import org.limewire.friend.impl.address.FriendAddressSerializer;
import org.limewire.listener.AsynchronousCachingEventMulticasterImpl;
import org.limewire.listener.AsynchronousEventBroadcaster;
import org.limewire.listener.AsynchronousEventMulticaster;
import org.limewire.listener.BroadcastPolicy;
import org.limewire.listener.EventBean;
import org.limewire.listener.EventBroadcaster;
import org.limewire.listener.EventMulticaster;
import org.limewire.listener.EventMulticasterImpl;
import org.limewire.listener.ListenerSupport;
import org.limewire.logging.LogFactory;

public class LimeWireFriendModule
extends AbstractModule {
    @Override
    protected void configure() {
        EventMulticasterImpl knownMulticaster = new EventMulticasterImpl(FriendEvent.class);
        EventMulticasterImpl availMulticaster = new EventMulticasterImpl();
        EventMulticasterImpl presenceMulticaster = new EventMulticasterImpl();
        EventMulticasterImpl featureMulticaster = new EventMulticasterImpl();
        this.bind(new TypeLiteral<ListenerSupport<FriendEvent>>(){}).annotatedWith(Names.named("known")).toInstance(knownMulticaster);
        this.bind(new TypeLiteral<EventBroadcaster<FriendEvent>>(){}).annotatedWith(Names.named("known")).toInstance(knownMulticaster);
        this.bind(new TypeLiteral<ListenerSupport<FriendEvent>>(){}).annotatedWith(Names.named("available")).toInstance(availMulticaster);
        this.bind(new TypeLiteral<EventBroadcaster<FriendEvent>>(){}).annotatedWith(Names.named("available")).toInstance(availMulticaster);
        this.bind(new TypeLiteral<ListenerSupport<FriendPresenceEvent>>(){}).toInstance(presenceMulticaster);
        this.bind(new TypeLiteral<EventBroadcaster<FriendPresenceEvent>>(){}).toInstance(presenceMulticaster);
        this.bind(new TypeLiteral<ListenerSupport<FeatureEvent>>(){}).toInstance(featureMulticaster);
        this.bind(new TypeLiteral<EventMulticaster<FeatureEvent>>(){}).toInstance(featureMulticaster);
        this.bind(new TypeLiteral<EventBroadcaster<FeatureEvent>>(){}).toInstance(featureMulticaster);
        ListeningExecutorService executor = ExecutorsHelper.newProcessingQueue("FriendConnectionEventThread");
        AsynchronousCachingEventMulticasterImpl asyncConnectionMulticaster = new AsynchronousCachingEventMulticasterImpl(executor, BroadcastPolicy.IF_NOT_EQUALS, LogFactory.getLog(FriendConnectionEvent.class));
        this.bind(new TypeLiteral<EventBean<FriendConnectionEvent>>(){}).toInstance(asyncConnectionMulticaster);
        this.bind(new TypeLiteral<EventMulticaster<FriendConnectionEvent>>(){}).toInstance(asyncConnectionMulticaster);
        this.bind(new TypeLiteral<AsynchronousEventMulticaster<FriendConnectionEvent>>(){}).toInstance(asyncConnectionMulticaster);
        this.bind(new TypeLiteral<AsynchronousEventBroadcaster<FriendConnectionEvent>>(){}).toInstance(asyncConnectionMulticaster);
        this.bind(new TypeLiteral<ListenerSupport<FriendConnectionEvent>>(){}).toInstance(asyncConnectionMulticaster);
        EventMulticasterImpl libraryChangedMulticaster = new EventMulticasterImpl();
        this.bind(new TypeLiteral<EventBroadcaster<LibraryChangedEvent>>(){}).toInstance(libraryChangedMulticaster);
        this.bind(new TypeLiteral<ListenerSupport<LibraryChangedEvent>>(){}).toInstance(libraryChangedMulticaster);
        this.bind(FriendAddressResolver.class).asEagerSingleton();
        this.bind(FriendAddressSerializer.class).asEagerSingleton();
        this.bind(FriendAddressRegistry.class);
    }
}

