/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.friend.api;

import java.net.URI;
import java.util.Collection;
import org.limewire.friend.api.Friend;
import org.limewire.friend.api.feature.Feature;
import org.limewire.friend.api.feature.FeatureTransport;
import org.limewire.i18n.I18nMarker;

public interface FriendPresence {
    public static final int MIN_PRIORITY = -127;
    public static final int MAX_PRIORITY = 127;

    public Friend getFriend();

    public String getPresenceId();

    public Collection<Feature> getFeatures();

    public Feature getFeature(URI var1);

    public boolean hasFeatures(URI ... var1);

    public void addFeature(Feature var1);

    public void removeFeature(URI var1);

    public <F extends Feature<D>, D> FeatureTransport<D> getTransport(Class<F> var1);

    public <D, F extends Feature<D>> void addTransport(Class<F> var1, FeatureTransport<D> var2);

    public Type getType();

    public String getStatus();

    public int getPriority();

    public Mode getMode();

    public static enum Mode {
        chat(I18nMarker.marktr("Free to chat"), 0),
        available(I18nMarker.marktr("Available"), 1),
        away(I18nMarker.marktr("Away"), 2),
        xa(I18nMarker.marktr("Away for a while"), 2),
        dnd(I18nMarker.marktr("Do not disturb"), 3);

        private final String name;
        private final int order;

        private Mode(String name, int order) {
            this.name = name;
            this.order = order;
        }

        public int getOrder() {
            return this.order;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Type {
        available,
        unavailable,
        subscribe,
        subscribed,
        unsubscribe,
        unsubscribed,
        error;

    }
}

