/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.settings;

import org.limewire.core.settings.LimeProps;
import org.limewire.inspection.DataCategory;
import org.limewire.inspection.InspectionPoint;
import org.limewire.setting.BooleanSetting;
import org.limewire.setting.FloatSetting;
import org.limewire.setting.IntSetting;
import org.limewire.setting.LongSetting;
import org.limewire.setting.StringArraySetting;
import org.limewire.setting.StringSetting;
import org.limewire.util.OSUtils;

public class ApplicationSettings
extends LimeProps {
    @InspectionPoint(value="client id")
    public static final StringSetting CLIENT_ID = FACTORY.createStringSetting("CLIENT_ID", "");
    @InspectionPoint(value="average application uptime", category=DataCategory.USAGE)
    public static final LongSetting AVERAGE_UPTIME = FACTORY.createExpirableLongSetting("AVERAGE_UPTIME", 0L);
    @InspectionPoint(value="last n application uptimes", category=DataCategory.USAGE)
    public static final StringArraySetting UPTIME_HISTORY = FACTORY.createStringArraySetting("UPTIME_HISTORY", new String[0]);
    @InspectionPoint(value="last n application downtimes", category=DataCategory.USAGE)
    public static final StringArraySetting DOWNTIME_HISTORY = FACTORY.createStringArraySetting("DOWNTIME_HISTORY", new String[0]);
    @InspectionPoint(value="total application uptime", category=DataCategory.USAGE)
    public static final LongSetting TOTAL_UPTIME = FACTORY.createLongSetting("TOTAL_UPTIME", 0L);
    public static final LongSetting AVERAGE_CONNECTION_TIME = FACTORY.createExpirableLongSetting("AVERAGE_CONNECTION_TIME", 0L);
    public static final LongSetting TOTAL_CONNECTION_TIME = FACTORY.createLongSetting("TOTAL_CONNECTION_TIME", 0L);
    public static final IntSetting TOTAL_CONNECTIONS = FACTORY.createIntSetting("TOTAL_CONNECTIONS", 0);
    @InspectionPoint(value="number of sessions", category=DataCategory.USAGE)
    public static final IntSetting SESSIONS = FACTORY.createIntSetting("SESSIONS", 0);
    @InspectionPoint(value="last shutdown time", category=DataCategory.USAGE)
    public static final LongSetting LAST_SHUTDOWN_TIME = FACTORY.createLongSetting("LAST_SHUTDOWN_TIME", 0L);
    @InspectionPoint(value="previous shutdown was graceful")
    public static final BooleanSetting PREVIOUS_SHUTDOWN_WAS_GRACEFUL = FACTORY.createBooleanSetting("PREVIOUS_SHUTDOWN_WAS_GRACEFUL", true);
    public static final BooleanSetting CURRENTLY_RUNNING = FACTORY.createBooleanSetting("CURRENTLY_RUNNING", false);
    public static final FloatSetting FRACTIONAL_UPTIME = FACTORY.createFloatSetting("FRACTIONAL_UPTIME", 0.0f);
    public static final StringSetting LANGUAGE = FACTORY.createStringSetting("LANGUAGE", System.getProperty("user.language", ""));
    public static final StringSetting COUNTRY = FACTORY.createStringSetting("COUNTRY", System.getProperty("user.country", ""));
    public static final StringSetting LOCALE_VARIANT = FACTORY.createStringSetting("LOCALE_VARIANT", System.getProperty("user.variant", ""));
    public static final BooleanSetting AUTOMATIC_MANUAL_GC = FACTORY.createBooleanSetting("AUTOMATIC_MANUAL_GC", OSUtils.isMacOSX());
    public static final StringSetting DEFAULT_LOCALE = FACTORY.createStringSetting("DEFAULT_LOCALE", "en");
    public static final BooleanSetting USE_SECURE_RESULTS = FACTORY.createBooleanSetting("USE_SECURE_RESULTS", true);
    @InspectionPoint(value="anonymous usage statistics")
    public static final BooleanSetting ALLOW_ANONYMOUS_STATISTICS_GATHERING = FACTORY.createBooleanSetting("ALLOW_ANONYMOUS_STATISTICS_GATHERING", true);
    public static final BooleanSetting INITIALIZE_SIMPP = FACTORY.createBooleanSetting("INITIALIZE_SIMPP", true);

    private ApplicationSettings() {
    }

    public static String getLanguage() {
        String lc = LANGUAGE.get();
        String cc = COUNTRY.get();
        String lv = LOCALE_VARIANT.get();
        String lang = lc;
        if (cc != null && !cc.equals("")) {
            lang = lang + "_" + cc;
        }
        if (lv != null && !lv.equals("")) {
            lang = lang + "_" + lv;
        }
        return lang;
    }
}

