/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.search.browse;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import org.limewire.core.api.browse.BrowseFactory;
import org.limewire.core.api.library.RemoteLibraryManager;
import org.limewire.core.api.search.browse.BrowseSearch;
import org.limewire.core.api.search.browse.BrowseSearchFactory;
import org.limewire.core.impl.search.browse.AllFriendsBrowseSearch;
import org.limewire.core.impl.search.browse.AnonymousSingleBrowseSearch;
import org.limewire.core.impl.search.browse.FriendSingleBrowseSearch;
import org.limewire.core.impl.search.browse.MultipleBrowseSearch;
import org.limewire.friend.api.Friend;
import org.limewire.friend.api.FriendPresence;
import org.limewire.inject.LazySingleton;

@LazySingleton
class CoreBrowseSearchFactory
implements BrowseSearchFactory {
    private final RemoteLibraryManager remoteLibraryManager;
    private final BrowseFactory browseFactory;
    private final ExecutorService backgroundExecutor;

    @Inject
    public CoreBrowseSearchFactory(RemoteLibraryManager remoteLibraryManager, BrowseFactory browseFactory, @Named(value="backgroundExecutor") ExecutorService backgroundExecutor) {
        this.remoteLibraryManager = remoteLibraryManager;
        this.browseFactory = browseFactory;
        this.backgroundExecutor = backgroundExecutor;
    }

    @Override
    public BrowseSearch createFriendBrowseSearch(Friend friend) {
        assert (friend != null && !friend.isAnonymous());
        return new FriendSingleBrowseSearch(this.remoteLibraryManager, friend, this.backgroundExecutor);
    }

    @Override
    public BrowseSearch createBrowseSearch(FriendPresence presence) {
        assert (presence != null);
        if (presence.getFriend().isAnonymous()) {
            return new AnonymousSingleBrowseSearch(this.browseFactory, presence);
        }
        return this.createFriendBrowseSearch(presence.getFriend());
    }

    @Override
    public BrowseSearch createBrowseSearch(Collection<FriendPresence> presences) {
        return new MultipleBrowseSearch(this, presences);
    }

    @Override
    public BrowseSearch createAllFriendsBrowseSearch() {
        return new AllFriendsBrowseSearch(this.remoteLibraryManager, this.backgroundExecutor);
    }
}

