/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.search.browse;

import org.limewire.core.api.browse.Browse;
import org.limewire.core.api.browse.BrowseFactory;
import org.limewire.core.api.browse.BrowseListener;
import org.limewire.core.api.search.SearchListener;
import org.limewire.core.api.search.SearchResult;
import org.limewire.core.api.search.browse.BrowseStatus;
import org.limewire.core.impl.search.browse.AbstractBrowseSearch;
import org.limewire.friend.api.Friend;
import org.limewire.friend.api.FriendPresence;

class AnonymousSingleBrowseSearch
extends AbstractBrowseSearch {
    private final FriendPresence friendPresence;
    private final BrowseFactory browseFactory;
    private Browse browse;

    public AnonymousSingleBrowseSearch(BrowseFactory browseFactory, FriendPresence friendPresence) {
        assert (friendPresence != null && friendPresence.getFriend().isAnonymous());
        this.friendPresence = friendPresence;
        this.browseFactory = browseFactory;
    }

    @Override
    public void start() {
        for (SearchListener listener : this.searchListeners) {
            listener.searchStarted(this);
        }
        this.browse = this.browseFactory.createBrowse(this.friendPresence);
        this.browse.start(new BrowseEventForwarder());
    }

    @Override
    public void stop() {
        assert (this.browse != null);
        this.browse.stop();
    }

    @Override
    public void repeat() {
        this.stop();
        this.start();
    }

    private class BrowseEventForwarder
    implements BrowseListener {
        private BrowseEventForwarder() {
        }

        @Override
        public void browseFinished(boolean success) {
            BrowseStatus status = success ? new BrowseStatus(AnonymousSingleBrowseSearch.this, BrowseStatus.BrowseState.LOADED, new Friend[0]) : new BrowseStatus(AnonymousSingleBrowseSearch.this, BrowseStatus.BrowseState.FAILED, AnonymousSingleBrowseSearch.this.friendPresence.getFriend());
            for (Object listener : AnonymousSingleBrowseSearch.this.searchListeners) {
                listener.searchStopped(AnonymousSingleBrowseSearch.this);
            }
            for (Object listener : AnonymousSingleBrowseSearch.this.browseStatusListeners) {
                listener.statusChanged(status);
            }
        }

        @Override
        public void handleBrowseResult(SearchResult searchResult) {
            for (SearchListener listener : AnonymousSingleBrowseSearch.this.searchListeners) {
                listener.handleSearchResult(AnonymousSingleBrowseSearch.this, searchResult);
            }
        }
    }
}

