/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.friend;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.limegroup.gnutella.library.FileViewChangeEvent;
import com.limegroup.gnutella.library.FileViewManager;
import com.limegroup.gnutella.library.Library;
import com.limegroup.gnutella.library.LibraryStatusEvent;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.limewire.collection.Periodic;
import org.limewire.core.api.browse.server.BrowseTracker;
import org.limewire.friend.api.Friend;
import org.limewire.friend.api.FriendEvent;
import org.limewire.friend.api.FriendException;
import org.limewire.friend.api.FriendPresence;
import org.limewire.friend.api.feature.Feature;
import org.limewire.friend.api.feature.FeatureTransport;
import org.limewire.friend.api.feature.LibraryChangedNotifierFeature;
import org.limewire.inject.EagerSingleton;
import org.limewire.listener.BlockingEvent;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.Clock;

@EagerSingleton
class FriendShareListRefresher {
    private static final Log LOG = LogFactory.getLog(FriendShareListRefresher.class);
    private final Clock clock;
    private final BrowseTracker tracker;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Map<String, Friend> friendMap;
    private final ConcurrentMap<String, LibraryChangedSender> changeSenders;
    final AtomicBoolean fileManagerLoaded = new AtomicBoolean(false);

    @Inject
    FriendShareListRefresher(Clock clock, BrowseTracker tracker, @Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, @Named(value="available") Map<String, Friend> friendMap) {
        this.clock = clock;
        this.tracker = tracker;
        this.scheduledExecutorService = scheduledExecutorService;
        this.changeSenders = new ConcurrentHashMap<String, LibraryChangedSender>();
        this.friendMap = friendMap;
    }

    @Inject
    void register(Library library) {
        library.addManagedListStatusListener(new FinishedLoadingListener());
    }

    @Inject
    void register(final FileViewManager fileViewManager, @Named(value="available") ListenerSupport<FriendEvent> friendSupport) {
        fileViewManager.addListener(new EventListener<FileViewChangeEvent>(){

            @Override
            public void handleEvent(FileViewChangeEvent event) {
                switch (event.getType()) {
                    case FILE_ADDED: 
                    case FILE_REMOVED: 
                    case FILE_META_CHANGED: 
                    case FILE_CHANGED: 
                    case FILES_CLEARED: {
                        FriendShareListRefresher.this.triggerChangeSender(event.getSource().getName());
                    }
                }
            }
        });
        friendSupport.addListener(new EventListener<FriendEvent>(){

            @Override
            public void handleEvent(FriendEvent event) {
                LOG.debugf("Received friend event {0}", (Object)event);
                switch ((FriendEvent.Type)((Object)event.getType())) {
                    case DELETE: 
                    case REMOVED: {
                        FriendShareListRefresher.this.removeChangeSender(((Friend)event.getData()).getId());
                        break;
                    }
                    case ADDED: {
                        fileViewManager.getFileViewForId(((Friend)event.getData()).getId());
                    }
                }
            }
        });
    }

    private void triggerChangeSender(String id) {
        LOG.debugf("Change triggered for id {0}", (Object)id);
        if (this.fileManagerLoaded.get()) {
            Friend friend = this.friendMap.get(id);
            if (friend != null) {
                LOG.debugf("Triggering library change for friend {0}", (Object)friend);
                LibraryChangedSender sender = (LibraryChangedSender)this.changeSenders.get(id);
                if (sender == null) {
                    LOG.debugf("No existing sender for friend {0}, creating a new one", (Object)friend);
                    LibraryChangedSender newSender = new LibraryChangedSender(friend);
                    sender = this.changeSenders.putIfAbsent(id, newSender);
                    if (sender == null) {
                        sender = newSender;
                    }
                }
                sender.scheduleSendRefreshCheck();
            } else {
                LOG.debugf("Not triggering library change for id {0} because no friend was available", (Object)id);
            }
        }
    }

    private void removeChangeSender(String id) {
        LibraryChangedSender sender = (LibraryChangedSender)this.changeSenders.remove(id);
        if (sender != null) {
            LOG.debugf("Removing change trigger for id {0}", (Object)id);
            sender.cancel();
        }
    }

    void sendRefreshNotificationsToPresences(Iterable<FriendPresence> presences) {
        for (FriendPresence presence : presences) {
            Feature feature = presence.getFeature(LibraryChangedNotifierFeature.ID);
            if (feature != null) {
                FeatureTransport transport = presence.getTransport(LibraryChangedNotifierFeature.class);
                try {
                    transport.sendFeature(presence, feature.getFeature());
                }
                catch (FriendException e) {
                    LOG.error("library changed notification failed", e);
                }
                continue;
            }
            LOG.debugf("no library refresh for presence: {0}", (Object)presence);
        }
    }

    private class LibraryChangedSender {
        private final Friend friend;
        private final Periodic libraryRefreshPeriodic;

        LibraryChangedSender(Friend friend) {
            this.friend = friend;
            this.libraryRefreshPeriodic = new Periodic(new ScheduledLibraryRefreshSender(), FriendShareListRefresher.this.scheduledExecutorService, FriendShareListRefresher.this.clock);
        }

        void scheduleSendRefreshCheck() {
            this.libraryRefreshPeriodic.rescheduleIfLater(5000L);
        }

        void cancel() {
            this.libraryRefreshPeriodic.unschedule();
        }

        private class ScheduledLibraryRefreshSender
        implements Runnable {
            private ScheduledLibraryRefreshSender() {
            }

            @Override
            public void run() {
                BrowseTracker browseTracker = FriendShareListRefresher.this.tracker;
                Date lastBrowseTime = browseTracker.lastBrowseTime(LibraryChangedSender.this.friend.getId());
                Date lastRefreshTime = browseTracker.lastRefreshTime(LibraryChangedSender.this.friend.getId());
                LOG.debugf("Running library periodic for friend {0}, lastBrowseTime {1}, lastRefreshTime {2}", (Object)LibraryChangedSender.this.friend, (Object)lastBrowseTime, (Object)lastRefreshTime);
                if (lastBrowseTime != null && (lastRefreshTime == null || lastBrowseTime.after(lastRefreshTime))) {
                    browseTracker.sentRefresh(LibraryChangedSender.this.friend.getId());
                    FriendShareListRefresher.this.sendRefreshNotificationsToPresences(LibraryChangedSender.this.friend.getPresences().values());
                }
            }
        }
    }

    private class FinishedLoadingListener
    implements EventListener<LibraryStatusEvent> {
        private FinishedLoadingListener() {
        }

        @Override
        @BlockingEvent
        public void handleEvent(LibraryStatusEvent evt) {
            switch (evt.getType()) {
                case LOAD_COMPLETE: {
                    FriendShareListRefresher.this.fileManagerLoaded.set(true);
                    for (Friend friend : FriendShareListRefresher.this.friendMap.values()) {
                        FriendShareListRefresher.this.tracker.sentRefresh(friend.getId());
                        FriendShareListRefresher.this.sendRefreshNotificationsToPresences(friend.getPresences().values());
                    }
                    break;
                }
            }
        }
    }
}

