/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.api;

import java.util.Collection;
import java.util.EnumSet;

public enum FilePropertyKey {
    TITLE(false),
    AUTHOR(false),
    BITRATE(true),
    DESCRIPTION(false),
    COMPANY(false),
    DATE_CREATED(true),
    FILE_SIZE(true),
    GENRE(false),
    HEIGHT(true),
    LENGTH(true),
    NAME(false),
    PLATFORM(false),
    QUALITY(true),
    RATING(false),
    TRACK_NUMBER(false),
    ALBUM(false),
    WIDTH(true),
    LOCATION(false),
    YEAR(true);

    private static final Collection<FilePropertyKey> indexableKeys;
    private static final Collection<FilePropertyKey> editableKeys;
    private static final Collection<FilePropertyKey> filterableKeys;
    private final boolean isLongKey;

    private FilePropertyKey(boolean isLongKey) {
        this.isLongKey = isLongKey;
    }

    public static Collection<FilePropertyKey> getIndexableKeys() {
        return indexableKeys;
    }

    public static Collection<FilePropertyKey> getFilterableKeys() {
        return filterableKeys;
    }

    public static Collection<FilePropertyKey> getEditableKeys() {
        return editableKeys;
    }

    public static boolean isLong(FilePropertyKey key) {
        return key.isLongKey;
    }

    static {
        indexableKeys = EnumSet.noneOf(FilePropertyKey.class);
        editableKeys = EnumSet.noneOf(FilePropertyKey.class);
        filterableKeys = EnumSet.noneOf(FilePropertyKey.class);
        indexableKeys.add(ALBUM);
        indexableKeys.add(TITLE);
        indexableKeys.add(AUTHOR);
        indexableKeys.add(DESCRIPTION);
        indexableKeys.add(COMPANY);
        indexableKeys.add(NAME);
        indexableKeys.add(PLATFORM);
        filterableKeys.add(ALBUM);
        filterableKeys.add(TITLE);
        filterableKeys.add(AUTHOR);
        filterableKeys.add(DESCRIPTION);
        filterableKeys.add(COMPANY);
        filterableKeys.add(GENRE);
        filterableKeys.add(NAME);
        filterableKeys.add(PLATFORM);
        editableKeys.add(ALBUM);
        editableKeys.add(AUTHOR);
        editableKeys.add(DESCRIPTION);
        editableKeys.add(COMPANY);
        editableKeys.add(GENRE);
        editableKeys.add(PLATFORM);
        editableKeys.add(TITLE);
        editableKeys.add(TRACK_NUMBER);
        editableKeys.add(YEAR);
        editableKeys.add(RATING);
    }
}

