/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.limewire.concurrent.ExecutorsHelper;

public class ThreadExecutor {
    private static final ThreadFactory FACTORY = ExecutorsHelper.daemonThreadFactory("IdleThread");
    private static final ExecutorService THREAD_POOL = ExecutorsHelper.newThreadPool(FACTORY);

    public static Thread newManagedThread(Runnable r) {
        return FACTORY.newThread(r);
    }

    public static Thread newManagedThread(Runnable r, String name) {
        Thread thread = ThreadExecutor.newManagedThread(r);
        thread.setName(name);
        return thread;
    }

    public static void startThread(final Runnable runner, final String name) {
        THREAD_POOL.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Thread.currentThread().setName(name);
                    runner.run();
                }
                catch (Throwable t) {
                    Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), t);
                }
                finally {
                    Thread.currentThread().setName("IdleThread");
                }
            }
        });
    }
}

