/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.activation.serial;

import com.google.inject.Inject;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.activation.api.ActivationSettingsController;
import org.limewire.activation.serial.ActivationSerializer;
import org.limewire.activation.serial.ActivationSerializerSettings;
import org.limewire.io.IOUtils;
import org.limewire.security.certificate.CipherProvider;
import org.limewire.util.Base32;
import org.limewire.util.FileUtils;
import org.limewire.util.StringUtils;

class ActivationSerializerImpl
implements ActivationSerializer {
    private static final String ENCRYPTION_ALGORITHM = "AES";
    private static final CipherProvider.CipherType CIPHER_TYPE = CipherProvider.CipherType.AES;
    private static final Log LOG = LogFactory.getLog(ActivationSerializerImpl.class);
    private final ActivationSerializerSettings settings;
    private final CipherProvider cipherProvider;
    private final ActivationSettingsController activationSettings;

    @Inject
    public ActivationSerializerImpl(ActivationSerializerSettings settings, CipherProvider cipherProvider, ActivationSettingsController activationSettings) {
        this.settings = settings;
        this.cipherProvider = cipherProvider;
        this.activationSettings = activationSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readFromDisk() throws IOException {
        Throwable exception;
        String string;
        if (!this.settings.getSaveFile().exists() && !this.settings.getBackupFile().exists()) {
            return null;
        }
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.settings.getSaveFile())));
            String encyrptedString = (String)in.readObject();
            string = this.decrypt(encyrptedString);
        }
        catch (Throwable ignored) {
            try {
                exception = ignored;
                LOG.warn("Error reading normal file.", ignored);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.close(in);
            }
        }
        IOUtils.close(in);
        return string;
        try {
            in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.settings.getBackupFile())));
            String encyrptedString = (String)in.readObject();
            String string2 = this.decrypt(encyrptedString);
            return string2;
        }
        catch (Throwable ignored) {
            LOG.warn("Error reading backup file.", ignored);
        }
        finally {
            IOUtils.close(in);
        }
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        throw (IOException)new IOException().initCause(exception);
    }

    @Override
    public boolean writeToDisk(String jsonString) throws IOException, GeneralSecurityException {
        String encrypted = this.encrypt(jsonString);
        return FileUtils.writeWithBackupFile(encrypted, this.settings.getBackupFile(), this.settings.getSaveFile(), LOG);
    }

    private String encrypt(String message) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, IOException {
        String key = this.getEncryptionKey();
        SecretKeySpec keySpec = new SecretKeySpec(new BigInteger(key, 16).toByteArray(), ENCRYPTION_ALGORITHM);
        byte[] encryptedBytes = this.cipherProvider.encrypt(StringUtils.toUTF8Bytes(message), keySpec, CIPHER_TYPE);
        return Base32.encode(encryptedBytes);
    }

    private String decrypt(String encryptedString) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException, IOException {
        String key = this.getEncryptionKey();
        SecretKeySpec keySpec = new SecretKeySpec(new BigInteger(key, 16).toByteArray(), ENCRYPTION_ALGORITHM);
        byte[] decryptedBytes = this.cipherProvider.decrypt(Base32.decode(encryptedString), keySpec, CIPHER_TYPE);
        return new String(decryptedBytes);
    }

    private String getEncryptionKey() {
        return this.activationSettings.getPassKey();
    }
}

