/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.activation.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.limewire.activation.api.ActivationItem;
import org.limewire.activation.impl.ActivationItemFactory;
import org.limewire.activation.impl.ActivationResponse;
import org.limewire.activation.impl.ActivationResponseFactory;
import org.limewire.io.InvalidDataException;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;

@Singleton
class ActivationResponseFactoryImpl
implements ActivationResponseFactory {
    private static Log LOG = LogFactory.getLog(ActivationResponseFactoryImpl.class);
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
    private final ActivationItemFactory activationItemFactory;

    @Inject
    public ActivationResponseFactoryImpl(ActivationItemFactory activationItemFactory) {
        this.activationItemFactory = activationItemFactory;
    }

    @Override
    public ActivationResponse createFromJson(String json) throws InvalidDataException {
        return this.createJson(json, false);
    }

    @Override
    public ActivationResponse createFromDiskJson(String json) throws InvalidDataException {
        return this.createJson(json, true);
    }

    @Override
    public ActivationResponse createErrorResponse(ActivationResponse.Type error) {
        return new ActivationResponse(null, null, error, null, null, 0, Collections.<ActivationItem>emptyList(), null);
    }

    private ActivationResponse createJson(String json, boolean loadedFromDisk) throws InvalidDataException {
        JSONTokener tokener = new JSONTokener(json);
        try {
            JSONObject parentObj = new JSONObject(tokener);
            String response = parentObj.getString("response");
            String lid = parentObj.getString("lid");
            ActivationResponse.Type type = ActivationResponse.Type.valueOf(response.toUpperCase());
            String mcode = parentObj.optString("mcode", null);
            String token = parentObj.optString("token", null);
            int refreshIntervalInMinutes = parentObj.optInt("refresh", 0);
            String optionalMessage = null;
            if (type == ActivationResponse.Type.ERROR) {
                optionalMessage = parentObj.getString("message");
            }
            LOG.debugf("Parsed response from json input, type: {0}", (Object)type);
            List<ActivationItem> items = this.parseActivationItems(parentObj, loadedFromDisk);
            return new ActivationResponse(json, lid, type, mcode, token, refreshIntervalInMinutes, items, optionalMessage);
        }
        catch (JSONException e) {
            throw new InvalidDataException("Error parsing JSON String " + json, e);
        }
        catch (ParseException e) {
            throw new InvalidDataException("Error parsing JSON String " + json, e);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidDataException("Error parsing JSON String due to unrecognized response type: " + json, e);
        }
    }

    private List<ActivationItem> parseActivationItems(JSONObject parentObj, boolean loadedFromDisk) throws ParseException, JSONException {
        if (!parentObj.has("modules")) {
            return Collections.emptyList();
        }
        ArrayList<ActivationItem> items = new ArrayList<ActivationItem>();
        JSONArray array = parentObj.getJSONArray("modules");
        for (int i = 0; i < array.length(); ++i) {
            JSONObject obj = array.getJSONObject(i);
            int moduleId = Integer.parseInt(obj.getString("id"));
            String moduleName = obj.getString("name");
            String purchaseDate = obj.getString("pur");
            String expDate = obj.getString("exp");
            ActivationItem.Status status = ActivationItem.Status.valueOf(obj.getString("status").toUpperCase());
            Date pur = formatter.parse(purchaseDate);
            Date exp = formatter.parse(expDate);
            ActivationItem item = loadedFromDisk ? this.activationItemFactory.createActivationItemFromDisk(moduleId, moduleName, pur, exp, status) : this.activationItemFactory.createActivationItem(moduleId, moduleName, pur, exp, status);
            items.add(item);
        }
        return items;
    }
}

