/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.packet.LastActivity;

public class LastActivityManager {
    private static final Log LOG = LogFactory.getLog(LastActivityManager.class);
    private long lastMessageSent;
    private XMPPConnection connection;

    private LastActivityManager(XMPPConnection connection) {
        this.connection = connection;
        connection.addPacketWriterListener(new PacketListener(){

            public void processPacket(Packet packet) {
                LastActivityManager.this.resetIdleTime();
            }
        }, null);
        connection.addPacketListener(new PacketListener(){

            public void processPacket(Packet packet) {
                LastActivity message = new LastActivity();
                message.setType(IQ.Type.RESULT);
                message.setTo(packet.getFrom());
                message.setFrom(packet.getTo());
                message.setPacketID(packet.getPacketID());
                message.setLastActivity(LastActivityManager.this.getIdleTime());
                try {
                    LastActivityManager.this.connection.sendPacket(message);
                }
                catch (XMPPException e) {
                    LOG.debug(e.getMessage(), e);
                }
            }
        }, new AndFilter(new IQTypeFilter(IQ.Type.GET), new PacketTypeFilter(LastActivity.class)));
    }

    private void resetIdleTime() {
        this.lastMessageSent = System.currentTimeMillis();
    }

    private long getIdleTime() {
        long now = System.currentTimeMillis();
        return (now - this.lastMessageSent) / 1000L;
    }

    public static LastActivity getLastActivity(XMPPConnection con, String jid) throws XMPPException {
        LastActivity activity = new LastActivity();
        activity.setTo(jid);
        PacketCollector collector = con.createPacketCollector(new PacketIDFilter(activity.getPacketID()));
        con.sendPacket(activity);
        LastActivity response = (LastActivity)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        return response;
    }

    static {
        XMPPConnection.addConnectionCreationListener(new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                new LastActivityManager(connection);
            }
        });
    }
}

