/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.PipelineEvent;
import org.jdesktop.swingx.decorator.PipelineListener;
import org.jdesktop.swingx.decorator.SelectionMapper;

public class DefaultSelectionMapper
implements SelectionMapper {
    private ListSelectionModel viewSelection;
    protected final DefaultListSelectionModel modelSelection = new DefaultListSelectionModel();
    private FilterPipeline pipeline;
    private ListSelectionListener viewSelectionListener;
    private boolean enabled = false;
    private PipelineListener pipelineListener;

    public DefaultSelectionMapper(FilterPipeline pipeline, ListSelectionModel selection) {
        this.setViewSelectionModel(selection);
        this.setEnabled(true);
        this.setFilters(pipeline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setViewSelectionModel(ListSelectionModel viewSelectionModel) {
        if (viewSelectionModel == null) {
            throw new IllegalArgumentException();
        }
        boolean wasEnabled = this.isEnabled();
        this.setEnabled(false);
        try {
            this.clearModelSelection();
            this.viewSelection = viewSelectionModel;
            this.mapTowardsModel();
        }
        finally {
            this.setEnabled(wasEnabled);
        }
    }

    public ListSelectionModel getViewSelectionModel() {
        return this.viewSelection;
    }

    public void setFilters(FilterPipeline pipeline) {
        FilterPipeline old = this.pipeline;
        if (old != null) {
            old.removePipelineListener(this.pipelineListener);
        }
        this.pipeline = pipeline;
        if (pipeline != null) {
            pipeline.addPipelineListener(this.getPipelineListener());
        }
        this.mapTowardsView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mapTowardsView() {
        if (!this.enabled) {
            return;
        }
        this.setEnabled(false);
        try {
            this.clearViewSelection();
            int[] selected = this.getSelectedRows(this.modelSelection);
            for (int i = 0; i < selected.length; ++i) {
                int index = this.convertToView(selected[i]);
                this.viewSelection.addSelectionInterval(index, index);
            }
            int lead = this.modelSelection.getLeadSelectionIndex();
            if (lead >= 0) {
                lead = this.convertToView(lead);
            }
            if (this.viewSelection instanceof DefaultListSelectionModel) {
                ((DefaultListSelectionModel)this.viewSelection).moveLeadSelectionIndex(lead);
            }
        }
        finally {
            this.setEnabled(true);
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled == this.enabled) {
            return;
        }
        this.enabled = enabled;
        if (enabled) {
            this.viewSelection.setValueIsAdjusting(false);
            this.viewSelection.addListSelectionListener(this.getViewSelectionListener());
        } else {
            this.viewSelection.removeListSelectionListener(this.viewSelectionListener);
            this.viewSelection.setValueIsAdjusting(true);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void clearModelSelection() {
        if (this.modelSelection == null) {
            return;
        }
        this.modelSelection.clearSelection();
        this.modelSelection.setAnchorSelectionIndex(-1);
        this.modelSelection.setLeadSelectionIndex(-1);
    }

    private void clearViewSelection() {
        this.viewSelection.clearSelection();
        this.viewSelection.setAnchorSelectionIndex(-1);
        this.viewSelection.setLeadSelectionIndex(-1);
    }

    public void insertIndexInterval(int start, int length, boolean before) {
        this.modelSelection.insertIndexInterval(start, length, before);
    }

    public void removeIndexInterval(int start, int end) {
        this.modelSelection.removeIndexInterval(start, end);
    }

    private void mapTowardsModel() {
        if (this.modelSelection == null) {
            return;
        }
        this.clearModelSelection();
        int[] selected = this.getSelectedRows(this.viewSelection);
        for (int i = 0; i < selected.length; ++i) {
            int modelIndex = this.convertToModel(selected[i]);
            this.modelSelection.addSelectionInterval(modelIndex, modelIndex);
        }
        if (selected.length > 0) {
            this.modelSelection.moveLeadSelectionIndex(this.convertToModel(this.viewSelection.getLeadSelectionIndex()));
        }
    }

    private int convertToModel(int index) {
        return this.pipeline != null && this.pipeline.isAssigned() ? this.pipeline.convertRowIndexToModel(index) : index;
    }

    private int convertToView(int index) {
        return this.pipeline != null && this.pipeline.isAssigned() ? this.pipeline.convertRowIndexToView(index) : index;
    }

    private void mapTowardsModel(int firstIndex, int lastIndex) {
        int safeFirstIndex = Math.max(0, firstIndex);
        int safeLastIndex = this.getSafeLastIndex(lastIndex);
        for (int i = safeFirstIndex; i <= safeLastIndex; ++i) {
            int modelIndex = this.convertToModel(i);
            if (this.viewSelection.isSelectedIndex(i)) {
                this.modelSelection.addSelectionInterval(modelIndex, modelIndex);
                continue;
            }
            this.modelSelection.removeSelectionInterval(modelIndex, modelIndex);
        }
        int lead = this.viewSelection.getLeadSelectionIndex();
        if (lead >= 0) {
            this.modelSelection.moveLeadSelectionIndex(this.convertToModel(lead));
        }
    }

    private int getSafeLastIndex(int lastIndex) {
        if (this.pipeline == null || !this.pipeline.isAssigned()) {
            return lastIndex;
        }
        return Math.min(lastIndex, this.pipeline.getOutputSize() - 1);
    }

    private int[] getSelectedRows(ListSelectionModel selection) {
        int iMin = selection.getMinSelectionIndex();
        int iMax = selection.getMaxSelectionIndex();
        if (iMin == -1 || iMax == -1) {
            return new int[0];
        }
        int[] rvTmp = new int[1 + (iMax - iMin)];
        int n = 0;
        for (int i = iMin; i <= iMax; ++i) {
            if (!selection.isSelectedIndex(i)) continue;
            rvTmp[n++] = i;
        }
        int[] rv = new int[n];
        System.arraycopy(rvTmp, 0, rv, 0, n);
        return rv;
    }

    private PipelineListener getPipelineListener() {
        if (this.pipelineListener == null) {
            this.pipelineListener = new PipelineListener(){

                public void contentsChanged(PipelineEvent e) {
                    DefaultSelectionMapper.this.mapTowardsView();
                }
            };
        }
        return this.pipelineListener;
    }

    private ListSelectionListener getViewSelectionListener() {
        if (this.viewSelectionListener == null) {
            this.viewSelectionListener = new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    DefaultSelectionMapper.this.mapTowardsModel(e.getFirstIndex(), e.getLastIndex());
                }
            };
        }
        return this.viewSelectionListener;
    }
}

