/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.transitions;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.transitions.ComponentState;

public abstract class Effect {
    private ComponentState start;
    private ComponentState end;
    private boolean renderComponent = false;
    private Image componentImage;
    private int x;
    private int y;
    private int width;
    private int height;
    private Rectangle bounds = new Rectangle();
    private Point location = new Point();

    public void setBounds(int x, int y, int width, int height) {
        this.location.x = this.x = x;
        this.bounds.x = this.x;
        this.location.y = this.y = y;
        this.bounds.y = this.y;
        this.setWidth(width);
        this.setHeight(height);
    }

    public void setBounds(Rectangle bounds) {
        this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void setLocation(Point location) {
        this.bounds.x = this.x = location.x;
        this.location.x = this.x;
        this.bounds.y = this.y = location.y;
        this.location.y = this.y;
    }

    public void setX(int x) {
        this.bounds.x = this.x = x;
        this.location.x = this.x;
    }

    public void setY(int y) {
        this.bounds.y = this.y = y;
        this.location.y = this.y;
    }

    public void setWidth(int width) {
        this.bounds.width = this.width = width;
    }

    public void setHeight(int height) {
        this.bounds.height = this.height = height;
    }

    protected JComponent getComponent() {
        if (this.start != null) {
            return this.start.getComponent();
        }
        if (this.end != null) {
            return this.end.getComponent();
        }
        return null;
    }

    public void init(Animator animator, Effect parentEffect) {
        this.bounds = new Rectangle();
        if (this.start != null) {
            this.setBounds(this.start.getX(), this.start.getY(), this.start.getWidth(), this.start.getHeight());
        } else {
            this.setBounds(this.end.getX(), this.end.getY(), this.end.getWidth(), this.end.getHeight());
        }
        if (this.componentImage != null && (this.start != null && this.start.getWidth() != this.componentImage.getWidth(null) || this.end != null && this.end.getWidth() != this.componentImage.getWidth(null))) {
            this.componentImage.flush();
            this.componentImage = null;
        }
    }

    public void cleanup(Animator animator) {
    }

    public void setRenderComponent(boolean renderComponent) {
        this.renderComponent = renderComponent;
    }

    public boolean getRenderComponent() {
        return this.renderComponent;
    }

    public void setComponentStates(ComponentState start, ComponentState end) {
        this.start = start;
        this.end = end;
    }

    public void setStart(ComponentState start) {
        this.start = start;
    }

    public ComponentState getStart() {
        return this.start;
    }

    public void setEnd(ComponentState end) {
        this.end = end;
    }

    public ComponentState getEnd() {
        return this.end;
    }

    public Image getComponentImage() {
        return this.componentImage;
    }

    protected void setComponentImage(Image componentImage) {
        this.componentImage = componentImage;
    }

    private void createComponentImage() {
        if (this.start != null && this.end == null) {
            this.componentImage = this.start.getSnapshot();
        } else if (this.start == null && this.end != null) {
            this.componentImage = this.end.getSnapshot();
        } else if (this.start.getWidth() != this.end.getWidth() || this.start.getHeight() != this.end.getHeight()) {
            float widthFraction = (float)this.end.getWidth() / (float)this.start.getWidth();
            float heightFraction = (float)this.end.getHeight() / (float)this.start.getHeight();
            this.componentImage = Math.abs(widthFraction - 1.0f) > Math.abs(heightFraction - 1.0f) ? (widthFraction < 1.0f ? this.start.getSnapshot() : this.end.getSnapshot()) : (heightFraction < 1.0f ? this.start.getSnapshot() : this.end.getSnapshot());
        } else {
            this.componentImage = this.start.getSnapshot();
        }
    }

    public void setup(Graphics2D g2d) {
        if (!this.renderComponent && this.componentImage == null) {
            this.createComponentImage();
        }
    }

    public void paint(Graphics2D g2d) {
        if (!this.renderComponent && this.componentImage != null) {
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2d.drawImage(this.componentImage, 0, 0, this.width, this.height, null);
        } else {
            this.getComponent().setBounds(this.bounds);
            this.getComponent().validate();
            ComponentState.paintSingleBuffered(this.getComponent(), g2d);
        }
    }

    void render(Graphics2D g2d) {
        g2d.translate(this.location.x, this.location.y);
        this.setup(g2d);
        this.paint(g2d);
    }
}

