/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.mp4.field;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.mp4.Mp4TagField;
import org.jaudiotagger.tag.mp4.atom.Mp4DataBox;
import org.jaudiotagger.tag.mp4.field.Mp4FieldType;

public class Mp4TagTextField
extends Mp4TagField
implements TagTextField {
    protected int dataSize;
    protected String content;

    public Mp4TagTextField(String id, ByteBuffer data) throws UnsupportedEncodingException {
        super(id, data);
    }

    public Mp4TagTextField(String id, String content) {
        super(id);
        this.content = content;
    }

    @Override
    protected void build(ByteBuffer data) throws UnsupportedEncodingException {
        Mp4BoxHeader header = new Mp4BoxHeader(data);
        Mp4DataBox databox = new Mp4DataBox(header, data);
        this.dataSize = header.getDataLength();
        this.content = databox.getContent();
    }

    @Override
    public void copyContent(TagField field) {
        if (field instanceof Mp4TagTextField) {
            this.content = ((Mp4TagTextField)field).getContent();
        }
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    protected byte[] getDataBytes() throws UnsupportedEncodingException {
        return this.content.getBytes(this.getEncoding());
    }

    @Override
    public Mp4FieldType getFieldType() {
        return Mp4FieldType.TEXT;
    }

    @Override
    public String getEncoding() {
        return "UTF-8";
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.content.trim().equals("");
    }

    @Override
    public void setContent(String s) {
        this.content = s;
    }

    @Override
    public void setEncoding(String s) {
    }

    @Override
    public String toString() {
        return this.content;
    }
}

