/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.datatype.Lyrics3TimeStamp;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;

public class Lyrics3Image
extends AbstractDataType {
    private Lyrics3TimeStamp time = null;
    private String description = "";
    private String filename = "";

    public Lyrics3Image(String identifier, AbstractTagFrameBody frameBody) {
        super(identifier, frameBody);
    }

    public Lyrics3Image(Lyrics3Image copy) {
        super(copy);
        this.time = new Lyrics3TimeStamp(copy.time);
        this.description = new String(copy.description);
        this.filename = new String(copy.filename);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public int getSize() {
        int size = this.filename.length() + 2 + this.description.length() + 2;
        if (this.time != null) {
            size += this.time.getSize();
        }
        return size;
    }

    public void setTimeStamp(Lyrics3TimeStamp time) {
        this.time = time;
    }

    public Lyrics3TimeStamp getTimeStamp() {
        return this.time;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Lyrics3Image)) {
            return false;
        }
        Lyrics3Image object = (Lyrics3Image)obj;
        if (!this.description.equals(object.description)) {
            return false;
        }
        if (!this.filename.equals(object.filename)) {
            return false;
        }
        if (this.time == null ? object.time != null : !this.time.equals(object.time)) {
            return false;
        }
        return super.equals(obj);
    }

    public void readString(String imageString, int offset) {
        if (imageString == null) {
            throw new NullPointerException("Image string is null");
        }
        if (offset < 0 || offset >= imageString.length()) {
            throw new IndexOutOfBoundsException("Offset to image string is out of bounds: offset = " + offset + ", string.length()" + imageString.length());
        }
        if (imageString != null) {
            int delim = imageString.indexOf("||", offset);
            this.filename = imageString.substring(offset, delim);
            offset = delim + 2;
            delim = imageString.indexOf("||", offset);
            this.description = imageString.substring(offset, delim);
            offset = delim + 2;
            String timestamp = imageString.substring(offset);
            if (timestamp.length() == 7) {
                this.time = new Lyrics3TimeStamp("Time Stamp");
                this.time.readString(timestamp);
            }
        }
    }

    public String toString() {
        String str = "filename = " + this.filename + ", description = " + this.description;
        if (this.time != null) {
            str = str + ", timestamp = " + this.time.toString();
        }
        return str + "\n";
    }

    public String writeString() {
        String str = "";
        str = this.filename == null ? "||" : this.filename + "||";
        str = this.description == null ? str + "||" : str + this.description + "||";
        if (this.time != null) {
            str = str + this.time.writeString();
        }
        return str;
    }

    @Override
    public void readByteArray(byte[] arr, int offset) throws InvalidDataTypeException {
        this.readString(arr.toString(), offset);
    }

    @Override
    public byte[] writeByteArray() {
        return Utils.getDefaultBytes(this.writeString(), "ISO-8859-1");
    }
}

