/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.exceptions.ModifyVetoException;
import org.jaudiotagger.audio.generic.AudioFileModificationListener;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.Tag;

public abstract class AudioFileWriter {
    private static final String TEMP_FILENAME_SUFFIX = ".tmp";
    private static final String WRITE_MODE = "rw";
    private static final int MINIMUM_FILESIZE = 150;
    private AudioFileModificationListener modificationListener = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void delete(AudioFile af) throws CannotReadException, CannotWriteException {
        File result;
        if (!af.getFile().canWrite()) {
            throw new CannotWriteException(ErrorMessage.GENERAL_DELETE_FAILED.getMsg(af.getFile().getPath()));
        }
        if (af.getFile().length() <= 150L) {
            throw new CannotWriteException(ErrorMessage.GENERAL_DELETE_FAILED.getMsg(af.getFile().getPath()));
        }
        RandomAccessFile raf = null;
        RandomAccessFile rafTemp = null;
        File tempF = null;
        boolean revert = false;
        try {
            tempF = File.createTempFile(af.getFile().getName().replace('.', '_'), TEMP_FILENAME_SUFFIX, af.getFile().getParentFile());
            rafTemp = new RandomAccessFile(tempF, WRITE_MODE);
            raf = new RandomAccessFile(af.getFile(), WRITE_MODE);
            raf.seek(0L);
            rafTemp.seek(0L);
            try {
                if (this.modificationListener != null) {
                    this.modificationListener.fileWillBeModified(af, true);
                }
                this.deleteTag(raf, rafTemp);
                if (this.modificationListener != null) {
                    this.modificationListener.fileModified(af, tempF);
                }
            }
            catch (ModifyVetoException veto) {
                throw new CannotWriteException(veto);
            }
            result = af.getFile();
        }
        catch (Exception e) {
            try {
                revert = true;
                throw new CannotWriteException("\"" + af.getFile().getAbsolutePath() + "\" :" + e, e);
            }
            catch (Throwable throwable) {
                File result2 = af.getFile();
                try {
                    if (raf != null) {
                        raf.close();
                    }
                    if (rafTemp != null) {
                        rafTemp.close();
                    }
                    if (tempF.length() > 0L && !revert) {
                        boolean deleteResult = af.getFile().delete();
                        if (!deleteResult) {
                            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_DELETE_ORIGINAL_FILE.getMsg(af.getFile().getPath(), tempF.getPath()));
                        }
                        boolean renameResult = tempF.renameTo(af.getFile());
                        if (!renameResult) {
                            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_TO_ORIGINAL_FILE.getMsg(af.getFile().getPath(), tempF.getPath()));
                        }
                        result2 = tempF;
                        if (tempF.exists() && tempF.delete()) {
                            // empty if block
                        }
                    } else if (tempF.delete()) {
                        // empty if block
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (this.modificationListener == null) throw throwable;
                this.modificationListener.fileOperationFinished(result2);
                throw throwable;
            }
        }
        try {
            if (raf != null) {
                raf.close();
            }
            if (rafTemp != null) {
                rafTemp.close();
            }
            if (tempF.length() > 0L && !revert) {
                boolean deleteResult = af.getFile().delete();
                if (!deleteResult) {
                    throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_DELETE_ORIGINAL_FILE.getMsg(af.getFile().getPath(), tempF.getPath()));
                }
                boolean renameResult = tempF.renameTo(af.getFile());
                if (!renameResult) {
                    throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_TO_ORIGINAL_FILE.getMsg(af.getFile().getPath(), tempF.getPath()));
                }
                result = tempF;
                if (tempF.exists() && tempF.delete()) {
                    // empty if block
                }
            } else if (tempF.delete()) {
                // empty if block
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.modificationListener == null) return;
        this.modificationListener.fileOperationFinished(result);
    }

    public synchronized void delete(RandomAccessFile raf, RandomAccessFile tempRaf) throws CannotReadException, CannotWriteException, IOException {
        raf.seek(0L);
        tempRaf.seek(0L);
        this.deleteTag(raf, tempRaf);
    }

    protected abstract void deleteTag(RandomAccessFile var1, RandomAccessFile var2) throws CannotReadException, CannotWriteException, IOException;

    public synchronized void setAudioFileModificationListener(AudioFileModificationListener listener) {
        this.modificationListener = listener;
    }

    private void precheckWrite(AudioFile af) throws CannotWriteException {
        try {
            if (af.getTag().isEmpty()) {
                this.delete(af);
                return;
            }
        }
        catch (CannotReadException re) {
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED.getMsg(af.getFile().getPath()));
        }
        if (!af.getFile().canWrite()) {
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED.getMsg(af.getFile().getPath()));
        }
        if (af.getFile().length() <= 150L) {
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE_FILE_IS_TOO_SMALL.getMsg(af.getFile().getPath()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void write(AudioFile af) throws CannotWriteException {
        this.precheckWrite(af);
        RandomAccessFile raf = null;
        RandomAccessFile rafTemp = null;
        File newFile = null;
        File result = null;
        try {
            newFile = File.createTempFile(af.getFile().getName().replace('.', '_'), TEMP_FILENAME_SUFFIX, af.getFile().getParentFile());
        }
        catch (IOException ioe) {
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_CREATE_TEMPORARY_FILE_IN_FOLDER.getMsg(af.getFile().getName(), af.getFile().getParentFile().getAbsolutePath()));
        }
        try {
            rafTemp = new RandomAccessFile(newFile, WRITE_MODE);
            raf = new RandomAccessFile(af.getFile(), WRITE_MODE);
        }
        catch (IOException ioe) {
            try {
                if (raf != null) {
                    raf.close();
                }
                if (rafTemp != null) {
                    rafTemp.close();
                }
            }
            catch (IOException ioe2) {
                // empty catch block
            }
            if (!newFile.delete()) {
                // empty if block
            }
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(af.getFile().getAbsolutePath()));
        }
        try {
            raf.seek(0L);
            rafTemp.seek(0L);
            try {
                if (this.modificationListener != null) {
                    this.modificationListener.fileWillBeModified(af, false);
                }
                this.writeTag(af.getTag(), raf, rafTemp);
                if (this.modificationListener != null) {
                    this.modificationListener.fileModified(af, newFile);
                }
            }
            catch (ModifyVetoException veto) {
                throw new CannotWriteException(veto);
            }
        }
        catch (Exception e) {
            try {
                if (raf != null) {
                    raf.close();
                }
                if (rafTemp != null) {
                    rafTemp.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (!newFile.delete()) {
                // empty if block
            }
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE.getMsg(af.getFile(), e.getMessage()));
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
                if (rafTemp != null) {
                    rafTemp.close();
                }
            }
            catch (IOException ioe) {}
        }
        result = af.getFile();
        if (newFile.length() > 0L) {
            File originalFileBackup = new File(af.getFile().getParentFile().getPath(), AudioFile.getBaseFilename(af.getFile()) + ".old");
            boolean renameResult = af.getFile().renameTo(originalFileBackup);
            if (!renameResult) {
                throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_ORIGINAL_FILE_TO_BACKUP.getMsg(af.getFile().getPath(), originalFileBackup.getName()));
            }
            renameResult = newFile.renameTo(af.getFile());
            if (!renameResult) {
                if (!newFile.exists()) {
                    // empty if block
                }
                if (!originalFileBackup.renameTo(af.getFile())) {
                    // empty if block
                }
                throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_TO_ORIGINAL_FILE.getMsg(af.getFile().getAbsolutePath(), newFile.getName()));
            }
            boolean deleteResult = originalFileBackup.delete();
            if (!deleteResult) {
                // empty if block
            }
            if (newFile.exists() && newFile.delete()) {
                // empty if block
            }
        } else if (!newFile.delete()) {
            // empty if block
        }
        if (this.modificationListener != null) {
            this.modificationListener.fileOperationFinished(result);
        }
    }

    protected abstract void writeTag(Tag var1, RandomAccessFile var2, RandomAccessFile var3) throws CannotReadException, CannotWriteException, IOException;
}

