/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.ContentDescriptor;
import org.jaudiotagger.audio.asf.data.ExtendedContentDescription;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.ChunkReader;
import org.jaudiotagger.audio.asf.util.Utils;

public class ExtContentDescReader
implements ChunkReader {
    protected ExtContentDescReader() {
    }

    @Override
    public boolean canFail() {
        return false;
    }

    @Override
    public GUID getApplyingId() {
        return GUID.GUID_EXTENDED_CONTENT_DESCRIPTION;
    }

    @Override
    public Chunk read(GUID guid, InputStream stream, long chunkStart) throws IOException {
        BigInteger chunkLen = Utils.readBig64(stream);
        long descriptorCount = Utils.readUINT16(stream);
        ExtendedContentDescription result = new ExtendedContentDescription(chunkLen);
        for (long i = 0L; i < descriptorCount; ++i) {
            String tagElement = Utils.readUTF16LEStr(stream);
            int type = Utils.readUINT16(stream);
            ContentDescriptor prop = new ContentDescriptor(tagElement, type);
            switch (type) {
                case 0: {
                    prop.setStringValue(Utils.readUTF16LEStr(stream));
                    break;
                }
                case 1: {
                    prop.setBinaryValue(this.readBinaryData(stream));
                    break;
                }
                case 2: {
                    prop.setBooleanValue(this.readBoolean(stream));
                    break;
                }
                case 3: {
                    stream.skip(2L);
                    prop.setDWordValue(Utils.readUINT32(stream));
                    break;
                }
                case 5: {
                    stream.skip(2L);
                    prop.setWordValue(Utils.readUINT16(stream));
                    break;
                }
                case 4: {
                    stream.skip(2L);
                    prop.setQWordValue(Utils.readUINT64(stream));
                    break;
                }
                default: {
                    prop.setStringValue("Invalid datatype: " + new String(this.readBinaryData(stream)));
                }
            }
            result.addDescriptor(prop);
        }
        result.setPosition(chunkStart);
        return result;
    }

    private byte[] readBinaryData(InputStream stream) throws IOException {
        int size = Utils.readUINT16(stream);
        byte[] bytes = new byte[size];
        stream.read(bytes);
        return bytes;
    }

    private boolean readBoolean(InputStream stream) throws IOException {
        int size = Utils.readUINT16(stream);
        if (size != 4) {
            throw new IllegalStateException("Boolean value do require 4 Bytes. (Size value is: " + size + ")");
        }
        long value = Utils.readUINT32(stream);
        boolean result = value == 1L;
        return result;
    }
}

