/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.util.Utils;

public final class ContentDescriptor
implements Comparable<ContentDescriptor> {
    public static final int TYPE_BINARY = 1;
    public static final int TYPE_BOOLEAN = 2;
    public static final int TYPE_DWORD = 3;
    public static final int TYPE_QWORD = 4;
    public static final int TYPE_STRING = 0;
    public static final int TYPE_WORD = 5;
    private final String name;
    private int descriptorType;
    protected byte[] content = new byte[0];

    public ContentDescriptor(String propName, int propType) {
        if (propName == null) {
            throw new IllegalArgumentException("Arguments must not be null.");
        }
        Utils.checkStringLengthNullSafe(propName);
        this.name = propName;
        this.descriptorType = propType;
    }

    public Object clone() throws CloneNotSupportedException {
        return this.createCopy();
    }

    @Override
    public int compareTo(ContentDescriptor o) {
        int result = this.getName().compareTo(o.getName());
        return result;
    }

    public ContentDescriptor createCopy() {
        ContentDescriptor result = new ContentDescriptor(this.getName(), this.getType());
        result.content = this.getRawData();
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof ContentDescriptor) {
            ContentDescriptor other;
            result = obj == this ? true : (other = (ContentDescriptor)obj).getName().equals(this.getName()) && other.descriptorType == this.descriptorType && Arrays.equals(this.content, other.content);
        }
        return result;
    }

    public boolean getBoolean() {
        return this.content.length > 0 && this.content[0] != 0;
    }

    public byte[] getBytes() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            byte[] nameBytes = Utils.getBytes(this.getName(), AsfHeader.ASF_CHARSET);
            result.write(Utils.getBytes(nameBytes.length + 2, 2));
            result.write(nameBytes);
            result.write(Utils.getBytes(0L, 2));
            result.write(Utils.getBytes(this.getType(), 2));
            if (this.getType() == 0) {
                result.write(Utils.getBytes(this.content.length + 2, 2));
                result.write(this.content);
                result.write(Utils.getBytes(0L, 2));
            } else {
                result.write(Utils.getBytes(this.content.length, 2));
                result.write(this.content);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toByteArray();
    }

    public int getCurrentAsfSize() {
        int result = 8;
        result += this.getName().length() * 2;
        result += this.content.length;
        if (0 == this.getType()) {
            result += 2;
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public long getNumber() {
        long result = 0L;
        int bytesNeeded = -1;
        switch (this.getType()) {
            case 2: {
                bytesNeeded = 1;
                break;
            }
            case 3: {
                bytesNeeded = 4;
                break;
            }
            case 4: {
                bytesNeeded = 8;
                break;
            }
            case 5: {
                bytesNeeded = 2;
                break;
            }
            default: {
                throw new UnsupportedOperationException("The current type doesn't allow an interpretation as a number.");
            }
        }
        if (bytesNeeded > this.content.length) {
            throw new IllegalStateException("The stored data cannot represent the type of current object.");
        }
        for (int i = 0; i < bytesNeeded; ++i) {
            result |= (long)(this.content[i] << i * 8);
        }
        return result;
    }

    public byte[] getRawData() {
        byte[] copy = new byte[this.content.length];
        System.arraycopy(this.content, 0, copy, 0, this.content.length);
        return copy;
    }

    public String getString() {
        String result = "";
        switch (this.getType()) {
            case 1: {
                result = "binary data";
                break;
            }
            case 2: {
                result = String.valueOf(this.getBoolean());
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                result = String.valueOf(this.getNumber());
                break;
            }
            case 0: {
                try {
                    result = new String(this.content, "UTF-16LE");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            default: {
                throw new IllegalStateException("Current type is not known.");
            }
        }
        return result;
    }

    public int getType() {
        return this.descriptorType;
    }

    public boolean isEmpty() {
        return this.content.length == 0;
    }

    public void setBinaryValue(byte[] data) throws IllegalArgumentException {
        if (data.length > 65535) {
            throw new IllegalArgumentException("Too many bytes. 65535 is maximum.");
        }
        this.content = data;
        this.descriptorType = 1;
    }

    public void setBooleanValue(boolean value) {
        this.content = new byte[]{value ? (byte)1 : 0, 0, 0, 0};
        this.descriptorType = 2;
    }

    public void setDWordValue(long value) {
        this.content = Utils.getBytes(value, 4);
        this.descriptorType = 3;
    }

    public void setQWordValue(long value) {
        this.content = Utils.getBytes(value, 8);
        this.descriptorType = 4;
    }

    public void setStringValue(String value) throws IllegalArgumentException {
        Utils.checkStringLengthNullSafe(value);
        this.content = value != null ? Utils.getBytes(value, AsfHeader.ASF_CHARSET) : new byte[0];
        this.descriptorType = 0;
    }

    public void setWordValue(int value) {
        this.content = Utils.getBytes(value, 2);
        this.descriptorType = 5;
    }

    public String toString() {
        return this.getName() + " : " + (new String[]{"String: ", "Binary: ", "Boolean: ", "DWORD: ", "QWORD:", "WORD:"})[this.descriptorType] + this.getString();
    }

    public int writeInto(OutputStream out) throws IOException {
        int size = this.getCurrentAsfSize();
        Utils.writeUINT16(this.getName().length() * 2 + 2, out);
        out.write(Utils.getBytes(this.getName(), AsfHeader.ASF_CHARSET));
        out.write(AsfHeader.ZERO_TERM);
        int type = this.getType();
        Utils.writeUINT16(type, out);
        int contentLen = this.content.length;
        if (0 == type) {
            contentLen += 2;
        }
        Utils.writeUINT16(contentLen, out);
        out.write(this.content);
        if (0 == type) {
            out.write(AsfHeader.ZERO_TERM);
        }
        return size;
    }
}

