/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.wizards;

import java.io.File;
import java.util.logging.Logger;
import net.sf.fmj.ui.wizard.WizardPanelDescriptor;
import net.sf.fmj.ui.wizards.ContentAndTrackFormatPanelDescriptor;
import net.sf.fmj.ui.wizards.FileDestPanel;
import net.sf.fmj.ui.wizards.TranscodeWizardConfig;
import net.sf.fmj.ui.wizards.TranscodeWizardResult;
import net.sf.fmj.ui.wizards.WizardStepException;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.URLUtils;

public class FileDestPanelDescriptor
extends WizardPanelDescriptor {
    private static final Logger logger = LoggerSingleton.logger;
    public static final String IDENTIFIER = FileDestPanelDescriptor.class.getName();
    private final TranscodeWizardResult result;
    private final TranscodeWizardConfig config;

    public FileDestPanelDescriptor(TranscodeWizardConfig config, TranscodeWizardResult result) {
        super(IDENTIFIER, new FileDestPanel());
        this.config = config;
        this.result = result;
    }

    public Object getNextPanelDescriptor() {
        return FINISH;
    }

    public Object getBackPanelDescriptor() {
        return ContentAndTrackFormatPanelDescriptor.IDENTIFIER;
    }

    public FileDestPanel getFileDestPanel() {
        return (FileDestPanel)this.getPanelComponent();
    }

    public boolean aboutToDisplayPanel(Object prevId) {
        if (prevId == this.getBackPanelDescriptor()) {
            if (this.config.destUrl != null) {
                this.getFileDestPanel().getTextFile().setText(URLUtils.extractValidNewFilePathFromFileUrl(this.config.destUrl));
            }
            return true;
        }
        return super.aboutToDisplayPanel(prevId);
    }

    public boolean aboutToHidePanel(Object idOfNext) {
        if (idOfNext == this.getNextPanelDescriptor()) {
            String path = this.getFileDestPanel().getTextFile().getText();
            if (path == null || path.equals("")) {
                this.showError("Destination file path may not be blank");
                return false;
            }
            try {
                this.config.destUrl = URLUtils.createUrlStr(new File(path));
                this.result.step4_setDestUrlAndStart(this.config);
            }
            catch (WizardStepException e1) {
                this.showError(e1);
                return false;
            }
            return true;
        }
        return super.aboutToHidePanel(idOfNext);
    }
}

