/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.renderer.audio;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.media.format.AudioFormat;
import javax.sound.sampled.AudioFormat;
import net.sf.fmj.media.renderer.audio.CustomEncoding;

public class JavaSoundUtils {
    public static boolean onlyStandardFormats = false;

    public static AudioFormat convertFormat(javax.sound.sampled.AudioFormat format) {
        AudioFormat.Encoding encoding = format.getEncoding();
        int channels = format.getChannels();
        float frameRate = format.getFrameRate();
        int frameSize = format.getFrameSize() < 0 ? format.getFrameSize() : format.getFrameSize() * 8;
        float sampleRate = format.getSampleRate();
        int sampleSize = format.getSampleSizeInBits();
        int endian = format.isBigEndian() ? 1 : 0;
        int signed = -1;
        String encodingString = "LINEAR";
        if (encoding == AudioFormat.Encoding.PCM_SIGNED) {
            signed = 1;
            encodingString = "LINEAR";
        } else if (encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
            signed = 0;
            encodingString = "LINEAR";
        } else {
            encodingString = encoding == AudioFormat.Encoding.ALAW ? "alaw" : (encoding == AudioFormat.Encoding.ULAW ? "ULAW" : encoding.toString());
        }
        AudioFormat jmfFormat = new AudioFormat(encodingString, sampleRate, sampleSize, channels, endian, signed, frameSize, frameRate, AudioFormat.byteArray);
        return jmfFormat;
    }

    private static AudioFormat.Encoding toMpegEncoding(String encodingStr) {
        try {
            if (!onlyStandardFormats) {
                int i;
                Class<?> classMpegEncoding = Class.forName("javazoom.spi.mpeg.sampled.file.MpegEncoding");
                String[] mpegEncodingStrings = new String[]{"MPEG1L1", "MPEG1L2", "MPEG1L3", "MPEG2DOT5L1", "MPEG2DOT5L2", "MPEG2DOT5L3", "MPEG2L1", "MPEG2L2", "MPEG2L3"};
                AudioFormat.Encoding[] mpegEncodings = new AudioFormat.Encoding[mpegEncodingStrings.length];
                for (i = 0; i < mpegEncodings.length; ++i) {
                    Field aField = classMpegEncoding.getDeclaredField(mpegEncodingStrings[i]);
                    mpegEncodings[i] = (AudioFormat.Encoding)aField.get(null);
                }
                for (i = 0; i < mpegEncodings.length; ++i) {
                    if (!encodingStr.equals(mpegEncodings[i].toString())) continue;
                    return mpegEncodings[i];
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static AudioFormat.Encoding toVorbisEncoding(String encodingStr) {
        try {
            if (!onlyStandardFormats) {
                int i;
                Class<?> classVorbisEncoding = Class.forName("javazoom.spi.vorbis.sampled.file.VorbisEncoding");
                String[] vorbisEncodingStrings = new String[]{"VORBISENC"};
                AudioFormat.Encoding[] vorbisEncodings = new AudioFormat.Encoding[vorbisEncodingStrings.length];
                for (i = 0; i < vorbisEncodings.length; ++i) {
                    Field aField = classVorbisEncoding.getDeclaredField(vorbisEncodingStrings[i]);
                    vorbisEncodings[i] = (AudioFormat.Encoding)aField.get(null);
                }
                for (i = 0; i < vorbisEncodings.length; ++i) {
                    if (!encodingStr.equals(vorbisEncodings[i].toString())) continue;
                    return vorbisEncodings[i];
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static javax.sound.sampled.AudioFormat convertFormat(AudioFormat format) {
        javax.sound.sampled.AudioFormat sampledFormat;
        AudioFormat.Encoding encoding;
        boolean endian;
        int sampleSize;
        double sampleRate;
        int frameSize;
        double frameRate;
        int channels;
        block21: {
            String encodingString;
            block20: {
                encodingString = format.getEncoding();
                channels = format.getChannels();
                frameRate = format.getFrameRate();
                frameSize = format.getFrameSizeInBits() / 8;
                sampleRate = format.getSampleRate();
                sampleSize = format.getSampleSizeInBits();
                if (sampleSize > 8 && format.getEndian() == -1) {
                    throw new IllegalArgumentException("Endianness must be specified");
                }
                endian = format.getEndian() == 1;
                int signed = format.getSigned();
                if (!"LINEAR".equals(encodingString)) break block20;
                switch (signed) {
                    case 1: {
                        encoding = AudioFormat.Encoding.PCM_SIGNED;
                        break block21;
                    }
                    case 0: {
                        encoding = AudioFormat.Encoding.PCM_UNSIGNED;
                        break block21;
                    }
                    default: {
                        throw new IllegalArgumentException("Signed/Unsigned must be specified");
                    }
                }
            }
            encoding = "alaw".equals(encodingString) ? AudioFormat.Encoding.ALAW : ("ULAW".equals(encodingString) ? AudioFormat.Encoding.ULAW : (JavaSoundUtils.toMpegEncoding(encodingString) != null ? JavaSoundUtils.toMpegEncoding(encodingString) : (JavaSoundUtils.toVorbisEncoding(encodingString) != null ? JavaSoundUtils.toVorbisEncoding(encodingString) : new CustomEncoding(encodingString))));
        }
        Class<?> classMpegEncoding = null;
        Class<?> classVorbisEncoding = null;
        if (!onlyStandardFormats) {
            try {
                classMpegEncoding = Class.forName("javazoom.spi.mpeg.sampled.file.MpegEncoding");
                classVorbisEncoding = Class.forName("javazoom.spi.vorbis.sampled.file.VorbisEncoding");
            }
            catch (Exception dontcare) {
                // empty catch block
            }
        }
        if (encoding == AudioFormat.Encoding.PCM_SIGNED) {
            sampledFormat = new javax.sound.sampled.AudioFormat((float)sampleRate, sampleSize, channels, true, endian);
        } else if (encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
            sampledFormat = new javax.sound.sampled.AudioFormat((float)sampleRate, sampleSize, channels, false, endian);
        } else if (null != classMpegEncoding && classMpegEncoding.isInstance(encoding)) {
            try {
                Class<?> classMpegAudioFormat = Class.forName("javazoom.spi.mpeg.sampled.file.MpegAudioFormat");
                Class[] partypes = new Class[]{AudioFormat.Encoding.class, Float.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Float.TYPE, Boolean.TYPE, Map.class};
                Constructor<?> ct = classMpegAudioFormat.getConstructor(partypes);
                Object[] arglist = new Object[]{encoding, Float.valueOf((float)sampleRate), sampleSize, channels, frameSize, Float.valueOf((float)frameRate), endian, new HashMap()};
                sampledFormat = (javax.sound.sampled.AudioFormat)ct.newInstance(arglist);
            }
            catch (Exception dontcare) {
                sampledFormat = null;
            }
        } else if (null != classVorbisEncoding && classVorbisEncoding.isInstance(encoding)) {
            try {
                Class<?> classVorbisAudioFormat = Class.forName("javazoom.spi.vorbis.sampled.file.VorbisAudioFormat");
                Class[] partypes = new Class[]{AudioFormat.Encoding.class, Float.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Float.TYPE, Boolean.TYPE, Map.class};
                Constructor<?> ct = classVorbisAudioFormat.getConstructor(partypes);
                Object[] arglist = new Object[]{encoding, Float.valueOf((float)sampleRate), sampleSize, channels, frameSize, Float.valueOf((float)frameRate), endian, new HashMap()};
                sampledFormat = (javax.sound.sampled.AudioFormat)ct.newInstance(arglist);
            }
            catch (Exception dontcare) {
                sampledFormat = null;
            }
        } else {
            sampledFormat = new javax.sound.sampled.AudioFormat(encoding, (float)sampleRate, sampleSize, channels, frameSize, (float)frameRate, endian);
        }
        return sampledFormat;
    }
}

