/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.parser;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import javax.media.Track;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.SourceCloneable;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.sf.fmj.media.AbstractDemultiplexer;
import net.sf.fmj.media.AbstractTrack;
import net.sf.fmj.media.PullSourceStreamInputStream;
import net.sf.fmj.media.renderer.audio.JavaSoundUtils;
import net.sf.fmj.utility.LoggerSingleton;

public class JavaSoundParser
extends AbstractDemultiplexer {
    private static final Logger logger = LoggerSingleton.logger;
    private ContentDescriptor[] supportedInputContentDescriptors = new ContentDescriptor[]{new ContentDescriptor("audio.x_wav"), new ContentDescriptor("audio.basic"), new ContentDescriptor("audio.x_aiff"), new ContentDescriptor("audio.mpeg"), new ContentDescriptor("audio.ogg"), new ContentDescriptor("application.ogg")};
    private PullDataSource sourceForFormat;
    private PullDataSource sourceForReadFrame;
    private PullSourceStreamTrack[] tracks;
    private static final boolean OPEN_IN_SET_SOURCE = true;

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return this.supportedInputContentDescriptors;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        return this.tracks;
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        if (!(source instanceof PullDataSource)) {
            throw new IncompatibleSourceException();
        }
        if (!(source instanceof SourceCloneable)) {
            throw new IncompatibleSourceException();
        }
        this.sourceForFormat = (PullDataSource)source;
        try {
            this.doOpen();
        }
        catch (UnsupportedAudioFileException e) {
            logger.log(Level.INFO, "" + e);
            throw new IncompatibleSourceException("" + e);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
            throw e;
        }
    }

    private void doOpen() throws IOException, UnsupportedAudioFileException {
        this.sourceForReadFrame = (PullDataSource)((SourceCloneable)((Object)this.sourceForFormat)).createClone();
        if (this.sourceForReadFrame == null) {
            throw new IOException("Could not create clone");
        }
        this.sourceForReadFrame.start();
        this.sourceForFormat.start();
        PullSourceStream[] streamsForFormat = this.sourceForFormat.getStreams();
        PullSourceStream[] streamsForReadFrame = this.sourceForReadFrame.getStreams();
        this.tracks = new PullSourceStreamTrack[streamsForFormat.length];
        for (int i = 0; i < streamsForFormat.length; ++i) {
            this.tracks[i] = new PullSourceStreamTrack(streamsForFormat[i], streamsForReadFrame[i]);
        }
    }

    public void open() throws ResourceUnavailableException {
    }

    public void start() throws IOException {
    }

    public boolean isPositionable() {
        return true;
    }

    public boolean isRandomAccess() {
        return super.isRandomAccess();
    }

    public Time setPosition(Time where, int rounding) {
        int i;
        for (i = 0; i < this.tracks.length; ++i) {
            if (this.tracks[i].canSkipNanos()) continue;
            return super.setPosition(where, rounding);
        }
        if (where.getNanoseconds() == 0L) {
            boolean noBytesRead = true;
            for (int i2 = 0; i2 < this.tracks.length; ++i2) {
                if (this.tracks[i2].getTotalBytesRead() == 0L) continue;
                noBytesRead = false;
                break;
            }
            if (noBytesRead) {
                return where;
            }
        }
        try {
            logger.fine("JavaSoundParser: cloning, reconnecting, and restarting source");
            this.sourceForReadFrame = (PullDataSource)((SourceCloneable)((Object)this.sourceForFormat)).createClone();
            if (this.sourceForReadFrame == null) {
                throw new RuntimeException("Could not create clone");
            }
            this.sourceForReadFrame.start();
            for (i = 0; i < this.tracks.length; ++i) {
                this.tracks[i].setPssForReadFrame(this.sourceForReadFrame.getStreams()[i]);
                if (where.getNanoseconds() <= 0L) continue;
                this.tracks[i].skipNanos(where.getNanoseconds());
            }
            return where;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
            throw new RuntimeException(e);
        }
        catch (UnsupportedAudioFileException e) {
            logger.log(Level.WARNING, "" + e, e);
            throw new RuntimeException(e);
        }
    }

    private static InputStream markSupportedInputStream(InputStream is) {
        if (is.markSupported()) {
            return is;
        }
        return new BufferedInputStream(is);
    }

    private static final double secondsToNanos(double secs) {
        return secs * 1.0E9;
    }

    private static final double nanosToSeconds(double nanos) {
        return nanos / 1.0E9;
    }

    private class PullSourceStreamTrack
    extends AbstractTrack {
        private final AudioFormat format;
        private final javax.sound.sampled.AudioFormat javaSoundInputFormat;
        private final long frameLength;
        private PullSourceStream pssForReadFrame;
        private PullSourceStreamInputStream pssisForReadFrame;
        private AudioInputStream aisForReadFrame;
        private long totalBytesRead = 0L;

        public PullSourceStreamTrack(PullSourceStream pssForFormat, PullSourceStream pssForReadFrame) throws UnsupportedAudioFileException, IOException {
            PullSourceStreamInputStream pssisForFormat = new PullSourceStreamInputStream(pssForFormat);
            AudioInputStream aisForFormat = AudioSystem.getAudioInputStream(JavaSoundParser.markSupportedInputStream(pssisForFormat));
            this.javaSoundInputFormat = aisForFormat.getFormat();
            this.frameLength = aisForFormat.getFrameLength();
            this.format = JavaSoundUtils.convertFormat(this.javaSoundInputFormat);
            logger.fine("JavaSoundParser: java sound format: " + this.javaSoundInputFormat);
            logger.fine("JavaSoundParser: jmf format: " + this.format);
            logger.fine("JavaSoundParser: Frame length=" + this.frameLength);
            aisForFormat.close();
            pssisForFormat.close();
            this.setPssForReadFrame(pssForReadFrame);
        }

        public long skipNanos(long nanos) throws IOException {
            long bytes = this.nanosToBytes(nanos);
            if (bytes <= 0L) {
                logger.fine("JavaSoundParser: skipping nanos: 0");
                return 0L;
            }
            long bytesSkipped = this.aisForReadFrame.skip(bytes);
            this.totalBytesRead += bytesSkipped;
            if (bytesSkipped == bytes) {
                logger.fine("JavaSoundParser: skipping nanos: " + nanos);
                return nanos;
            }
            long result = this.bytesToNanos(bytesSkipped);
            logger.fine("JavaSoundParser: skipping nanos: " + result);
            return result;
        }

        public boolean canSkipNanos() {
            return this.javaSoundInputFormat.getFrameSize() > 0 && this.javaSoundInputFormat.getFrameRate() > 0.0f;
        }

        public void setPssForReadFrame(PullSourceStream pssForReadFrame) throws UnsupportedAudioFileException, IOException {
            this.pssForReadFrame = pssForReadFrame;
            this.pssisForReadFrame = new PullSourceStreamInputStream(pssForReadFrame);
            this.aisForReadFrame = AudioSystem.getAudioInputStream(JavaSoundParser.markSupportedInputStream(this.pssisForReadFrame));
            this.totalBytesRead = 0L;
        }

        public Format getFormat() {
            return this.format;
        }

        private long bytesToNanos(long bytes) {
            if (this.javaSoundInputFormat.getFrameSize() > 0 && this.javaSoundInputFormat.getFrameRate() > 0.0f) {
                long frames = bytes / (long)this.javaSoundInputFormat.getFrameSize();
                double seconds = (float)frames / this.javaSoundInputFormat.getFrameRate();
                double nanos = JavaSoundParser.secondsToNanos(seconds);
                return (long)nanos;
            }
            return -1L;
        }

        private long nanosToBytes(long nanos) {
            if (this.javaSoundInputFormat.getFrameSize() > 0 && this.javaSoundInputFormat.getFrameRate() > 0.0f) {
                double seconds = JavaSoundParser.nanosToSeconds(nanos);
                double frames = seconds * (double)this.javaSoundInputFormat.getFrameRate();
                double bytes = frames * (double)this.javaSoundInputFormat.getFrameSize();
                return (long)bytes;
            }
            return -1L;
        }

        public void readFrame(Buffer buffer) {
            int BUFFER_SIZE = 10000;
            if (buffer.getData() == null) {
                buffer.setData(new byte[10000]);
            }
            byte[] bytes = (byte[])buffer.getData();
            try {
                int result = this.aisForReadFrame.read(bytes, 0, bytes.length);
                if (result < 0) {
                    buffer.setEOM(true);
                    buffer.setLength(0);
                    return;
                }
                if (this.javaSoundInputFormat.getFrameSize() > 0 && this.javaSoundInputFormat.getFrameRate() > 0.0f) {
                    buffer.setTimeStamp(this.bytesToNanos(this.totalBytesRead));
                    buffer.setDuration(this.bytesToNanos(result));
                }
                this.totalBytesRead += (long)result;
                buffer.setLength(result);
                buffer.setOffset(0);
            }
            catch (IOException e) {
                buffer.setEOM(true);
                buffer.setDiscard(true);
                buffer.setLength(0);
                logger.log(Level.WARNING, "" + e, e);
            }
        }

        public Time mapFrameToTime(int frameNumber) {
            return TIME_UNKNOWN;
        }

        public int mapTimeToFrame(Time t) {
            return Integer.MAX_VALUE;
        }

        public Time getDuration() {
            long lengthInFrames = this.frameLength;
            if (lengthInFrames < 0L) {
                logger.fine("PullSourceStreamTrack: returning Duration.DURATION_UNKNOWN (1)");
                return Duration.DURATION_UNKNOWN;
            }
            double lengthInSeconds = (float)lengthInFrames / this.javaSoundInputFormat.getFrameRate();
            if (lengthInSeconds < 0.0) {
                logger.fine("PullSourceStreamTrack: returning Duration.DURATION_UNKNOWN (2)");
                return Duration.DURATION_UNKNOWN;
            }
            double lengthInNanos = JavaSoundParser.secondsToNanos(lengthInSeconds);
            logger.fine("PullSourceStreamTrack: returning " + (long)lengthInNanos);
            return new Time((long)lengthInNanos);
        }

        public long getTotalBytesRead() {
            return this.totalBytesRead;
        }
    }
}

