/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.video.jpeg;

import net.sf.fmj.utility.ArrayUtility;

public class RFC2035 {
    public static final int[] jpeg_luma_quantizer_zigzag = new int[]{16, 11, 12, 14, 12, 10, 16, 14, 13, 14, 18, 17, 16, 19, 24, 40, 26, 24, 22, 22, 24, 49, 35, 37, 29, 40, 58, 51, 61, 60, 57, 51, 56, 55, 64, 72, 92, 78, 64, 68, 87, 69, 55, 56, 80, 109, 81, 87, 95, 98, 103, 104, 103, 62, 77, 113, 121, 112, 100, 120, 92, 101, 103, 99};
    public static final int[] jpeg_chroma_quantizer_zigzag = new int[]{17, 18, 18, 24, 21, 24, 47, 26, 26, 47, 99, 66, 56, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};
    public static final int[] jpeg_luma_quantizer_normal = new int[]{16, 11, 10, 16, 24, 40, 51, 61, 12, 12, 14, 19, 26, 58, 60, 55, 14, 13, 16, 24, 40, 57, 69, 56, 14, 17, 22, 29, 51, 87, 80, 62, 18, 22, 37, 56, 68, 109, 103, 77, 24, 35, 55, 64, 81, 104, 113, 92, 49, 64, 78, 87, 103, 121, 120, 101, 72, 92, 95, 98, 112, 100, 103, 99};
    public static final int[] jpeg_chroma_quantizer_normal = new int[]{17, 18, 24, 47, 99, 99, 99, 99, 18, 21, 26, 66, 99, 99, 99, 99, 24, 26, 56, 99, 99, 99, 99, 99, 47, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};
    public static final short[] lum_dc_codelens = new short[]{0, 1, 5, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0};
    public static final short[] lum_dc_symbols = new short[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    public static final short[] lum_ac_codelens = new short[]{0, 2, 1, 3, 3, 2, 4, 3, 5, 5, 4, 4, 0, 0, 1, 125};
    public static final short[] lum_ac_symbols = new short[]{1, 2, 3, 0, 4, 17, 5, 18, 33, 49, 65, 6, 19, 81, 97, 7, 34, 113, 20, 50, 129, 145, 161, 8, 35, 66, 177, 193, 21, 82, 209, 240, 36, 51, 98, 114, 130, 9, 10, 22, 23, 24, 25, 26, 37, 38, 39, 40, 41, 42, 52, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, 131, 132, 133, 134, 135, 136, 137, 138, 146, 147, 148, 149, 150, 151, 152, 153, 154, 162, 163, 164, 165, 166, 167, 168, 169, 170, 178, 179, 180, 181, 182, 183, 184, 185, 186, 194, 195, 196, 197, 198, 199, 200, 201, 202, 210, 211, 212, 213, 214, 215, 216, 217, 218, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250};
    public static final short[] chm_dc_codelens = new short[]{0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0};
    public static final short[] chm_dc_symbols = new short[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    public static final short[] chm_ac_codelens = new short[]{0, 2, 1, 2, 4, 4, 3, 4, 7, 5, 4, 4, 0, 1, 2, 119};
    public static final short[] chm_ac_symbols = new short[]{0, 1, 2, 3, 17, 4, 5, 33, 49, 6, 18, 65, 81, 7, 97, 113, 19, 34, 50, 129, 8, 20, 66, 145, 161, 177, 193, 9, 35, 51, 82, 240, 21, 98, 114, 209, 10, 22, 36, 52, 225, 37, 241, 23, 24, 25, 26, 38, 39, 40, 41, 42, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, 130, 131, 132, 133, 134, 135, 136, 137, 138, 146, 147, 148, 149, 150, 151, 152, 153, 154, 162, 163, 164, 165, 166, 167, 168, 169, 170, 178, 179, 180, 181, 182, 183, 184, 185, 186, 194, 195, 196, 197, 198, 199, 200, 201, 202, 210, 211, 212, 213, 214, 215, 216, 217, 218, 226, 227, 228, 229, 230, 231, 232, 233, 234, 242, 243, 244, 245, 246, 247, 248, 249, 250};

    private static void MakeTables(int q, byte[] lum_q, byte[] chr_q) {
        RFC2035.MakeTables(q, lum_q, chr_q, jpeg_luma_quantizer_zigzag, jpeg_luma_quantizer_zigzag);
    }

    public static void MakeTables(int q, byte[] lum_q, byte[] chr_q, int[] jpeg_luma, int[] jpeg_chroma) {
        int factor = q;
        if (q < 1) {
            factor = 1;
        }
        if (q > 99) {
            factor = 99;
        }
        q = q < 50 ? 5000 / factor : 200 - factor * 2;
        for (int i = 0; i < 64; ++i) {
            int lq = (jpeg_luma[i] * q + 50) / 100;
            int cq = (jpeg_chroma[i] * q + 50) / 100;
            if (lq < 1) {
                lq = 1;
            } else if (lq > 255) {
                lq = 255;
            }
            lum_q[i] = (byte)lq;
            if (cq < 1) {
                cq = 1;
            } else if (cq > 255) {
                cq = 255;
            }
            chr_q[i] = (byte)cq;
        }
    }

    public static int MakeQuantHeader(byte[] p, int i, byte[] qt, int tableNo) {
        p[i++] = -1;
        p[i++] = -37;
        p[i++] = 0;
        p[i++] = 67;
        p[i++] = (byte)tableNo;
        System.arraycopy(qt, 0, p, i, 64);
        return i += 64;
    }

    private static int MakeHuffmanHeader(byte[] p, int i, short[] codelens, int ncodes, short[] symbols, int nsymbols, int tableNo, int tableClass) {
        p[i++] = -1;
        p[i++] = -60;
        p[i++] = 0;
        p[i++] = (byte)(3 + ncodes + nsymbols);
        p[i++] = (byte)(tableClass << 4 | tableNo);
        byte[] shortCodelens = ArrayUtility.shortArrayToByteArray(codelens);
        System.arraycopy(shortCodelens, 0, p, i, ncodes);
        byte[] shortSymbols = ArrayUtility.shortArrayToByteArray(symbols);
        System.arraycopy(shortSymbols, 0, p, i += ncodes, nsymbols);
        return i += nsymbols;
    }

    public static int MakeHeaders(boolean includeSOI, byte[] p, int i, int type, int q, int w, int h) {
        return RFC2035.MakeHeaders(includeSOI, p, i, type, q, w, h, null, null, 0);
    }

    public static int MakeHeaders(boolean includeSOI, byte[] p, int i, int type, int q, int w, int h, byte[] luma, byte[] chroma, int dri) {
        byte[] cqt;
        byte[] lqt;
        if (luma == null && chroma == null) {
            lqt = new byte[64];
            cqt = new byte[64];
            RFC2035.MakeTables(q, lqt, cqt);
        } else {
            lqt = luma;
            cqt = chroma;
        }
        w <<= 3;
        h <<= 3;
        if (includeSOI) {
            p[i++] = -1;
            p[i++] = -40;
        }
        i = RFC2035.MakeQuantHeader(p, i, lqt, 0);
        i = RFC2035.MakeQuantHeader(p, i, cqt, 1);
        if (dri != 0) {
            i = RFC2035.MakeDRIHeader(p, i, dri);
        }
        i = RFC2035.MakeHuffmanHeader(p, i, lum_dc_codelens, lum_dc_codelens.length, lum_dc_symbols, lum_dc_symbols.length, 0, 0);
        i = RFC2035.MakeHuffmanHeader(p, i, lum_ac_codelens, lum_ac_codelens.length, lum_ac_symbols, lum_ac_symbols.length, 0, 1);
        i = RFC2035.MakeHuffmanHeader(p, i, chm_dc_codelens, chm_dc_codelens.length, chm_dc_symbols, chm_dc_symbols.length, 1, 0);
        i = RFC2035.MakeHuffmanHeader(p, i, chm_ac_codelens, chm_ac_codelens.length, chm_ac_symbols, chm_ac_symbols.length, 1, 1);
        p[i++] = -1;
        p[i++] = -64;
        p[i++] = 0;
        p[i++] = 17;
        p[i++] = 8;
        p[i++] = (byte)(h >> 8);
        p[i++] = (byte)h;
        p[i++] = (byte)(w >> 8);
        p[i++] = (byte)w;
        p[i++] = 3;
        p[i++] = 1;
        p[i++] = type == 0 ? 33 : 34;
        p[i++] = 0;
        p[i++] = 2;
        p[i++] = 17;
        p[i++] = 1;
        p[i++] = 3;
        p[i++] = 17;
        p[i++] = 1;
        p[i++] = -1;
        p[i++] = -38;
        p[i++] = 0;
        p[i++] = 12;
        p[i++] = 3;
        p[i++] = 1;
        p[i++] = 0;
        p[i++] = 2;
        p[i++] = 17;
        p[i++] = 3;
        p[i++] = 17;
        p[i++] = 0;
        p[i++] = 63;
        p[i++] = 0;
        return i;
    }

    private static int MakeDRIHeader(byte[] p, int i, int dri) {
        p[i++] = -1;
        p[i++] = -35;
        p[i++] = 0;
        p[i++] = 4;
        p[i++] = (byte)(dri >> 8);
        p[i++] = (byte)(dri & 0xFF);
        return i;
    }

    public static int[] createZigZag(int[] array) {
        return RFC2035.createZigZag(array, 8, 8);
    }

    public static int[] createZigZag(int[] array, int xmax, int ymax) {
        int[] zz = new int[array.length];
        if (array.length != xmax * ymax) {
            throw new IllegalArgumentException();
        }
        int ai = 0;
        int zzi = 0;
        int x = 0;
        int y = 0;
        zz[zzi] = array[ai];
        while (y * xmax + x < xmax * ymax - 1) {
            if (x < xmax - 1) {
                ++x;
            } else {
                ++y;
            }
            ai = y * xmax + x;
            zz[++zzi] = array[ai];
            while (x > 0 && y < ymax - 1) {
                ai = ++y * xmax + --x;
                zz[++zzi] = array[ai];
            }
            if (y < ymax - 1) {
                ++y;
            } else {
                ++x;
            }
            ai = y * xmax + x;
            zz[++zzi] = array[ai];
            while (y > 0 && x < xmax - 1) {
                ai = --y * xmax + ++x;
                zz[++zzi] = array[ai];
            }
        }
        return zz;
    }
}

