/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.gui.controlpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Duration;
import javax.media.MediaTimeSetEvent;
import javax.media.Player;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.RestartingEvent;
import javax.media.StartEvent;
import javax.media.StopEvent;
import javax.media.Time;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.fmj.ejmf.toolkit.util.SourcedTimer;
import net.sf.fmj.ejmf.toolkit.util.SourcedTimerEvent;
import net.sf.fmj.ejmf.toolkit.util.SourcedTimerListener;
import net.sf.fmj.ejmf.toolkit.util.TimeSource;
import net.sf.fmj.gui.controlpanel.DefaultSkin;
import net.sf.fmj.gui.controlpanel.Skin;
import net.sf.fmj.gui.controlpanel.TransportControlState;
import net.sf.fmj.utility.LoggerSingleton;

public class SwingLookControlPanel
extends JPanel
implements TimeSource,
SourcedTimerListener {
    private static final Logger logger = LoggerSingleton.logger;
    public static final int USE_PLAY_CONTROL = 1;
    public static final int USE_STOP_CONTROL = 2;
    public static final int USE_BACK_CONTROL = 4;
    public static final int USE_FORWARD_CONTROL = 8;
    public static final int USE_NEXT_CONTROL = 16;
    public static final int USE_PREVIOUS_CONTROL = 32;
    public static final int USE_POSITION_CONTROL = 64;
    public static final int USE_POSITION_TEXT = 128;
    public static final int USE_LENGTH_TEXT = 256;
    public static final int USE_VOLUME_CONTROL = 512;
    public static final int USE_MUTE_CONTROL = 1024;
    public static final int SINGLE_LINE = 2048;
    public static final int DEFAULT_FLAGS = 2033;
    private static final boolean USE_STANDARD_SLIDER = true;
    private final int flags;
    private final Skin skin;
    public static final Skin DEFAULT_SKIN = new DefaultSkin();
    private Player player;
    private SourcedTimer controlTimer;
    private static final int TIMER_TICK = 250;
    private JButton playButton = null;
    private JButton stopButton = null;
    private JButton backButton = null;
    private JButton forwardButton = null;
    private JButton nextButton = null;
    private JButton previousButton = null;
    private JPanel positionPanel = null;
    private JSlider positionSlider = null;
    private JPanel buttonPanel = null;
    private JLabel positionLabel = null;
    private JLabel lengthLabel = null;
    private JPanel audioPanel = null;
    private JSlider volumeSlider = null;
    private JToggleButton muteButton = null;
    private ControllerListener controllerListener = new ControllerListener(){

        public void controllerUpdate(ControllerEvent event) {
            logger.fine("Got controller event: " + event);
            Player player = (Player)event.getSourceController();
            if (player != SwingLookControlPanel.this.player) {
                return;
            }
            if (!(event instanceof RealizeCompleteEvent) && !(event instanceof ResourceUnavailableEvent)) {
                if (event instanceof StopEvent) {
                    TransportControlState transportControlState = new TransportControlState();
                    transportControlState.setAllowPlay(true);
                    transportControlState.setAllowStop(false);
                    transportControlState.setAllowVolume(player.getGainControl() != null);
                    SwingLookControlPanel.this.onStateChange(transportControlState);
                } else if (event instanceof StartEvent) {
                    TransportControlState transportControlState = new TransportControlState();
                    transportControlState.setAllowPlay(false);
                    transportControlState.setAllowStop(true);
                    transportControlState.setAllowVolume(player.getGainControl() != null);
                    SwingLookControlPanel.this.onStateChange(transportControlState);
                } else if (event instanceof ControllerErrorEvent || event instanceof ControllerClosedEvent) {
                    // empty if block
                }
            }
            if (event instanceof StartEvent || event instanceof RestartingEvent) {
                SwingLookControlPanel.this.onDurationChange(player.getDuration().getNanoseconds());
                SwingLookControlPanel.this.onProgressChange(SwingLookControlPanel.this.getTime());
                SwingLookControlPanel.this.controlTimer.start();
            } else if (event instanceof StopEvent || event instanceof ControllerErrorEvent) {
                SwingLookControlPanel.this.controlTimer.stop();
            } else if (event instanceof MediaTimeSetEvent) {
                SwingLookControlPanel.this.onDurationChange(player.getDuration().getNanoseconds());
                SwingLookControlPanel.this.onProgressChange(SwingLookControlPanel.this.getTime());
            }
        }
    };
    boolean playButtonIsPause;
    private volatile boolean suppressProgressChangeNotification = false;
    private volatile boolean sliderDragInProgress = false;

    public SwingLookControlPanel(int flags, Skin skin) {
        this.flags = flags;
        this.skin = skin;
        this.initialize();
    }

    public SwingLookControlPanel(int flags, Skin skin, Player player) {
        this.flags = flags;
        this.skin = skin;
        this.initialize();
        this.setPlayer(player);
    }

    public SwingLookControlPanel() {
        this(2033, DEFAULT_SKIN);
    }

    public SwingLookControlPanel(Player player) {
        this(2033, DEFAULT_SKIN, player);
    }

    public void setPlayer(Player player) {
        this.player = player;
        TransportControlState transportControlState = new TransportControlState();
        if (player.getState() == 600) {
            transportControlState.setAllowPlay(false);
            transportControlState.setAllowStop(true);
            transportControlState.setAllowVolume(player.getGainControl() != null);
        } else {
            transportControlState.setAllowPlay(true);
            transportControlState.setAllowStop(false);
            transportControlState.setAllowVolume(false);
        }
        if (this.getPreviousButton() != null) {
            this.getPreviousButton().setEnabled(true);
        }
        if (this.getNextButton() != null) {
            this.getNextButton().setEnabled(true);
        }
        if (this.getForwardButton() != null) {
            this.getForwardButton().setEnabled(true);
        }
        if (this.getBackButton() != null) {
            this.getBackButton().setEnabled(true);
        }
        this.onStateChange(transportControlState);
        this.controlTimer = new SourcedTimer((TimeSource)this, 250);
        this.controlTimer.addSourcedTimerListener(this);
        if (player.getState() == 600) {
            this.onDurationChange(player.getDuration().getNanoseconds());
            this.controlTimer.start();
        }
        player.addControllerListener(this.controllerListener);
    }

    private void initialize() {
        if ((this.flags & 0x800) != 0) {
            this.setLayout(new BorderLayout());
            this.setSize(new Dimension(553, 58));
            if (this.getButtonPanel() != null) {
                this.add((Component)this.getButtonPanel(), "West");
            }
            if (this.getPositionPanel() != null) {
                this.add((Component)this.getPositionPanel(), "Center");
            }
            if (this.getAudioPanel() != null) {
                this.add((Component)this.getAudioPanel(), "East");
            }
        } else {
            this.setLayout(new BorderLayout());
            this.setSize(new Dimension(553, 58));
            if (this.getPositionPanel() != null) {
                this.add((Component)this.getPositionPanel(), "North");
            }
            if (this.getButtonPanel() != null) {
                this.add((Component)this.getButtonPanel(), "West");
            }
            if (this.getAudioPanel() != null) {
                this.add((Component)this.getAudioPanel(), "East");
            }
        }
        this.setAudioControlEnabled(false);
    }

    private void start() {
        if (this.player != null) {
            this.player.start();
        }
    }

    private void stop() {
        if (this.player != null) {
            this.player.stop();
            this.player.setMediaTime(new Time(0L));
        }
    }

    private void pause() {
        if (this.player != null) {
            this.player.stop();
        }
    }

    private void setRate(float rate) {
        if (this.player != null) {
            this.player.setRate(rate);
        }
    }

    private void setGain(float gain) {
        if (this.player != null && this.player.getGainControl() != null) {
            this.player.getGainControl().setLevel(gain);
        }
    }

    private void setMute(boolean mute) {
        if (this.player != null && this.player.getGainControl() != null) {
            this.player.getGainControl().setMute(mute);
        }
    }

    private JButton getPlayButton() {
        if ((this.flags & 1) == 0) {
            return null;
        }
        if (this.playButton == null) {
            this.playButton = new JButton();
            this.playButton.setOpaque(false);
            this.playButton.setIcon(this.skin.getPlayIcon());
            this.playButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SwingLookControlPanel.this.playButtonIsPause) {
                        SwingLookControlPanel.this.pause();
                    } else {
                        SwingLookControlPanel.this.setRate(1.0f);
                        SwingLookControlPanel.this.start();
                    }
                }
            });
            this.playButton.setEnabled(false);
        }
        return this.playButton;
    }

    private JButton getStopButton() {
        if ((this.flags & 2) == 0) {
            return null;
        }
        if (this.stopButton == null) {
            this.stopButton = new JButton();
            this.stopButton.setOpaque(false);
            this.stopButton.setIcon(this.skin.getStopIcon());
            this.stopButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SwingLookControlPanel.this.stop();
                }
            });
            this.stopButton.setEnabled(false);
        }
        return this.stopButton;
    }

    private JButton getBackButton() {
        if ((this.flags & 4) == 0) {
            return null;
        }
        if (this.backButton == null) {
            this.backButton = new JButton();
            this.backButton.setOpaque(false);
            this.backButton.setIcon(this.skin.getRewindIcon());
            this.backButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SwingLookControlPanel.this.setRate(-2.0f);
                }
            });
            this.backButton.setEnabled(false);
        }
        return this.backButton;
    }

    private JButton getForwardButton() {
        if ((this.flags & 8) == 0) {
            return null;
        }
        if (this.forwardButton == null) {
            this.forwardButton = new JButton();
            this.forwardButton.setOpaque(false);
            this.forwardButton.setIcon(this.skin.getFastForwardIcon());
            this.forwardButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SwingLookControlPanel.this.setRate(2.0f);
                }
            });
            this.forwardButton.setEnabled(false);
        }
        return this.forwardButton;
    }

    private JButton getNextButton() {
        if ((this.flags & 0x10) == 0) {
            return null;
        }
        if (this.nextButton == null) {
            this.nextButton = new JButton();
            this.nextButton.setIcon(this.skin.getStepForwardIcon());
            this.nextButton.setOpaque(false);
            this.nextButton.setEnabled(false);
        }
        return this.nextButton;
    }

    private JButton getPreviousButton() {
        if ((this.flags & 0x20) == 0) {
            return null;
        }
        if (this.previousButton == null) {
            this.previousButton = new JButton();
            this.previousButton.setOpaque(false);
            this.previousButton.setIcon(this.skin.getStepBackwardIcon());
            this.previousButton.setEnabled(false);
        }
        return this.previousButton;
    }

    private JPanel getPositionPanel() {
        if ((this.flags & 0x40) == 0) {
            return null;
        }
        if (this.positionPanel == null) {
            if ((this.flags & 0x100) != 0) {
                this.lengthLabel = new JLabel();
                this.lengthLabel.setText(SwingLookControlPanel.nanosToString(0L));
                this.lengthLabel.setOpaque(false);
            }
            if ((this.flags & 0x80) != 0) {
                this.positionLabel = new JLabel();
                this.positionLabel.setText(SwingLookControlPanel.nanosToString(0L));
                this.positionLabel.setOpaque(false);
            }
            this.positionPanel = new JPanel();
            this.positionPanel.setOpaque(false);
            this.positionPanel.setLayout(new BorderLayout());
            this.positionPanel.add((Component)this.getPositionSlider(), "Center");
            if (this.positionPanel != null) {
                this.positionPanel.add((Component)this.positionLabel, "West");
            }
            if (this.lengthLabel != null) {
                this.positionPanel.add((Component)this.lengthLabel, "East");
            }
        }
        return this.positionPanel;
    }

    private JSlider getPositionSlider() {
        if ((this.flags & 0x40) == 0) {
            return null;
        }
        if (this.positionSlider == null) {
            this.positionSlider = new JSlider();
            this.positionSlider.setOpaque(false);
            this.positionSlider.setValue(0);
            this.positionSlider.setMinimum(0);
            this.positionSlider.setMaximum(0);
            this.positionSlider.setEnabled(false);
            this.positionSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (SwingLookControlPanel.this.suppressProgressChangeNotification) {
                        return;
                    }
                    JSlider source = (JSlider)e.getSource();
                    SwingLookControlPanel.this.sliderDragInProgress = source.getValueIsAdjusting();
                    if (source.getValueIsAdjusting()) {
                        return;
                    }
                    int valueMillis = source.getValue();
                    logger.fine("User adjusted position slider to (millis): " + valueMillis + " from " + source.getMinimum() + "-" + source.getMaximum());
                    SwingLookControlPanel.this.player.setMediaTime(new Time((double)valueMillis / 1000.0));
                }
            });
        }
        return this.positionSlider;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new GridBagLayout());
            this.buttonPanel.setOpaque(false);
            if (this.getPreviousButton() != null) {
                this.buttonPanel.add((Component)this.getPreviousButton(), new GridBagConstraints());
            }
            if (this.getBackButton() != null) {
                this.buttonPanel.add((Component)this.getBackButton(), new GridBagConstraints());
            }
            if (this.getStopButton() != null) {
                this.buttonPanel.add((Component)this.getStopButton(), new GridBagConstraints());
            }
            if (this.getPlayButton() != null) {
                this.buttonPanel.add((Component)this.getPlayButton(), new GridBagConstraints());
            }
            if (this.getForwardButton() != null) {
                this.buttonPanel.add((Component)this.getForwardButton(), new GridBagConstraints());
            }
            if (this.getNextButton() != null) {
                this.buttonPanel.add((Component)this.getNextButton(), new GridBagConstraints());
            }
        }
        return this.buttonPanel;
    }

    private JPanel getAudioPanel() {
        if ((this.flags & 0x200) == 0) {
            return null;
        }
        if (this.audioPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 3;
            gridBagConstraints.weightx = 1.0;
            this.audioPanel = new JPanel();
            this.audioPanel.setLayout(new GridBagLayout());
            this.audioPanel.setOpaque(false);
            this.audioPanel.add((Component)this.getVolumeSlider(), gridBagConstraints);
            if (this.getMuteButton() != null) {
                this.audioPanel.add((Component)this.getMuteButton(), new GridBagConstraints());
            }
        }
        return this.audioPanel;
    }

    public void setAudioControlEnabled(boolean enabled) {
        if (this.getVolumeSlider() != null) {
            this.getVolumeSlider().setEnabled(enabled);
        }
        if (this.getMuteButton() != null) {
            this.getMuteButton().setEnabled(enabled);
        }
    }

    private JSlider getVolumeSlider() {
        if ((this.flags & 0x200) == 0) {
            return null;
        }
        if (this.volumeSlider == null) {
            this.volumeSlider = new JSlider();
            this.volumeSlider.setMinimum(0);
            this.volumeSlider.setMaximum(100);
            this.volumeSlider.setValue(70);
            this.volumeSlider.setPreferredSize(new Dimension(100, 29));
            this.volumeSlider.setOpaque(false);
            this.volumeSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (!SwingLookControlPanel.this.volumeSlider.getValueIsAdjusting()) {
                        float newValue = (float)SwingLookControlPanel.this.volumeSlider.getValue() / 100.0f;
                        SwingLookControlPanel.this.setGain(newValue);
                    }
                }
            });
        }
        return this.volumeSlider;
    }

    private JToggleButton getMuteButton() {
        if ((this.flags & 0x200) == 0) {
            return null;
        }
        if ((this.flags & 0x400) == 0) {
            return null;
        }
        if (this.muteButton == null) {
            this.muteButton = new JToggleButton();
            this.muteButton.setIcon(this.skin.getMuteOffIcon());
            this.muteButton.setOpaque(false);
            this.muteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SwingLookControlPanel.this.setMute(SwingLookControlPanel.this.muteButton.isSelected());
                    SwingLookControlPanel.this.muteButton.setIcon(SwingLookControlPanel.this.muteButton.isSelected() ? SwingLookControlPanel.this.skin.getMuteOnIcon() : SwingLookControlPanel.this.skin.getMuteOffIcon());
                }
            });
        }
        return this.muteButton;
    }

    public void onStateChange(TransportControlState state) {
        if (this.getStopButton() != null) {
            this.getStopButton().setEnabled(state.isAllowStop());
        }
        if (this.getPlayButton() != null && (state.isAllowPlay() || state.isAllowStop())) {
            if (state.isAllowStop()) {
                this.getPlayButton().setIcon(this.skin.getPauseIcon());
                this.playButtonIsPause = true;
            } else {
                this.getPlayButton().setIcon(this.skin.getPlayIcon());
                this.playButtonIsPause = false;
            }
            this.getPlayButton().setEnabled(state.isAllowPlay() || state.isAllowStop());
        }
        this.setAudioControlEnabled(state.isAllowVolume());
    }

    private static int nanosToMillis(long nanos) {
        return (int)(nanos / 1000000L);
    }

    public void onDurationChange(long nanos) {
        if (nanos == Duration.DURATION_UNKNOWN.getNanoseconds() || nanos == Duration.DURATION_UNBOUNDED.getNanoseconds()) {
            if (this.positionSlider != null) {
                this.suppressProgressChangeNotification = true;
                this.positionSlider.setEnabled(false);
                this.suppressProgressChangeNotification = false;
            }
            if (this.lengthLabel != null) {
                this.lengthLabel.setText("");
            }
        } else {
            if (this.positionSlider != null) {
                this.suppressProgressChangeNotification = true;
                this.positionSlider.setEnabled(true);
                this.positionSlider.setMinimum(0);
                this.positionSlider.setMaximum(SwingLookControlPanel.nanosToMillis(nanos));
                this.suppressProgressChangeNotification = false;
            }
            if (this.lengthLabel != null) {
                this.lengthLabel.setText(SwingLookControlPanel.nanosToString(nanos));
            }
        }
    }

    public void onProgressChange(long nanos) {
        if (this.positionSlider != null && this.positionSlider.isEnabled() && !this.sliderDragInProgress) {
            this.suppressProgressChangeNotification = true;
            this.positionSlider.setValue(SwingLookControlPanel.nanosToMillis(nanos));
            this.suppressProgressChangeNotification = false;
        }
        if (this.positionLabel != null) {
            this.positionLabel.setText(SwingLookControlPanel.nanosToString(nanos));
        }
    }

    private static String zeroPad(int i, int len) {
        String result = Integer.toString(i);
        while (result.length() < len) {
            result = "0" + result;
        }
        return result;
    }

    private static String nanosToString(long nanos) {
        long seconds = nanos / 1000000000L;
        long minutes = seconds / 60L;
        return "" + SwingLookControlPanel.zeroPad((int)minutes, 2) + ":" + SwingLookControlPanel.zeroPad((int)(seconds % 60L), 2);
    }

    public void timerUpdate(SourcedTimerEvent e) {
        this.onProgressChange(this.getTime());
    }

    public long getTime() {
        if (this.player == null) {
            return 0L;
        }
        return this.player.getMediaNanoseconds();
    }

    public long getConversionDivisor() {
        return 1000000000L;
    }
}

