/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.filtergraph;

import com.lti.utils.ObjUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.BadHeaderException;
import javax.media.Codec;
import javax.media.Demultiplexer;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Multiplexer;
import javax.media.PlugInManager;
import javax.media.Renderer;
import javax.media.Track;
import javax.media.control.BufferControl;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import net.sf.fmj.filtergraph.CodecFormatPair;
import net.sf.fmj.filtergraph.CodecFormatPairProximityComparator;
import net.sf.fmj.filtergraph.CodecNode;
import net.sf.fmj.filtergraph.DemuxNode;
import net.sf.fmj.filtergraph.FilterGraph;
import net.sf.fmj.filtergraph.InputPin;
import net.sf.fmj.filtergraph.Link;
import net.sf.fmj.filtergraph.MuxNode;
import net.sf.fmj.filtergraph.Node;
import net.sf.fmj.filtergraph.OutputPin;
import net.sf.fmj.filtergraph.RendererNode;
import net.sf.fmj.utility.LoggerSingleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterGraphBuilder {
    private static final Logger logger = LoggerSingleton.logger;
    private static final boolean TRACE = true;
    private static final boolean REQUIRE_GRAPH_FOR_ALL_TRACKS = false;
    private static final int MAX_FORMAT_NEGOTIATION_ITERATIONS = 100;
    private static final boolean SKIP_NON_FORMAT_CHANGING_CODECS = true;
    private static final boolean SET_RENDERER_BUFFER_LENGTH = true;
    private static final boolean FIND_NONSPECIFIC_GRAPH_FIRST = true;
    private static final boolean PRE_LINK = true;
    private static final int MAX_GRAPH_DEPTH = 10;
    private static final int TYPICAL_GRAPH_DEPTH = 10;
    private static final int BEST_FIRST_SEARCH_DEPTH = 0;
    private static final int BEST_FIRST_SEARCH_BREADTH = 5;

    public static FilterGraph buildGraphToRenderer(ContentDescriptor contentDescriptor, Demultiplexer demux) {
        return FilterGraphBuilder.buildGraphTo(4, contentDescriptor, demux, null, null, null);
    }

    public static FilterGraph buildGraphToMux(ContentDescriptor contentDescriptor, Demultiplexer demux, Multiplexer mux, Format[] muxInputFormats, int[] muxInputTrackNumbers) {
        return FilterGraphBuilder.buildGraphTo(5, contentDescriptor, demux, mux, muxInputFormats, muxInputTrackNumbers);
    }

    private static FilterGraph buildGraphTo(int pluginType, ContentDescriptor contentDescriptor, Demultiplexer demux, Multiplexer mux, Format[] muxInputFormats, int[] muxInputTrackNumbers) {
        Track[] tracks;
        try {
            tracks = demux.getTracks();
        }
        catch (BadHeaderException e) {
            logger.log(Level.WARNING, "" + e, e);
            return null;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
            return null;
        }
        if (tracks == null) {
            logger.warning("demux " + demux + ": " + "no tracks");
            return null;
        }
        DemuxNode demuxNode = new DemuxNode(contentDescriptor, demux, tracks);
        int numEnabledTracks = 0;
        for (int trackIndex = 0; trackIndex < demuxNode.getTracks().length; ++trackIndex) {
            Track t = demuxNode.getTracks()[trackIndex];
            if (!t.isEnabled()) continue;
            ++numEnabledTracks;
        }
        logger.fine("Number of tracks: " + demuxNode.getTracks().length + " enabled: " + numEnabledTracks);
        int tracksComplete = 0;
        for (int trackIndex = 0; trackIndex < demuxNode.getTracks().length; ++trackIndex) {
            InputPin muxInputPin;
            MuxNode muxNode;
            Format muxInputFormat;
            int muxDestTrack;
            Track t = demuxNode.getTracks()[trackIndex];
            if (!t.isEnabled()) {
                demuxNode.addDestLink(null);
                continue;
            }
            logger.fine("Track format for track " + trackIndex + ": " + t.getFormat());
            if (muxInputTrackNumbers == null) {
                muxDestTrack = -1;
                muxInputFormat = null;
                muxNode = null;
                muxInputPin = null;
            } else {
                muxDestTrack = muxInputTrackNumbers[trackIndex];
                muxInputFormat = muxInputFormats[muxDestTrack];
                muxNode = new MuxNode(mux, null, muxDestTrack);
                muxInputPin = muxNode.getInputPinByTrack(muxDestTrack);
            }
            Node n = FilterGraphBuilder.findCodecPathTo(demuxNode.getOutputPinByTrack(trackIndex), pluginType, t.getFormat(), demuxNode.getOutputPinByTrack(trackIndex), muxInputPin, muxInputFormat, 0);
            if (n == null) {
                demuxNode.addDestLink(null);
                continue;
            }
            ++tracksComplete;
        }
        if (tracksComplete > 0) {
            if (tracksComplete != numEnabledTracks) {
                logger.warning("Filter graphs could only be built for " + tracksComplete + " of " + numEnabledTracks + " tracks, proceeding with " + tracksComplete + " tracks");
            }
            return new FilterGraph(demuxNode);
        }
        return null;
    }

    private static Node findCodecPathTo(OutputPin rootDemuxOutputPin, int destPlugInType, Format f, OutputPin from, InputPin muxInputPin, Format muxInputFormat, int depth) {
        Node n;
        int cutoffDepth;
        for (cutoffDepth = 0; cutoffDepth < 10; ++cutoffDepth) {
            n = FilterGraphBuilder.findCodecPathTo(rootDemuxOutputPin, destPlugInType, f, from, new HashSet(), muxInputPin, muxInputFormat, depth, cutoffDepth, -1);
            if (n == null) continue;
            return n;
        }
        for (cutoffDepth = 10; cutoffDepth < 10; ++cutoffDepth) {
            n = FilterGraphBuilder.findCodecPathTo(rootDemuxOutputPin, destPlugInType, f, from, new HashSet(), muxInputPin, muxInputFormat, depth, cutoffDepth, -1);
            if (n == null) continue;
            return n;
        }
        logger.warning("Filter graph search depth at 10, abandoning deeper search");
        return null;
    }

    private static Node findCodecPathTo(OutputPin rootDemuxOutputPin, int destPlugInType, Format f, OutputPin from, Set excludeFormatAtDepths, InputPin muxInputPin, Format muxInputFormat, int depth, int cutoffDepth, int maxBestCodecs) {
        if (f == null) {
            throw new NullPointerException();
        }
        if (depth >= cutoffDepth) {
            return null;
        }
        if (excludeFormatAtDepths.contains(new FormatAtDepth(f, depth))) {
            return null;
        }
        if (destPlugInType == 4) {
            Renderer renderer = FilterGraphBuilder.findRenderer(f);
            if (renderer != null) {
                RendererNode rendererNode = new RendererNode(renderer, null);
                FilterGraphBuilder.link(from, rendererNode.getInputPin(0));
                Format fAccepted = f;
                if (fAccepted != null) {
                    rendererNode.getInputPin(0).setFormat(fAccepted);
                }
                if (fAccepted != null) {
                    BufferControl bufferControl = (BufferControl)renderer.getControl("javax.media.control.BufferControl");
                    if (bufferControl != null) {
                        bufferControl.setBufferLength(2000L);
                    }
                    if (!FilterGraphBuilder.negotiateAllFormats(rootDemuxOutputPin, rendererNode)) {
                        return null;
                    }
                    return rendererNode;
                }
            }
        } else if (destPlugInType == 5) {
            Format fAccepted;
            FilterGraphBuilder.link(from, muxInputPin);
            Format format = fAccepted = f.matches(muxInputFormat) ? f : null;
            if (fAccepted != null) {
                muxInputPin.setFormat(fAccepted);
            }
            if (fAccepted != null) {
                if (!FilterGraphBuilder.negotiateAllFormats(rootDemuxOutputPin, muxInputPin.getOwnerNode())) {
                    return null;
                }
                return muxInputPin.getOwnerNode();
            }
        } else {
            throw new IllegalArgumentException();
        }
        if (depth >= cutoffDepth - 1) {
            return null;
        }
        List<CodecFormatPair> codecFormatPairs = FilterGraphBuilder.getCodecFormatPairs(f, muxInputFormat, depth, maxBestCodecs);
        for (int j = 0; j < codecFormatPairs.size(); ++j) {
            CodecFormatPair codecFormatPair = codecFormatPairs.get(j);
            Codec codec = codecFormatPair.getCodec();
            Format codecOutputFormat = codecFormatPair.getFormat();
            logger.finer(FilterGraphBuilder.indent(depth) + "Trying " + codec.getClass().getName() + " with output format: " + codecOutputFormat);
            CodecNode codecNode = new CodecNode(codec, null);
            FilterGraphBuilder.link(from, codecNode.getInputPin(0));
            Format fAccepted = f;
            if (fAccepted != null) {
                codecNode.getInputPin(0).setFormat(fAccepted);
            }
            if (fAccepted == null) {
                logger.warning("Codec " + codec + " rejected input format (or negotiation failed) " + f);
                continue;
            }
            Format codecOutputFormatAccepted = codecOutputFormat;
            if (codecOutputFormatAccepted == null) {
                logger.warning("Codec " + codec + " rejected output format " + codecOutputFormat);
                continue;
            }
            logger.finer(FilterGraphBuilder.indent(depth) + "ACCEPT " + codecOutputFormatAccepted);
            for (int i = depth; i <= cutoffDepth; ++i) {
                excludeFormatAtDepths.add(new FormatAtDepth(f, i));
            }
            Node tail = FilterGraphBuilder.findCodecPathTo(rootDemuxOutputPin, destPlugInType, codecOutputFormatAccepted, codecNode.getOutputPin(0), excludeFormatAtDepths, muxInputPin, muxInputFormat, depth + 1, cutoffDepth, maxBestCodecs);
            if (tail == null) continue;
            return codecNode;
        }
        return null;
    }

    private static void link(OutputPin outputPin, InputPin inputPin) {
        Link existingLink = outputPin.getOwnerNode().getDestLink(outputPin);
        if (existingLink != null) {
            outputPin.getOwnerNode().removeDestLink(existingLink);
        }
        Link link = new Link(outputPin, inputPin);
        outputPin.getOwnerNode().addDestLink(link);
    }

    private static boolean negotiateAllFormats(OutputPin rootDemuxOutputPin, Node terminalNode) {
        Link link = rootDemuxOutputPin.getOwnerNode().getDestLink(rootDemuxOutputPin);
        while (link != null) {
            Format formatMustMatch = link.getDestNode() instanceof MuxNode ? link.getDestPin().getFormat() : null;
            if (FilterGraphBuilder.negotiate(link.getDestPin().getFormat(), link.getDestPin(), formatMustMatch, link.getSourcePin()) == null) {
                return false;
            }
            if (link.getDestNode().getNumDestLinks() == 0) break;
            link = link.getDestNode().getDestLink(0);
        }
        return true;
    }

    private static Format negotiate(Format initialFormat, InputPin inputPin, Format formatMustMatch, OutputPin outputPin) {
        Format f = initialFormat;
        if (formatMustMatch != null && !formatMustMatch.matches(f)) {
            return null;
        }
        int iterations = 0;
        while (f != null) {
            if (iterations >= 100) {
                logger.warning("negotiate iterated 100 times, probably stuck in infinite loop - abandoning format negotiation");
                logger.warning("src=" + outputPin.getOwnerNode().getPlugIn());
                logger.warning("dest=" + inputPin.getOwnerNode().getPlugIn());
                logger.warning("f=" + f);
                return null;
            }
            ++iterations;
            Format f2 = inputPin.setPlugInInputFormat(f);
            if (f2 == null) {
                logger.warning("Input format rejected by " + inputPin.getOwnerNode().getPlugIn() + ": " + f);
                return null;
            }
            if (!(outputPin.getOwnerNode().getPlugIn() instanceof Codec)) {
                return f2;
            }
            Format f3 = outputPin.setPlugInOutputFormat(f2);
            if (f2.equals(f3)) {
                return f3;
            }
            f = f3;
        }
        return null;
    }

    public static Demultiplexer getSourceCompatibleDemultiplexer(DataSource source) {
        logger.fine("Content type: " + source.getContentType());
        ContentDescriptor contentDescriptor = new ContentDescriptor(source.getContentType());
        Vector demuxs = PlugInManager.getPlugInList(contentDescriptor, null, 1);
        logger.fine("Num demux: " + demuxs.size());
        for (int i = 0; i < demuxs.size(); ++i) {
            String demuxClassName = (String)demuxs.get(i);
            logger.fine("Demux class name found: " + demuxClassName);
            Demultiplexer demux = (Demultiplexer)FilterGraphBuilder.instantiate(demuxClassName);
            if (demux == null) continue;
            try {
                demux.setSource(source);
            }
            catch (IncompatibleSourceException e) {
                logger.warning("Skipping demux " + demuxClassName + ": " + e);
                continue;
            }
            catch (IOException e) {
                logger.warning("Skipping demux " + demuxClassName + ": " + e);
                continue;
            }
            return demux;
        }
        return null;
    }

    private static Renderer findRenderer(Format f) {
        String rendererClassName;
        int k;
        Vector renderers = PlugInManager.getPlugInList(f, null, 4);
        if (renderers.size() == 0) {
            logger.fine("No renderers found for: " + f);
        }
        for (k = 0; k < renderers.size(); ++k) {
            rendererClassName = (String)renderers.get(k);
            logger.fine("Found renderer for " + f + ": " + rendererClassName);
        }
        for (k = 0; k < renderers.size(); ++k) {
            rendererClassName = (String)renderers.get(k);
            logger.fine("Trying renderer for " + f + ": " + rendererClassName);
            Renderer renderer = (Renderer)FilterGraphBuilder.instantiate(rendererClassName);
            if (renderer == null) continue;
            return renderer;
        }
        return null;
    }

    public static Multiplexer findMux(Format destFormat) {
        String muxClassName;
        int k;
        Vector muxs = PlugInManager.getPlugInList(null, destFormat, 5);
        if (muxs.size() == 0) {
            logger.fine("No muxs found for: " + destFormat);
            return null;
        }
        for (k = 0; k < muxs.size(); ++k) {
            muxClassName = (String)muxs.get(k);
            logger.fine("Found mux for " + destFormat + ": " + muxClassName);
        }
        for (k = 0; k < muxs.size(); ++k) {
            muxClassName = (String)muxs.get(k);
            logger.fine("Trying mux for " + destFormat + ": " + muxClassName);
            Multiplexer mux = (Multiplexer)FilterGraphBuilder.instantiate(muxClassName);
            if (mux == null) continue;
            return mux;
        }
        return null;
    }

    public static List<Multiplexer> findMuxs() {
        Vector muxs = PlugInManager.getPlugInList(null, null, 5);
        if (muxs.size() == 0) {
            logger.fine("No muxs found");
            return new ArrayList<Multiplexer>();
        }
        for (int k = 0; k < muxs.size(); ++k) {
            String muxClassName = (String)muxs.get(k);
            logger.fine("Found mux: " + muxClassName);
        }
        ArrayList<Multiplexer> result = new ArrayList<Multiplexer>();
        for (int k = 0; k < muxs.size(); ++k) {
            String muxClassName = (String)muxs.get(k);
            logger.fine("Trying mux: " + muxClassName);
            Multiplexer mux = (Multiplexer)FilterGraphBuilder.instantiate(muxClassName);
            if (mux == null) continue;
            result.add(mux);
        }
        return result;
    }

    private static final List<CodecFormatPair> getCodecFormatPairs(Format f, Format muxInputFormat, int depth, int maxBestCodecs) {
        Codec codec;
        int j;
        Vector codecs = PlugInManager.getPlugInList(f, null, 2);
        for (int j2 = 0; j2 < codecs.size(); ++j2) {
            String codecClassName = (String)codecs.get(j2);
            logger.finest(FilterGraphBuilder.indent(depth) + "Found codec for " + f + ": " + codecClassName);
        }
        ArrayList<CodecFormatPair> codecFormatPairs = new ArrayList<CodecFormatPair>();
        for (j = 0; j < codecs.size(); ++j) {
            Format codecOutputFormat;
            int codecOutputFormatIndex;
            String codecClassName = (String)codecs.get(j);
            logger.finer(FilterGraphBuilder.indent(depth) + "Trying " + codecClassName);
            codec = (Codec)FilterGraphBuilder.instantiate(codecClassName);
            if (codec == null) continue;
            Format[] codecOutputFormats = codec.getSupportedOutputFormats(f);
            if (logger.isLoggable(Level.FINEST)) {
                for (codecOutputFormatIndex = 0; codecOutputFormatIndex < codecOutputFormats.length; ++codecOutputFormatIndex) {
                    codecOutputFormat = codecOutputFormats[codecOutputFormatIndex];
                    logger.finest(FilterGraphBuilder.indent(depth) + "Found Codec output format: " + codecOutputFormat);
                }
            }
            for (codecOutputFormatIndex = 0; codecOutputFormatIndex < codecOutputFormats.length; ++codecOutputFormatIndex) {
                codecOutputFormat = codecOutputFormats[codecOutputFormatIndex];
                if (codecOutputFormat == null) {
                    logger.finer(FilterGraphBuilder.indent(depth) + "Skipping null Codec (" + codec.getClass() + ") output format, input format: " + f);
                    continue;
                }
                if (codecOutputFormat.equals(f)) {
                    logger.finest(FilterGraphBuilder.indent(depth) + "YES " + "Skipping Codec output format, same as input format: " + codecOutputFormat);
                }
                codecFormatPairs.add(new CodecFormatPair((Codec)FilterGraphBuilder.instantiate(codecClassName), codecOutputFormat));
            }
        }
        if (muxInputFormat != null) {
            Collections.sort(codecFormatPairs, new CodecFormatPairProximityComparator(muxInputFormat));
            if (maxBestCodecs > 1) {
                while (codecFormatPairs.size() > maxBestCodecs) {
                    codecFormatPairs.remove(maxBestCodecs);
                }
            }
            if (logger.isLoggable(Level.FINER)) {
                for (j = 0; j < codecFormatPairs.size(); ++j) {
                    CodecFormatPair codecFormatPair = (CodecFormatPair)codecFormatPairs.get(j);
                    codec = codecFormatPair.getCodec();
                    Format codecOutputFormat = codecFormatPair.getFormat();
                    logger.finer(FilterGraphBuilder.indent(depth) + j + ". Will try " + codec.getClass().getName() + " with output format: " + codecOutputFormat);
                }
            }
        }
        return codecFormatPairs;
    }

    private static String indent(int depth) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            b.append(' ');
        }
        return b.toString();
    }

    private static Object instantiate(String className) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            logger.warning("Unable to instantiate " + className + ": " + e.getMessage());
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            logger.warning("Unable to instantiate " + className + ": " + e.getMessage());
            return null;
        }
        catch (IllegalAccessException e) {
            logger.warning("Unable to instantiate " + className + ": " + e.getMessage());
            return null;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Unable to instantiate " + className + ": " + e.getMessage(), e);
            return null;
        }
    }

    private static class FormatAtDepth {
        private final Format f;
        private final int depth;

        public FormatAtDepth(Format f, int depth) {
            this.f = f;
            this.depth = depth;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FormatAtDepth)) {
                return false;
            }
            FormatAtDepth oCast = (FormatAtDepth)obj;
            return oCast.depth == this.depth && ObjUtils.equal(oCast.f, this.f);
        }

        public int hashCode() {
            int result = this.depth;
            if (this.f != null) {
                result += this.f.toString().hashCode();
            }
            return result;
        }
    }
}

