/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ffmpeg_java;

import com.lti.utils.collections.Queue;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import javax.media.Track;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import net.sf.ffmpeg_java.AVCodecLibrary;
import net.sf.ffmpeg_java.AVFormatLibrary;
import net.sf.ffmpeg_java.AVUtilLibrary;
import net.sf.ffmpeg_java.FFMPEGLibrary;
import net.sf.ffmpeg_java.custom_protocol.CallbackURLProtocolHandler;
import net.sf.ffmpeg_java.custom_protocol.CallbackURLProtocolMgr;
import net.sf.ffmpeg_java.util.ImageConverter;
import net.sf.ffmpeg_java.util.ImageConverterSingleton;
import net.sf.fmj.ffmpeg_java.ListFormats;
import net.sf.fmj.ffmpeg_java.PullDataSourceCallbackURLProtocolHandler;
import net.sf.fmj.media.AbstractDemultiplexer;
import net.sf.fmj.media.AbstractTrack;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.URLUtils;

public class FFMPEGParser
extends AbstractDemultiplexer {
    private static final Logger logger = LoggerSingleton.logger;
    private static final boolean PROCEED_IF_NO_AUDIO_CODEC = true;
    private final AVFormatLibrary AVFORMAT;
    private final AVCodecLibrary AVCODEC;
    private final AVUtilLibrary AVUTIL;
    private final ImageConverter imageConverter;
    private AVFormatLibrary.AVFormatContext formatCtx;
    private ContentDescriptor[] supportedInputContentDescriptors = null;
    static final String FIRST_FFMPEG_DEMUX_NAME = "aac";
    private static final Object AV_SYNC_OBJ = new Boolean(true);
    private PullDataSource source;
    private PullSourceStreamTrack[] tracks;
    private Queue[] packetQueues;
    static final String[] AAC_MIMETYPE = new String[]{"audio/X-HX-AAC-ADTS"};
    static final String[] DV_MIMETYPE = new String[]{"video/x-dv"};
    static final String[] H264_MIMETYPE = new String[]{"video/mp4"};
    static final String[] M4V_MIMETYPE = new String[]{"video/mp4v-es"};
    static final String[] ALAW_MIMETYPE = new String[]{"audio/x-alaw"};
    static final String[] MULAW_MIMETYPE = new String[]{"audio/x-mulaw"};
    static final String[] ASF_MIMETYPES = new String[]{"video/x-ms-wmv", "video/x-ms-wma"};
    static final String[] FLIC_MIMETYPES = new String[]{"video/fli", "video/flc", "video/x-fli", "video/x-flc"};
    static final String[] MATROSKA_MIMETYPES = new String[]{"video/x-matroska", "audio/x-matroska"};
    static final String[] MJPEG_MIMETYPE = new String[]{"video/x-motion-jpeg"};
    static final String[] MOV_MP4_M4A_3GP_3G2_MJ2_MIMETYPES = new String[]{"video/quicktime", "video/mp4", "video/3gpp", "video/mj2"};
    static final String[] MUSEPACK_MIMETYPE = new String[]{"audio/x-musepack"};
    static final String[] MPEGTSRAW_MIMETYPE = new String[]{"video/x-mpegts"};
    static final String[] MPEG1VIDEO_MIMETYPE = new String[]{"video/mpeg"};
    static final String[] MPEG2VIDEO_MIMETYPES = new String[]{"video/mpv", "video/mp2p"};
    static final String[] MTV_MIMETYPE = new String[]{"video/x-amv"};
    static final String[] MXF_MIMETYPE = new String[]{"application/mxf"};
    static final String[] NUV_MIMETYPE = new String[]{"video/x-nuv"};
    static final String[] NSV_MIMETYPE = new String[]{"application/x-nsv-vp3-mp3"};
    static final String[] OGG_MIMETYPE = new String[]{"audio/ogg"};
    static final String[] SHN_MIMETYPE = new String[]{"application/x-shorten"};
    static final String[] TTA_MIMETYPE = new String[]{"audio/x-tta"};
    static final String[] WAVPACK_MIMETYPE = new String[]{"audio/x-wavpack"};
    static final String[] NOT_SUPPORTED_FORMAT = new String[0];
    static final String[] FOURXM_MIMETYPE = new String[]{"video/x-4xm"};
    static final String[] APC_MIMETYPE = new String[]{"audio/x-apc"};
    static final String[] AVS_MIMETYPE = new String[]{"video/x-avs"};
    static final String[] BETHSOFTVID_MIMETYPE = new String[]{"video/x-bethsoft-vid"};
    static final String[] C93_MIMETYPE = new String[]{"video/x-c93"};
    static final String[] CPK_MIMETYPE = new String[]{"video/x-film-cpk"};
    static final String[] DXA_MIMETYPE = new String[]{"video/x-dxa"};
    static final String[] DSICIN_MIMETYPE = new String[]{"video/x-dsicin"};
    static final String[] DTS_MIMETYPE = new String[]{"audio/x-raw-dts"};
    static final String[] EA_MIMETYPE = new String[]{"video/x-ea"};
    static final String[] GXF_MIMETYPE = new String[]{"video/x-gxf"};
    static final String[] IDCIN_MIMETYPE = new String[]{"video/x-idcin"};
    static final String[] INGENIENT_MIMETYPE = new String[]{"video/x-ingenient"};
    static final String[] MM_MIMETYPE = new String[]{"video/x-mm"};
    static final String[] MVE_MIMETYPE = new String[]{"video/x-mve"};
    static final String[] PSXSTR_MIMETYPE = new String[]{"audio/x-psxstr"};
    static final String[] RAWVIDEO_MIMETYPE = new String[]{"video/x-raw-yuv"};
    static final String[] ROQ_MIMETYPE = new String[]{"video/x-roq"};
    static final String[] SMK_MIMETYPE = new String[]{"video/x-smk"};
    static final String[] SOL_MIMETYPE = new String[]{"audio/x-sol"};
    static final String[] THP_MIMETYPE = new String[]{"video/x-thp"};
    static final String[] SEQ_MIMETYPE = new String[]{"video/x-seq"};
    static final String[] TXD_MIMETYPE = new String[]{"video/x-txd"};
    static final String[] VC1_MIMETYPE = new String[]{"video/x-raw-vc1"};
    static final String[] VMD_MIMETYPE = new String[]{"video/x-vmd"};
    static final String[] WC3MOVIE_MIMETYPE = new String[]{"video/x-wc3-movie"};
    static final String[] WSAUD_MIMETYPE = new String[]{"video/x-wsaud"};
    static final String[] WSVQA_MIMETYPE = new String[]{"video/x-wsvqa"};

    public FFMPEGParser() {
        try {
            this.AVFORMAT = AVFormatLibrary.INSTANCE;
            this.AVCODEC = AVCodecLibrary.INSTANCE;
            this.AVUTIL = AVUtilLibrary.INSTANCE;
            this.imageConverter = ImageConverterSingleton.instance();
            this.AVFORMAT.av_register_all();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Unable to initialize ffmpeg libraries: " + t);
            throw new RuntimeException(t);
        }
    }

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        if (this.supportedInputContentDescriptors == null) {
            this.queryInputContentDescriptors();
        }
        return this.supportedInputContentDescriptors;
    }

    protected void queryInputContentDescriptors() {
        HashMap<String, String[]> additionalFormatMimeTypes = new HashMap<String, String[]>();
        additionalFormatMimeTypes.put("4xm", FOURXM_MIMETYPE);
        additionalFormatMimeTypes.put(FIRST_FFMPEG_DEMUX_NAME, AAC_MIMETYPE);
        additionalFormatMimeTypes.put("alaw", ALAW_MIMETYPE);
        additionalFormatMimeTypes.put("apc", APC_MIMETYPE);
        additionalFormatMimeTypes.put("asf", ASF_MIMETYPES);
        additionalFormatMimeTypes.put("avs", AVS_MIMETYPE);
        additionalFormatMimeTypes.put("bethsoftvid", BETHSOFTVID_MIMETYPE);
        additionalFormatMimeTypes.put("c93", C93_MIMETYPE);
        additionalFormatMimeTypes.put("daud", NOT_SUPPORTED_FORMAT);
        additionalFormatMimeTypes.put("dsicin", DSICIN_MIMETYPE);
        additionalFormatMimeTypes.put("dts", DTS_MIMETYPE);
        additionalFormatMimeTypes.put("dv", DV_MIMETYPE);
        additionalFormatMimeTypes.put("dxa", DXA_MIMETYPE);
        additionalFormatMimeTypes.put("ea", EA_MIMETYPE);
        additionalFormatMimeTypes.put("ffm", NOT_SUPPORTED_FORMAT);
        additionalFormatMimeTypes.put("film_cpk", CPK_MIMETYPE);
        additionalFormatMimeTypes.put("flic", FLIC_MIMETYPES);
        additionalFormatMimeTypes.put("gxf", GXF_MIMETYPE);
        additionalFormatMimeTypes.put("h264", H264_MIMETYPE);
        additionalFormatMimeTypes.put("idcin", IDCIN_MIMETYPE);
        additionalFormatMimeTypes.put("image2", NOT_SUPPORTED_FORMAT);
        additionalFormatMimeTypes.put("image2pipe", NOT_SUPPORTED_FORMAT);
        additionalFormatMimeTypes.put("ingenient", INGENIENT_MIMETYPE);
        additionalFormatMimeTypes.put("ipmovie", MVE_MIMETYPE);
        additionalFormatMimeTypes.put("m4v", M4V_MIMETYPE);
        additionalFormatMimeTypes.put("matroska", MATROSKA_MIMETYPES);
        additionalFormatMimeTypes.put("mjpeg", MJPEG_MIMETYPE);
        additionalFormatMimeTypes.put("mm", MM_MIMETYPE);
        additionalFormatMimeTypes.put("mov,mp4,m4a,3gp,3g2,mj2", MOV_MP4_M4A_3GP_3G2_MJ2_MIMETYPES);
        additionalFormatMimeTypes.put("mpc", MUSEPACK_MIMETYPE);
        additionalFormatMimeTypes.put("mpegvideo", MPEG1VIDEO_MIMETYPE);
        additionalFormatMimeTypes.put("mpeg", MPEG2VIDEO_MIMETYPES);
        additionalFormatMimeTypes.put("mpegtsraw", MPEGTSRAW_MIMETYPE);
        additionalFormatMimeTypes.put("MTV", MTV_MIMETYPE);
        additionalFormatMimeTypes.put("mulaw", MULAW_MIMETYPE);
        additionalFormatMimeTypes.put("mxf", MXF_MIMETYPE);
        additionalFormatMimeTypes.put("nsv", NSV_MIMETYPE);
        additionalFormatMimeTypes.put("nuv", NUV_MIMETYPE);
        additionalFormatMimeTypes.put("ogg", OGG_MIMETYPE);
        additionalFormatMimeTypes.put("psxstr", PSXSTR_MIMETYPE);
        additionalFormatMimeTypes.put("rawvideo", RAWVIDEO_MIMETYPE);
        additionalFormatMimeTypes.put("RoQ", ROQ_MIMETYPE);
        additionalFormatMimeTypes.put("redir", NOT_SUPPORTED_FORMAT);
        additionalFormatMimeTypes.put("rtsp", NOT_SUPPORTED_FORMAT);
        additionalFormatMimeTypes.put("s16be", NOT_SUPPORTED_FORMAT);
        additionalFormatMimeTypes.put("s16le", NOT_SUPPORTED_FORMAT);
        additionalFormatMimeTypes.put("s8", NOT_SUPPORTED_FORMAT);
        additionalFormatMimeTypes.put("sdp", NOT_SUPPORTED_FORMAT);
        additionalFormatMimeTypes.put("shn", SHN_MIMETYPE);
        additionalFormatMimeTypes.put("smk", SMK_MIMETYPE);
        additionalFormatMimeTypes.put("sol", SOL_MIMETYPE);
        additionalFormatMimeTypes.put("thp", THP_MIMETYPE);
        additionalFormatMimeTypes.put("tiertexseq", SEQ_MIMETYPE);
        additionalFormatMimeTypes.put("tta", TTA_MIMETYPE);
        additionalFormatMimeTypes.put("txd", TXD_MIMETYPE);
        additionalFormatMimeTypes.put("u16be", NOT_SUPPORTED_FORMAT);
        additionalFormatMimeTypes.put("u16le", NOT_SUPPORTED_FORMAT);
        additionalFormatMimeTypes.put("u8", NOT_SUPPORTED_FORMAT);
        additionalFormatMimeTypes.put("vc1", VC1_MIMETYPE);
        additionalFormatMimeTypes.put("vmd", VMD_MIMETYPE);
        additionalFormatMimeTypes.put("wc3movie", WC3MOVIE_MIMETYPE);
        additionalFormatMimeTypes.put("wsaud", WSAUD_MIMETYPE);
        additionalFormatMimeTypes.put("wsvqa", WSVQA_MIMETYPE);
        additionalFormatMimeTypes.put("wv", WAVPACK_MIMETYPE);
        additionalFormatMimeTypes.put("yuv4mpegpipe", NOT_SUPPORTED_FORMAT);
        HashMap<String, ContentDescriptor> mimeTypes = new HashMap<String, ContentDescriptor>();
        int i = 1;
        AVFormatLibrary.AVInputFormat avInputFormat = this.AVFORMAT.av_find_input_format(FIRST_FFMPEG_DEMUX_NAME);
        while (avInputFormat != null) {
            String[] additionalMimeTypes;
            String mimeType = null;
            AVFormatLibrary.AVOutputFormat avOutputFormat = this.AVFORMAT.guess_format(avInputFormat.name, null, null);
            if (avOutputFormat != null && avOutputFormat.mime_type != null && avOutputFormat.mime_type.length() > 0) {
                mimeType = avOutputFormat.mime_type;
                mimeTypes.put(mimeType, new ContentDescriptor(ContentDescriptor.mimeTypeToPackageName(mimeType)));
                logger.log(Level.FINEST, i + ". " + avInputFormat.long_name + " : " + mimeType);
            }
            if ((additionalMimeTypes = (String[])additionalFormatMimeTypes.get(avInputFormat.name)) != null) {
                if (additionalMimeTypes == NOT_SUPPORTED_FORMAT) {
                    logger.log(Level.FINE, "Ignoring input format: " + avInputFormat.name + " (" + avInputFormat.long_name + ")");
                } else {
                    for (int j = 0; j < additionalMimeTypes.length; ++j) {
                        mimeType = additionalMimeTypes[j];
                        mimeTypes.put(mimeType, new ContentDescriptor(ContentDescriptor.mimeTypeToPackageName(mimeType)));
                        logger.log(Level.FINEST, i + ". " + avInputFormat.long_name + " : " + additionalMimeTypes[j]);
                    }
                }
            }
            if (mimeType == null && additionalMimeTypes == null) {
                mimeType = "ffmpeg/" + avInputFormat.name;
                mimeTypes.put(mimeType, new ContentDescriptor(ContentDescriptor.mimeTypeToPackageName(mimeType)));
            }
            ++i;
            if (avInputFormat.next != null) {
                avInputFormat = new AVFormatLibrary.AVInputFormat(avInputFormat.next);
                continue;
            }
            avInputFormat = null;
        }
        this.supportedInputContentDescriptors = mimeTypes.values().toArray(new ContentDescriptor[0]);
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        return this.tracks;
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        if (!(source instanceof PullDataSource)) {
            throw new IncompatibleSourceException();
        }
        this.source = (PullDataSource)source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws ResourceUnavailableException {
        Object object = AV_SYNC_OBJ;
        synchronized (object) {
            int i;
            String urlStr;
            String protocol;
            try {
                this.AVCODEC.avcodec_init();
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "" + t, t);
                throw new ResourceUnavailableException("avcodec_init or av_register_all failed");
            }
            if (this.AVCODEC.avcodec_version() != 3355137) {
                logger.warning("ffmpeg-java and ffmpeg versions do not match: avcodec_version=" + this.AVCODEC.avcodec_version() + " LIBAVCODEC_VERSION_INT=" + 3355137);
            }
            if ((protocol = this.source.getLocator().getProtocol()).equals("file") || protocol.equals("http")) {
                urlStr = protocol.equals("file") ? URLUtils.extractValidPathFromFileUrl(this.source.getLocator().toExternalForm()) : this.source.getLocator().toExternalForm();
            } else {
                String callbackURL;
                CallbackURLProtocolMgr.register((AVFormatLibrary)this.AVFORMAT);
                urlStr = callbackURL = CallbackURLProtocolMgr.addCallbackURLProtocolHandler((CallbackURLProtocolHandler)new PullDataSourceCallbackURLProtocolHandler(this.source));
            }
            PointerByReference ppFormatCtx = new PointerByReference();
            int ret = this.AVFORMAT.av_open_input_file(ppFormatCtx, urlStr, null, 0, null);
            if (ret != 0) {
                throw new ResourceUnavailableException("av_open_input_file failed: " + ret);
            }
            this.formatCtx = new AVFormatLibrary.AVFormatContext(ppFormatCtx.getValue());
            if (this.AVFORMAT.av_find_stream_info(this.formatCtx) < 0) {
                throw new ResourceUnavailableException("Couldn't find stream information");
            }
            this.AVFORMAT.dump_format(this.formatCtx, 0, urlStr, 0);
            VideoTrack videoTrack = null;
            AudioTrack audioTrack = null;
            for (i = 0; i < this.formatCtx.nb_streams; ++i) {
                AVFormatLibrary.AVStream stream = new AVFormatLibrary.AVStream(this.formatCtx.getStreams()[i]);
                AVCodecLibrary.AVCodecContext codecCtx = new AVCodecLibrary.AVCodecContext(stream.codec);
                if (codecCtx.codec_id == 0) {
                    logger.info("Codec id is zero (no codec) - skipping stream " + i);
                    continue;
                }
                if (codecCtx.codec_type == 0 && videoTrack == null) {
                    videoTrack = new VideoTrack(i, stream, codecCtx);
                    continue;
                }
                if (codecCtx.codec_type != 1 || audioTrack != null) continue;
                try {
                    audioTrack = new AudioTrack(i, stream, codecCtx);
                    continue;
                }
                catch (ResourceUnavailableException e) {
                    logger.log(Level.WARNING, "Skipping audio track: " + e, e);
                }
            }
            if (audioTrack == null && videoTrack == null) {
                throw new ResourceUnavailableException("No audio or video track found");
            }
            this.tracks = audioTrack != null && videoTrack != null ? new PullSourceStreamTrack[]{videoTrack, audioTrack} : (audioTrack != null ? new PullSourceStreamTrack[]{audioTrack} : new PullSourceStreamTrack[]{videoTrack});
            this.packetQueues = new Queue[this.formatCtx.nb_streams];
            for (i = 0; i < this.packetQueues.length; ++i) {
                this.packetQueues[i] = new Queue();
            }
        }
        super.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = AV_SYNC_OBJ;
        synchronized (object) {
            if (this.tracks != null) {
                for (int i = 0; i < this.tracks.length; ++i) {
                    if (this.tracks[i] == null) continue;
                    this.tracks[i].deallocate();
                    this.tracks[i] = null;
                }
                this.tracks = null;
            }
            if (this.formatCtx != null) {
                this.AVFORMAT.av_close_input_file(this.formatCtx);
                this.formatCtx = null;
            }
        }
        super.close();
    }

    public void start() throws IOException {
    }

    public boolean isPositionable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time setPosition(Time where, int rounding) {
        Object object = AV_SYNC_OBJ;
        synchronized (object) {
            int result = this.AVFORMAT.av_seek_frame(this.formatCtx, -1, where.getNanoseconds() / 1000L, 0);
            if (result < 0) {
                logger.severe("av_seek_frame failed with code " + result);
            }
            return where;
        }
    }

    public boolean isRandomAccess() {
        return super.isRandomAccess();
    }

    static FFMPEGLibrary.AVRational getTimeBase(AVFormatLibrary.AVStream stream, AVCodecLibrary.AVCodecContext codecCtx) {
        if (stream.r_frame_rate.num != 0 && stream.r_frame_rate.den != 0) {
            FFMPEGLibrary.AVRational result = new FFMPEGLibrary.AVRational();
            result.num = stream.r_frame_rate.den;
            result.den = stream.r_frame_rate.num;
            return result;
        }
        if (stream.time_base.num != 0 && stream.time_base.den != 0) {
            return stream.time_base;
        }
        return codecCtx.time_base;
    }

    static double getFPS(AVFormatLibrary.AVStream stream, AVCodecLibrary.AVCodecContext codecCtx) {
        FFMPEGLibrary.AVRational time_base = FFMPEGParser.getTimeBase(stream, codecCtx);
        return (double)time_base.den / (double)time_base.num;
    }

    static long getTimestamp(AVCodecLibrary.AVFrame frame, AVFormatLibrary.AVStream stream, AVCodecLibrary.AVCodecContext codecCtx, long frameNo, long packetDts) {
        double pts = packetDts != Long.MIN_VALUE ? (double)packetDts : (frame.opaque != null && (long)frame.opaque.getInt(0L) != Long.MIN_VALUE ? (double)frame.opaque.getInt(0L) : 0.0);
        return (long)((pts *= (double)stream.time_base.num / (double)stream.time_base.den) * 1.0E9);
    }

    public static AudioFormat convertCodecAudioFormat(AVCodecLibrary.AVCodecContext codecCtx) {
        AudioFormat result = null;
        switch (codecCtx.codec_id) {
            case 86020: {
                result = new AudioFormat("dolbyac3", codecCtx.sample_rate, 16, codecCtx.channels, ListFormats.isBigEndian() ? 1 : 0, 1);
                break;
            }
            default: {
                result = new AudioFormat("LINEAR", codecCtx.sample_rate, 16, codecCtx.channels, ListFormats.isBigEndian() ? 1 : 0, 1);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AVFormatLibrary.AVPacket nextPacket(int streamIndex) {
        Object object = AV_SYNC_OBJ;
        synchronized (object) {
            AVFormatLibrary.AVPacket packet;
            if (!this.packetQueues[streamIndex].isEmpty()) {
                return (AVFormatLibrary.AVPacket)this.packetQueues[streamIndex].dequeue();
            }
            while (this.AVFORMAT.av_read_frame(this.formatCtx, packet = new AVFormatLibrary.AVPacket()) >= 0) {
                if (packet.stream_index == streamIndex) {
                    return packet;
                }
                this.packetQueues[packet.stream_index].enqueue(packet);
            }
            return null;
        }
    }

    private class AudioTrack
    extends PullSourceStreamTrack {
        private final int audioStreamIndex;
        AVFormatLibrary.AVStream stream;
        private AVCodecLibrary.AVCodecContext codecCtx;
        private final AVCodecLibrary.AVCodec codec;
        private Pointer buffer;
        private int bufferSize;
        private final AudioFormat format;
        private long frameNo;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AudioTrack(int audioStreamIndex, AVFormatLibrary.AVStream stream, AVCodecLibrary.AVCodecContext codecCtx) throws ResourceUnavailableException {
            this.audioStreamIndex = audioStreamIndex;
            this.stream = stream;
            this.codecCtx = codecCtx;
            Object object = AV_SYNC_OBJ;
            synchronized (object) {
                this.codec = FFMPEGParser.this.AVCODEC.avcodec_find_decoder(codecCtx.codec_id);
                if (this.codec == null) {
                    throw new ResourceUnavailableException("Codec not found for codec_id " + codecCtx.codec_id + " (0x" + Integer.toHexString(codecCtx.codec_id) + ")");
                }
                if (FFMPEGParser.this.AVCODEC.avcodec_open(codecCtx, this.codec) < 0) {
                    throw new ResourceUnavailableException("Could not open codec");
                }
                this.bufferSize = 192000;
                this.buffer = FFMPEGParser.this.AVUTIL.av_malloc(this.bufferSize);
                this.format = FFMPEGParser.convertCodecAudioFormat(codecCtx);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deallocate() {
            Object object = AV_SYNC_OBJ;
            synchronized (object) {
                if (this.codecCtx != null) {
                    FFMPEGParser.this.AVCODEC.avcodec_close(this.codecCtx);
                    this.codecCtx = null;
                }
                if (this.buffer != null) {
                    FFMPEGParser.this.AVUTIL.av_free(this.buffer);
                    this.buffer = null;
                }
            }
        }

        public long skipNanos(long nanos) throws IOException {
            return 0L;
        }

        public boolean canSkipNanos() {
            return false;
        }

        public Format getFormat() {
            return this.format;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFrame(Buffer buffer) {
            AVFormatLibrary.AVPacket packet = FFMPEGParser.this.nextPacket(this.audioStreamIndex);
            if (packet != null) {
                Object object = AV_SYNC_OBJ;
                synchronized (object) {
                    IntByReference frameSize = new IntByReference();
                    frameSize.setValue(this.bufferSize);
                    FFMPEGParser.this.AVCODEC.avcodec_decode_audio2(this.codecCtx, this.buffer, frameSize, packet.data, packet.size);
                    if (frameSize.getValue() < 0) {
                        throw new RuntimeException("Failed to read audio frame");
                    }
                    if (frameSize.getValue() > 0) {
                        if (frameSize.getValue() > this.bufferSize) {
                            FFMPEGParser.this.AVUTIL.av_free(this.buffer);
                            this.bufferSize = frameSize.getValue();
                            this.buffer = FFMPEGParser.this.AVUTIL.av_malloc(this.bufferSize);
                        }
                        byte[] data = this.buffer.getByteArray(0L, frameSize.getValue());
                        buffer.setData(data);
                        buffer.setLength(data.length);
                        buffer.setOffset(0);
                        buffer.setEOM(false);
                        buffer.setDiscard(false);
                        buffer.setTimeStamp(System.currentTimeMillis());
                    } else {
                        buffer.setLength(0);
                        buffer.setDiscard(true);
                    }
                    if (packet.destruct != null) {
                        packet.destruct.callback(packet);
                    }
                }
            } else {
                buffer.setLength(0);
                buffer.setEOM(true);
                return;
            }
        }

        public Time mapFrameToTime(int frameNumber) {
            return TIME_UNKNOWN;
        }

        public int mapTimeToFrame(Time t) {
            return Integer.MAX_VALUE;
        }

        public Time getDuration() {
            if (((FFMPEGParser)FFMPEGParser.this).formatCtx.duration <= 0L) {
                return Duration.DURATION_UNKNOWN;
            }
            return new Time(((FFMPEGParser)FFMPEGParser.this).formatCtx.duration * 1000L);
        }
    }

    private class VideoTrack
    extends PullSourceStreamTrack {
        private final int videoStreamIndex;
        private AVFormatLibrary.AVStream stream;
        private AVCodecLibrary.AVCodecContext codecCtx;
        private AVCodecLibrary.AVCodec codec;
        private AVCodecLibrary.AVFrame srcFrame;
        private AVCodecLibrary.AVFrame dstFrame;
        private VideoFormat format;
        private Pointer buffer;
        private int dstPixFmt;
        private long frameNo;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VideoTrack(int videoStreamIndex, AVFormatLibrary.AVStream stream, AVCodecLibrary.AVCodecContext codecCtx) throws ResourceUnavailableException {
            this.videoStreamIndex = videoStreamIndex;
            this.stream = stream;
            this.codecCtx = codecCtx;
            Object object = AV_SYNC_OBJ;
            synchronized (object) {
                this.codec = FFMPEGParser.this.AVCODEC.avcodec_find_decoder(codecCtx.codec_id);
                if (this.codec == null) {
                    throw new ResourceUnavailableException("Codec not found for codec_id " + codecCtx.codec_id + " (0x" + Integer.toHexString(codecCtx.codec_id) + ")");
                }
                if (FFMPEGParser.this.AVCODEC.avcodec_open(codecCtx, this.codec) < 0) {
                    throw new ResourceUnavailableException("Could not open codec");
                }
                this.srcFrame = FFMPEGParser.this.AVCODEC.avcodec_alloc_frame();
                if (this.srcFrame == null) {
                    throw new ResourceUnavailableException("Could not allocate frame");
                }
                this.dstFrame = FFMPEGParser.this.AVCODEC.avcodec_alloc_frame();
                if (this.dstFrame == null) {
                    throw new ResourceUnavailableException("Could not allocate frame");
                }
                float frameRate = (float)FFMPEGParser.getFPS(stream, codecCtx);
                this.dstPixFmt = ListFormats.getPreferedPixelFormat();
                this.format = ListFormats.convertCodecPixelFormat(this.dstPixFmt, codecCtx.width, codecCtx.height, frameRate);
                if (this.format == null) {
                    this.dstPixFmt = 6;
                    this.format = ListFormats.convertCodecPixelFormat(this.dstPixFmt, codecCtx.width, codecCtx.height, frameRate);
                }
                int numBytes = FFMPEGParser.this.AVCODEC.avpicture_get_size(this.dstPixFmt, codecCtx.width, codecCtx.height);
                this.buffer = FFMPEGParser.this.AVUTIL.av_malloc(numBytes);
                FFMPEGParser.this.AVCODEC.avpicture_fill(this.dstFrame, this.buffer, this.dstPixFmt, codecCtx.width, codecCtx.height);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deallocate() {
            Object object = AV_SYNC_OBJ;
            synchronized (object) {
                if (this.codecCtx != null) {
                    FFMPEGParser.this.AVCODEC.avcodec_close(this.codecCtx);
                    this.codecCtx = null;
                }
                if (this.dstFrame != null) {
                    FFMPEGParser.this.AVUTIL.av_free(this.dstFrame.getPointer());
                    this.dstFrame = null;
                }
                if (this.srcFrame != null) {
                    FFMPEGParser.this.AVUTIL.av_free(this.srcFrame.getPointer());
                    this.srcFrame = null;
                }
                if (this.buffer != null) {
                    FFMPEGParser.this.AVUTIL.av_free(this.buffer);
                    this.buffer = null;
                }
            }
        }

        public long skipNanos(long nanos) throws IOException {
            return 0L;
        }

        public boolean canSkipNanos() {
            return false;
        }

        public Format getFormat() {
            return this.format;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFrame(Buffer buffer) {
            long dts = -1L;
            AVFormatLibrary.AVPacket packet = FFMPEGParser.this.nextPacket(this.videoStreamIndex);
            if (packet != null) {
                Object object = AV_SYNC_OBJ;
                synchronized (object) {
                    IntByReference frameFinished = new IntByReference();
                    FFMPEGParser.this.AVCODEC.avcodec_decode_video(this.codecCtx, this.srcFrame, frameFinished, packet.data, packet.size);
                    if (dts == -1L || packet.dts < dts) {
                        dts = packet.dts;
                    }
                    if (frameFinished.getValue() != 0) {
                        Object[] data;
                        int res = FFMPEGParser.this.imageConverter.img_convert(this.dstFrame, this.dstPixFmt, this.srcFrame, this.codecCtx.pix_fmt, this.codecCtx.width, this.codecCtx.height);
                        if (res < 0) {
                            throw new RuntimeException("img_convert failed: " + res);
                        }
                        int length = this.codecCtx.height * this.dstFrame.linesize[0];
                        Class dataType = this.format.getDataType();
                        if (Format.intArray.equals(dataType)) {
                            data = this.dstFrame.data0.getIntArray(0L, length /= 4);
                        } else if (Format.shortArray.equals(dataType)) {
                            data = this.dstFrame.data0.getShortArray(0L, length /= 2);
                        } else if (Format.byteArray.equals(dataType)) {
                            data = this.dstFrame.data0.getByteArray(0L, length);
                        } else {
                            throw new RuntimeException("Can't handle datatype of format:" + dataType);
                        }
                        buffer.setData(data);
                        buffer.setLength(length);
                        buffer.setOffset(0);
                        buffer.setEOM(false);
                        buffer.setDiscard(false);
                        buffer.setTimeStamp(FFMPEGParser.getTimestamp(this.srcFrame, this.stream, this.codecCtx, this.frameNo++, dts));
                        dts = -1L;
                    } else {
                        buffer.setLength(0);
                        buffer.setDiscard(true);
                    }
                    if (packet.destruct != null) {
                        packet.destruct.callback(packet);
                    }
                }
            } else {
                buffer.setLength(0);
                buffer.setEOM(true);
                return;
            }
        }

        public Time mapFrameToTime(int frameNumber) {
            return TIME_UNKNOWN;
        }

        public int mapTimeToFrame(Time t) {
            return Integer.MAX_VALUE;
        }

        public Time getDuration() {
            if (((FFMPEGParser)FFMPEGParser.this).formatCtx.duration <= 0L) {
                return Duration.DURATION_UNKNOWN;
            }
            return new Time(((FFMPEGParser)FFMPEGParser.this).formatCtx.duration * 1000L);
        }
    }

    private abstract class PullSourceStreamTrack
    extends AbstractTrack {
        private PullSourceStreamTrack() {
        }

        public abstract void deallocate();
    }
}

