/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.gui.controls;

import java.awt.Component;
import java.util.EventListener;
import javax.media.Controller;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Duration;
import javax.media.MediaTimeSetEvent;
import javax.media.PrefetchCompleteEvent;
import javax.media.RestartingEvent;
import javax.media.StartEvent;
import javax.media.StopEvent;
import javax.media.Time;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.fmj.ejmf.toolkit.gui.controls.ChangeListenerControl;
import net.sf.fmj.ejmf.toolkit.gui.controls.ProgressBar;
import net.sf.fmj.ejmf.toolkit.gui.controls.Skin;
import net.sf.fmj.ejmf.toolkit.util.SourcedTimer;
import net.sf.fmj.ejmf.toolkit.util.SourcedTimerEvent;
import net.sf.fmj.ejmf.toolkit.util.SourcedTimerListener;
import net.sf.fmj.ejmf.toolkit.util.TimeSource;

public class StandardProgressControl
extends ChangeListenerControl
implements ControllerListener,
TimeSource,
SourcedTimerListener {
    private boolean firstPrefetch = true;
    private SourcedTimer controlTimer;
    private long duration;
    private static final int TIMER_TICK = 250;

    public StandardProgressControl(Skin skin, Controller controller) {
        this(skin);
        this.setController(controller);
    }

    public StandardProgressControl(Skin skin) {
        super(skin);
    }

    protected Component createControlComponent(Skin skin) {
        return skin.createProgressSlider();
    }

    protected void setControllerHook(Controller controller) {
        this.setOperational(false);
        this.getController().addControllerListener(this);
        if (controller.getState() >= 500) {
            this.init();
        }
    }

    private void init() {
        boolean flg;
        Time d = this.getController().getDuration();
        boolean bl = flg = d != Duration.DURATION_UNBOUNDED && d != Duration.DURATION_UNKNOWN;
        if (flg) {
            this.duration = d.getNanoseconds();
            flg = this.duration != 0L;
        }
        this.setOperational(flg);
        if (flg) {
            this.controlTimer = new SourcedTimer((TimeSource)this, 250);
            this.controlTimer.addSourcedTimerListener(this);
            Time mTime = this.getController().getMediaTime();
            long mediaTime = mTime.getNanoseconds();
            this.setValue(mediaTime);
            if (this.getController().getState() == 600) {
                this.controlTimer.start();
            }
        }
    }

    protected EventListener createControlListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ProgressBar s = (ProgressBar)e.getSource();
                int value = s.getValue();
                long mediaNanos = (long)value * StandardProgressControl.this.duration / (long)(s.getMaximum() - s.getMinimum());
                Controller controller = StandardProgressControl.this.getController();
                int priorState = controller.getState();
                if (priorState == 600) {
                    controller.stop();
                }
                controller.setMediaTime(new Time(mediaNanos));
                if (priorState == 600) {
                    Time now = controller.getTimeBase().getTime();
                    controller.syncStart(now);
                }
            }
        };
    }

    public void setValue(long mediaTime) {
        if (!this.isOperational()) {
            return;
        }
        ProgressBar bar = (ProgressBar)((Object)this.getControlComponent());
        long diff = bar.getMaximum() - bar.getMinimum();
        int value = (int)(diff * mediaTime / this.duration);
        SwingUtilities.invokeLater(new SetProgressSliderValueThread(bar, value));
    }

    public void controllerUpdate(ControllerEvent event) {
        if (this.isOperational()) {
            if (event instanceof StartEvent || event instanceof RestartingEvent) {
                this.controlTimer.start();
            } else if (event instanceof StopEvent || event instanceof ControllerErrorEvent) {
                this.controlTimer.stop();
            } else if (event instanceof MediaTimeSetEvent) {
                this.setValue(this.getTime());
            }
        } else if (this.firstPrefetch && event instanceof PrefetchCompleteEvent) {
            this.firstPrefetch = false;
            this.init();
        }
    }

    public void timerUpdate(SourcedTimerEvent e) {
        this.setValue(this.getTime());
    }

    public long getTime() {
        return this.getController().getMediaNanoseconds();
    }

    public long getConversionDivisor() {
        return 1000000000L;
    }

    class SetProgressSliderValueThread
    implements Runnable {
        int value;
        ProgressBar bar;

        public SetProgressSliderValueThread(ProgressBar bar, int value) {
            this.value = value;
            this.bar = bar;
        }

        public void run() {
            this.bar.setValue(this.value);
        }
    }

    class EnableComponentThread
    implements Runnable {
        EnableComponentThread() {
        }

        public void run() {
            StandardProgressControl.this.getControlComponent().setEnabled(StandardProgressControl.this.isOperational());
        }
    }
}

