/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

public final class ByteUtil {
    private ByteUtil() {
    }

    public static final int toInt16BE(byte[] src, int offset) {
        return ((src[offset] & 0xFF) << 8) + (src[++offset] & 0xFF);
    }

    public static final int toByte16BE(int value, byte[] dst, int offset) {
        dst[offset] = (byte)(value >> 8 & 0xFF);
        dst[++offset] = (byte)(value & 0xFF);
        return 2;
    }

    public static final int toIntBE(byte[] src, int offset) {
        return ((src[offset] & 0xFF) << 24) + ((src[++offset] & 0xFF) << 16) + ((src[++offset] & 0xFF) << 8) + (src[++offset] & 0xFF);
    }

    public static final int toFourCharBytes(String fourChars, byte[] dst, int offset) throws IllegalArgumentException {
        int length = fourChars.length();
        if (length > 4) {
            throw new IllegalArgumentException("Illegal fourChars length: " + length);
        }
        for (int i = 0; i < length; ++i) {
            dst[offset++] = (byte)(fourChars.charAt(i) & 0xFF);
        }
        return 4;
    }

    public static final int toFourCharCode(String fourChars) throws IllegalArgumentException {
        byte[] dst = new byte[4];
        ByteUtil.toFourCharBytes(fourChars, dst, 0);
        return ByteUtil.toIntBE(dst, 0);
    }

    public static final int toByteBE(int value, byte[] dst, int offset) {
        dst[offset] = (byte)(value >> 24 & 0xFF);
        dst[++offset] = (byte)(value >> 16 & 0xFF);
        dst[++offset] = (byte)(value >> 8 & 0xFF);
        dst[++offset] = (byte)(value & 0xFF);
        return 4;
    }

    public static final int toByte64BE(long value, byte[] dst, int offset) {
        dst[offset] = (byte)(value >> 56 & 0xFFL);
        dst[++offset] = (byte)(value >> 48 & 0xFFL);
        dst[++offset] = (byte)(value >> 40 & 0xFFL);
        dst[++offset] = (byte)(value >> 32 & 0xFFL);
        dst[++offset] = (byte)(value >> 24 & 0xFFL);
        dst[++offset] = (byte)(value >> 16 & 0xFFL);
        dst[++offset] = (byte)(value >> 8 & 0xFFL);
        dst[++offset] = (byte)(value & 0xFFL);
        return 8;
    }

    public static final long toLongBE(byte[] src, int offset) {
        return (((long)src[offset] & 0xFFL) << 56) + (((long)src[++offset] & 0xFFL) << 48) + (((long)src[++offset] & 0xFFL) << 40) + (((long)src[++offset] & 0xFFL) << 32) + (((long)src[++offset] & 0xFFL) << 24) + (((long)src[++offset] & 0xFFL) << 16) + (((long)src[++offset] & 0xFFL) << 8) + ((long)src[++offset] & 0xFFL);
    }
}

