/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.service.ErrorService;
import org.limewire.setting.RemoteSettingController;
import org.limewire.setting.RemoteSettingManager;

public class SimppSettingsManager
implements RemoteSettingManager {
    private static final Log LOG = LogFactory.getLog(SimppSettingsManager.class);
    private final Properties _simppProps = new Properties();
    private final Map<String, String> _remainderSimppSettings = new HashMap<String, String>();
    private volatile RemoteSettingController _remoteController;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSimppSettings(String simppSettings) {
        if (this._remoteController == null) {
            throw new IllegalStateException("No RemoteSettingController set!");
        }
        RemoteSettingController remoteSettingController = this._remoteController;
        synchronized (remoteSettingController) {
            byte[] settings = null;
            try {
                settings = simppSettings.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException uex) {
                ErrorService.error(uex);
                return;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(settings);
            this._simppProps.clear();
            try {
                this._simppProps.load(bais);
            }
            catch (IOException iox) {
                LOG.error("IOX reading simpp properties", iox);
                return;
            }
            this.activateSimppSettings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateSimppSettings() {
        LOG.debug("activating new settings");
        if (this._remoteController == null) {
            throw new IllegalStateException("No RemoteSettingController set!");
        }
        RemoteSettingController remoteSettingController = this._remoteController;
        synchronized (remoteSettingController) {
            for (Map.Entry<Object, Object> entry : this._simppProps.entrySet()) {
                String value;
                String key = (String)entry.getKey();
                if (this._remoteController.updateSetting(key, value = (String)entry.getValue())) continue;
                this._remainderSimppSettings.put(key, value);
            }
            Set<Object> keys = this._simppProps.keySet();
            this._remoteController.revertRemoteSettingsUnlessIn(keys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUnloadedValueFor(String simppKey) {
        RemoteSettingController remoteSettingController = this._remoteController;
        synchronized (remoteSettingController) {
            return this._remainderSimppSettings.remove(simppKey);
        }
    }

    @Override
    public void setRemoteSettingController(RemoteSettingController controller) {
        this._remoteController = controller;
    }
}

