/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.security;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.limegroup.gnutella.security.Certificate;
import com.limegroup.gnutella.security.CertificateParser;
import com.limegroup.gnutella.security.HttpCertificateReader;
import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;
import org.limewire.http.httpclient.HttpClientInstanceUtils;
import org.limewire.http.httpclient.LimeHttpClient;
import org.limewire.io.IpPort;

public class HttpCertificateReaderImpl
implements HttpCertificateReader {
    private final Provider<LimeHttpClient> httpClient;
    private final CertificateParser certificateParser;
    private final HttpClientInstanceUtils httpClientInstanceUtils;

    @Inject
    public HttpCertificateReaderImpl(Provider<LimeHttpClient> httpClient, CertificateParser certificateParser, HttpClientInstanceUtils httpClientInstanceUtils) {
        this.httpClient = httpClient;
        this.certificateParser = certificateParser;
        this.httpClientInstanceUtils = httpClientInstanceUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Certificate read(URI uri, IpPort messageSource) throws IOException {
        HttpGet get = new HttpGet(this.httpClientInstanceUtils.addClientInfoToUrl(uri.toASCIIString()));
        if (messageSource != null) {
            get.addHeader("X-Message-Source", messageSource.getAddress() + ":" + messageSource.getPort());
        }
        LimeHttpClient limeHttpClient = this.httpClient.get();
        HttpResponse response = null;
        try {
            response = limeHttpClient.execute(get);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("could not get content from: " + uri);
            }
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                throw new IOException("no entity from: " + uri);
            }
            String contents = EntityUtils.toString(entity);
            Certificate certificate = this.certificateParser.parseCertificate(contents);
            return certificate;
        }
        finally {
            limeHttpClient.releaseConnection(response);
        }
    }
}

