/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AdvancedStatsToggle;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVMImpl;
import com.limegroup.gnutella.messages.vendor.ContentRequest;
import com.limegroup.gnutella.messages.vendor.ContentResponse;
import com.limegroup.gnutella.messages.vendor.DHTContactsMessage;
import com.limegroup.gnutella.messages.vendor.HeadPing;
import com.limegroup.gnutella.messages.vendor.HeadPongFactory;
import com.limegroup.gnutella.messages.vendor.HeaderUpdateVendorMessage;
import com.limegroup.gnutella.messages.vendor.HopsFlowVendorMessage;
import com.limegroup.gnutella.messages.vendor.InspectionRequestImpl;
import com.limegroup.gnutella.messages.vendor.LimeACKVendorMessage;
import com.limegroup.gnutella.messages.vendor.MessagesSupportedVendorMessage;
import com.limegroup.gnutella.messages.vendor.OOBProxyControlVendorMessage;
import com.limegroup.gnutella.messages.vendor.PushProxyAcknowledgement;
import com.limegroup.gnutella.messages.vendor.PushProxyRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessageFactory;
import com.limegroup.gnutella.messages.vendor.SimppRequestVM;
import com.limegroup.gnutella.messages.vendor.SimppVM;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackRedirect;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackRedirect;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPing;
import com.limegroup.gnutella.messages.vendor.UpdateRequest;
import com.limegroup.gnutella.messages.vendor.UpdateResponse;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.messages.vendor.VendorMessageFactory;
import com.limegroup.gnutella.messages.vendor.VendorMessageParserBinder;
import org.limewire.security.MACCalculatorRepositoryManager;

@Singleton
public class VendorMessageParserBinderImpl
implements VendorMessageParserBinder {
    private final ReplyNumberVendorMessageFactory replyNumberVendorMessageFactory;
    private final HeadPongFactory headPongFactory;
    private final MACCalculatorRepositoryManager macManager;

    @Inject
    public VendorMessageParserBinderImpl(ReplyNumberVendorMessageFactory replyNumberVendorMessageFactory, HeadPongFactory headPongFactory, MACCalculatorRepositoryManager macManager) {
        this.replyNumberVendorMessageFactory = replyNumberVendorMessageFactory;
        this.headPongFactory = headPongFactory;
        this.macManager = macManager;
    }

    @Override
    public void bind(VendorMessageFactory vendorMessageFactory) {
        vendorMessageFactory.setParser(4, VendorMessage.F_BEAR_VENDOR_ID, new HopsFlowVendorMessageParser());
        vendorMessageFactory.setParser(11, VendorMessage.F_LIME_VENDOR_ID, new LimeACKVendorMessageParser());
        vendorMessageFactory.setParser(12, VendorMessage.F_LIME_VENDOR_ID, new ReplyNumberVendorMessageParser());
        vendorMessageFactory.setParser(7, VendorMessage.F_BEAR_VENDOR_ID, new TCPConnectBackVendorMessageParser());
        vendorMessageFactory.setParser(0, VendorMessage.F_NULL_VENDOR_ID, new MessagesSupportedVendorMessageParser());
        vendorMessageFactory.setParser(7, VendorMessage.F_GTKG_VENDOR_ID, new UDPConnectBackVendorMessageParser());
        vendorMessageFactory.setParser(21, VendorMessage.F_LIME_VENDOR_ID, new PushProxyRequestParser());
        vendorMessageFactory.setParser(22, VendorMessage.F_LIME_VENDOR_ID, new PushProxyAcknowledgementParser());
        vendorMessageFactory.setParser(11, VendorMessage.F_BEAR_VENDOR_ID, new QueryStatusRequestParser());
        vendorMessageFactory.setParser(12, VendorMessage.F_BEAR_VENDOR_ID, new QueryStatusResponseParser());
        vendorMessageFactory.setParser(7, VendorMessage.F_LIME_VENDOR_ID, new TCPConnectBackRedirectParser());
        vendorMessageFactory.setParser(8, VendorMessage.F_LIME_VENDOR_ID, new UDPConnectBackRedirectParser());
        vendorMessageFactory.setParser(10, VendorMessage.F_NULL_VENDOR_ID, new CapabilitiesVMParser());
        vendorMessageFactory.setParser(16, VendorMessage.F_LIME_VENDOR_ID, new SimppRequestVMParser());
        vendorMessageFactory.setParser(17, VendorMessage.F_LIME_VENDOR_ID, new SimppVMParser());
        vendorMessageFactory.setParser(5, VendorMessage.F_LIME_VENDOR_ID, new UDPCrawlerPingParser());
        vendorMessageFactory.setParser(23, VendorMessage.F_LIME_VENDOR_ID, new HeadPingParser());
        vendorMessageFactory.setParser(24, VendorMessage.F_LIME_VENDOR_ID, new HeadPongParser());
        vendorMessageFactory.setParser(26, VendorMessage.F_LIME_VENDOR_ID, new UpdateRequestParser());
        vendorMessageFactory.setParser(27, VendorMessage.F_LIME_VENDOR_ID, new UpdateResponseParser());
        vendorMessageFactory.setParser(28, VendorMessage.F_LIME_VENDOR_ID, new ContentRequestParser());
        vendorMessageFactory.setParser(29, VendorMessage.F_LIME_VENDOR_ID, new ContentResponseParser());
        vendorMessageFactory.setParser(25, VendorMessage.F_LIME_VENDOR_ID, new HeaderUpdateVendorMessageParser());
        vendorMessageFactory.setParser(13, VendorMessage.F_LIME_VENDOR_ID, new OOBProxyControlVendorMessageParser());
        vendorMessageFactory.setParser(30, VendorMessage.F_LIME_VENDOR_ID, new InspectionRequestVendorMessageParser());
        vendorMessageFactory.setParser(32, VendorMessage.F_LIME_VENDOR_ID, new AdvancedStatsToggleVendorMessageParser());
        vendorMessageFactory.setParser(33, VendorMessage.F_LIME_VENDOR_ID, new DHTContactsMessageParser(this.macManager));
    }

    private static class DHTContactsMessageParser
    implements VendorMessageFactory.VendorMessageParser {
        private final MACCalculatorRepositoryManager macManager;

        private DHTContactsMessageParser(MACCalculatorRepositoryManager macManager) {
            this.macManager = macManager;
        }

        @Override
        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, Message.Network network) throws BadPacketException {
            return new DHTContactsMessage(guid, ttl, hops, version, restOf, network, this.macManager);
        }
    }

    private static class AdvancedStatsToggleVendorMessageParser
    implements VendorMessageFactory.VendorMessageParser {
        private AdvancedStatsToggleVendorMessageParser() {
        }

        @Override
        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, Message.Network network) throws BadPacketException {
            return new AdvancedStatsToggle(guid, ttl, hops, version, restOf, network);
        }
    }

    private static class InspectionRequestVendorMessageParser
    implements VendorMessageFactory.VendorMessageParser {
        private InspectionRequestVendorMessageParser() {
        }

        @Override
        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, Message.Network network) throws BadPacketException {
            return new InspectionRequestImpl(guid, ttl, hops, version, restOf, network);
        }
    }

    private static class OOBProxyControlVendorMessageParser
    implements VendorMessageFactory.VendorMessageParser {
        private OOBProxyControlVendorMessageParser() {
        }

        @Override
        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, Message.Network network) throws BadPacketException {
            return new OOBProxyControlVendorMessage(guid, ttl, hops, version, restOf, network);
        }
    }

    private static class HeaderUpdateVendorMessageParser
    implements VendorMessageFactory.VendorMessageParser {
        private HeaderUpdateVendorMessageParser() {
        }

        @Override
        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, Message.Network network) throws BadPacketException {
            return new HeaderUpdateVendorMessage(guid, ttl, hops, version, restOf, network);
        }
    }

    private static class ContentResponseParser
    implements VendorMessageFactory.VendorMessageParser {
        private ContentResponseParser() {
        }

        @Override
        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, Message.Network network) throws BadPacketException {
            return new ContentResponse(guid, ttl, hops, version, restOf, network);
        }
    }

    private static class ContentRequestParser
    implements VendorMessageFactory.VendorMessageParser {
        private ContentRequestParser() {
        }

        @Override
        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, Message.Network network) throws BadPacketException {
            return new ContentRequest(guid, ttl, hops, version, restOf, network);
        }
    }

    private static class UpdateResponseParser
    implements VendorMessageFactory.VendorMessageParser {
        private UpdateResponseParser() {
        }

        @Override
        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, Message.Network network) throws BadPacketException {
            return new UpdateResponse(guid, ttl, hops, version, restOf, network);
        }
    }

    private static class UpdateRequestParser
    implements VendorMessageFactory.VendorMessageParser {
        private UpdateRequestParser() {
        }

        @Override
        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, Message.Network network) throws BadPacketException {
            return new UpdateRequest(guid, ttl, hops, version, restOf, network);
        }
    }

    private class HeadPongParser
    implements VendorMessageFactory.VendorMessageParser {
        private HeadPongParser() {
        }

        @Override
        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, Message.Network network) throws BadPacketException {
            return VendorMessageParserBinderImpl.this.headPongFactory.createFromNetwork(guid, ttl, hops, version, restOf, network);
        }
    }

    private static class HeadPingParser
    implements VendorMessageFactory.VendorMessageParser {
        private HeadPingParser() {
        }

        @Override
        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, Message.Network network) throws BadPacketException {
            return new HeadPing(guid, ttl, hops, version, restOf, network);
        }
    }

    private static class UDPCrawlerPingParser
    implements VendorMessageFactory.VendorMessageParser {
        private UDPCrawlerPingParser() {
        }

        @Override
        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, Message.Network network) throws BadPacketException {
            return new UDPCrawlerPing(guid, ttl, hops, version, restOf, network);
        }
    }

    private static class SimppVMParser
    implements VendorMessageFactory.VendorMessageParser {
        private SimppVMParser() {
        }

        @Override
        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, Message.Network network) throws BadPacketException {
            return new SimppVM(guid, ttl, hops, version, restOf, network);
        }
    }

    private static class SimppRequestVMParser
    implements VendorMessageFactory.VendorMessageParser {
        private SimppRequestVMParser() {
        }

        @Override
        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, Message.Network network) throws BadPacketException {
            return new SimppRequestVM(guid, ttl, hops, version, restOf, network);
        }
    }

    private static class CapabilitiesVMParser
    implements VendorMessageFactory.VendorMessageParser {
        private CapabilitiesVMParser() {
        }

        @Override
        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, Message.Network network) throws BadPacketException {
            return new CapabilitiesVMImpl(guid, ttl, hops, version, restOf, network);
        }
    }

    private static class UDPConnectBackRedirectParser
    implements VendorMessageFactory.VendorMessageParser {
        private UDPConnectBackRedirectParser() {
        }

        @Override
        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, Message.Network network) throws BadPacketException {
            return new UDPConnectBackRedirect(guid, ttl, hops, version, restOf, network);
        }
    }

    private static class TCPConnectBackRedirectParser
    implements VendorMessageFactory.VendorMessageParser {
        private TCPConnectBackRedirectParser() {
        }

        @Override
        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, Message.Network network) throws BadPacketException {
            return new TCPConnectBackRedirect(guid, ttl, hops, version, restOf, network);
        }
    }

    private static class QueryStatusResponseParser
    implements VendorMessageFactory.VendorMessageParser {
        private QueryStatusResponseParser() {
        }

        @Override
        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, Message.Network network) throws BadPacketException {
            return new QueryStatusResponse(guid, ttl, hops, version, restOf, network);
        }
    }

    private static class QueryStatusRequestParser
    implements VendorMessageFactory.VendorMessageParser {
        private QueryStatusRequestParser() {
        }

        @Override
        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, Message.Network network) throws BadPacketException {
            return new QueryStatusRequest(guid, ttl, hops, version, restOf, network);
        }
    }

    private static class PushProxyAcknowledgementParser
    implements VendorMessageFactory.VendorMessageParser {
        private PushProxyAcknowledgementParser() {
        }

        @Override
        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, Message.Network network) throws BadPacketException {
            return new PushProxyAcknowledgement(guid, ttl, hops, version, restOf, network);
        }
    }

    private static class PushProxyRequestParser
    implements VendorMessageFactory.VendorMessageParser {
        private PushProxyRequestParser() {
        }

        @Override
        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, Message.Network network) throws BadPacketException {
            return new PushProxyRequest(guid, ttl, hops, version, restOf, network);
        }
    }

    private static class UDPConnectBackVendorMessageParser
    implements VendorMessageFactory.VendorMessageParser {
        private UDPConnectBackVendorMessageParser() {
        }

        @Override
        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, Message.Network network) throws BadPacketException {
            return new UDPConnectBackVendorMessage(guid, ttl, hops, version, restOf, network);
        }
    }

    private static class MessagesSupportedVendorMessageParser
    implements VendorMessageFactory.VendorMessageParser {
        private MessagesSupportedVendorMessageParser() {
        }

        @Override
        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, Message.Network network) throws BadPacketException {
            return new MessagesSupportedVendorMessage(guid, ttl, hops, version, restOf, network);
        }
    }

    private static class TCPConnectBackVendorMessageParser
    implements VendorMessageFactory.VendorMessageParser {
        private TCPConnectBackVendorMessageParser() {
        }

        @Override
        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, Message.Network network) throws BadPacketException {
            return new TCPConnectBackVendorMessage(guid, ttl, hops, version, restOf, network);
        }
    }

    private class ReplyNumberVendorMessageParser
    implements VendorMessageFactory.VendorMessageParser {
        private ReplyNumberVendorMessageParser() {
        }

        @Override
        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, Message.Network network) throws BadPacketException {
            return VendorMessageParserBinderImpl.this.replyNumberVendorMessageFactory.createFromNetwork(guid, ttl, hops, version, restOf, network);
        }
    }

    private static class LimeACKVendorMessageParser
    implements VendorMessageFactory.VendorMessageParser {
        private LimeACKVendorMessageParser() {
        }

        @Override
        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, Message.Network network) throws BadPacketException {
            return new LimeACKVendorMessage(guid, ttl, hops, version, restOf, network);
        }
    }

    private static class HopsFlowVendorMessageParser
    implements VendorMessageFactory.VendorMessageParser {
        private HopsFlowVendorMessageParser() {
        }

        @Override
        public VendorMessage parse(byte[] guid, byte ttl, byte hops, int version, byte[] restOf, Message.Network network) throws BadPacketException {
            return new HopsFlowVendorMessage(guid, ttl, hops, version, restOf, network);
        }
    }
}

