/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEPParser;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.SecureGGEPData;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.security.Signature;
import java.security.SignatureException;
import org.limewire.io.BadGGEPPropertyException;
import org.limewire.io.GGEP;
import org.limewire.io.InvalidDataException;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkUtils;
import org.limewire.security.SecureMessage;
import org.limewire.service.ErrorService;

public class RoutableGGEPMessage
extends AbstractVendorMessage
implements SecureMessage,
VendorMessage.ControlMessage {
    static final String RETURN_ADDRESS_KEY = "RA";
    static final String VERSION_KEY = "V";
    static final String TO_ADDRESS_KEY = "TO";
    private SecureMessage.Status _secureStatus = SecureMessage.Status.INSECURE;
    protected final GGEP ggep;
    private final SecureGGEPData secureData;
    private final IpPort returnAddress;
    private final IpPort destAddress;
    private final long routableVersion;

    protected RoutableGGEPMessage(byte[] guid, byte ttl, byte hops, byte[] vendor, int selector, int version, byte[] payload, Message.Network network) throws BadPacketException {
        super(guid, ttl, hops, vendor, selector, version, payload, network);
        long routableVersion;
        GGEPParser parser = new GGEPParser();
        parser.scanForGGEPs(payload, 0);
        GGEP ggep = parser.getSecureGGEP();
        if (ggep == null) {
            throw new BadPacketException("no secure ggep");
        }
        this.secureData = new SecureGGEPData(parser);
        ggep = parser.getNormalGGEP();
        if (ggep == null) {
            throw new BadPacketException("no normal ggep");
        }
        this.ggep = ggep;
        try {
            routableVersion = ggep.getLong(VERSION_KEY);
        }
        catch (BadGGEPPropertyException bad) {
            routableVersion = -1L;
        }
        this.routableVersion = routableVersion;
        IpPort retAddr = null;
        try {
            byte[] returnAddress = ggep.get(RETURN_ADDRESS_KEY);
            if (returnAddress != null) {
                retAddr = NetworkUtils.getIpPort(returnAddress, ByteOrder.LITTLE_ENDIAN);
            }
        }
        catch (InvalidDataException bleh) {
            // empty catch block
        }
        this.returnAddress = retAddr;
        IpPort destAddr = null;
        try {
            byte[] destAddress = ggep.get(TO_ADDRESS_KEY);
            if (destAddress != null) {
                destAddr = NetworkUtils.getIpPort(destAddress, ByteOrder.LITTLE_ENDIAN);
            }
        }
        catch (InvalidDataException bleh) {
            // empty catch block
        }
        this.destAddress = destAddr;
    }

    protected RoutableGGEPMessage(byte[] vendor, int selector, int version, GGEPSigner signer, GGEP ggep) {
        super(vendor, selector, version, RoutableGGEPMessage.derivePayload(signer, ggep));
        this.ggep = ggep;
        this.returnAddress = null;
        this.destAddress = null;
        this.routableVersion = -1L;
        this.secureData = null;
    }

    private static byte[] derivePayload(GGEPSigner signer, GGEP ggep) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ggep.write(baos);
            signer.getSecureGGEP(ggep).write(baos);
        }
        catch (IOException impossible) {
            ErrorService.error(impossible);
        }
        return baos.toByteArray();
    }

    public IpPort getReturnAddress() {
        return this.returnAddress;
    }

    public IpPort getDestinationAddress() {
        return this.destAddress;
    }

    public long getRoutableVersion() {
        return this.routableVersion;
    }

    @Override
    public byte[] getSecureSignature() {
        SecureGGEPData sg = this.secureData;
        if (sg != null) {
            try {
                return sg.getGGEP().getBytes("SIG");
            }
            catch (BadGGEPPropertyException bgpe) {
                return null;
            }
        }
        return null;
    }

    @Override
    public SecureMessage.Status getSecureStatus() {
        return this._secureStatus;
    }

    @Override
    public void setSecureStatus(SecureMessage.Status secureStatus) {
        this._secureStatus = secureStatus;
    }

    @Override
    public void updateSignatureWithSecuredBytes(Signature signature) throws SignatureException {
        SecureGGEPData sg = this.secureData;
        if (sg != null) {
            signature.update(this.getPayload(), 0, sg.getStartIndex());
            int end = sg.getEndIndex();
            int length = this.getPayload().length - end;
            signature.update(this.getPayload(), end, length);
        }
    }

    public static interface GGEPSigner {
        public GGEP getSecureGGEP(GGEP var1);
    }
}

