/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.messages.OutgoingQueryReplyFactory;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryReplyFactory;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.xml.LimeXMLDocumentHelper;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.limewire.core.api.network.BandwidthCollector;
import org.limewire.core.settings.UploadSettings;
import org.limewire.io.Connectable;
import org.limewire.io.NetworkUtils;
import org.limewire.security.SecurityToken;

@Singleton
public class OutgoingQueryReplyFactoryImpl
implements OutgoingQueryReplyFactory {
    private final QueryReplyFactory queryReplyFactory;
    private final UploadManager uploadManager;
    private final NetworkManager networkManager;
    private final ApplicationServices applicationServices;
    private final ConnectionManager connectionManager;
    private final BandwidthCollector bandwidthCollector;

    @Inject
    public OutgoingQueryReplyFactoryImpl(QueryReplyFactory queryReplyFactory, UploadManager uploadManager, NetworkManager networkManager, ApplicationServices applicationServices, ConnectionManager connectionManager, BandwidthCollector bandwidthCollector) {
        this.queryReplyFactory = queryReplyFactory;
        this.uploadManager = uploadManager;
        this.networkManager = networkManager;
        this.applicationServices = applicationServices;
        this.connectionManager = connectionManager;
        this.bandwidthCollector = bandwidthCollector;
    }

    @Override
    public List<QueryReply> createReplies(Response[] responses, QueryRequest queryRequest, SecurityToken securityToken, int responsesPerReply) {
        boolean isMulticast = queryRequest.isMulticast() && queryRequest.getTTL() + queryRequest.getHops() == 1;
        byte ttl = isMulticast ? (byte)1 : (byte)(queryRequest.getHops() + 1);
        return this.createReplies(responses, responsesPerReply, securityToken, queryRequest.getGUID(), ttl, isMulticast, queryRequest.canDoFirewalledTransfer());
    }

    @Override
    public List<QueryReply> createReplies(Response[] responses, int responsesPerReply, SecurityToken securityToken, byte[] guid, byte ttl, boolean isMulticast, boolean requestorCanDoFWT) {
        List<Response[]> splitResponses = OutgoingQueryReplyFactoryImpl.splitResponses(responses, responsesPerReply);
        ArrayList<QueryReply> replies = new ArrayList<QueryReply>();
        for (Response[] bundle : splitResponses) {
            replies.addAll(this.createReplies(bundle, securityToken, guid, ttl, isMulticast, requestorCanDoFWT));
        }
        return replies;
    }

    static List<Response[]> splitResponses(Response[] responses, int responsesPerReply) {
        if (responses.length <= responsesPerReply) {
            return Collections.singletonList(responses);
        }
        ArrayList<Response[]> results = new ArrayList<Response[]>();
        for (int i = 0; i < responses.length; i += responsesPerReply) {
            Response[] copy = new Response[Math.min(responsesPerReply, responses.length - i)];
            System.arraycopy(responses, i, copy, 0, copy.length);
            results.add(copy);
        }
        return results;
    }

    public List<QueryReply> createReplies(Response[] responses, SecurityToken securityToken, byte[] guid, byte ttl, boolean isMulticast, boolean requestorCanDoFWT) {
        Set<Connectable> proxies;
        String xmlCollectionString;
        if (responses.length == 0) {
            return Collections.emptyList();
        }
        boolean isFWTransfer = requestorCanDoFWT && this.networkManager.canDoFWT() && !this.networkManager.acceptedIncomingConnection();
        boolean isBusy = !this.uploadManager.mayBeServiceable();
        boolean hasUploaded = this.uploadManager.hadSuccesfulUpload();
        byte[] clientGUID = this.applicationServices.getMyGUID();
        long speed = this.uploadManager.measuredUploadSpeed();
        boolean measuredSpeed = true;
        if (speed == -1L) {
            speed = this.bandwidthCollector.getMaxMeasuredTotalUploadBandwidth() * 8;
            if (speed <= 0L) {
                speed = 350L;
            }
            measuredSpeed = false;
        }
        int maxUploadSpeed = UploadSettings.MAX_UPLOAD_SPEED.getValue() / 1024 * 8;
        if (UploadSettings.LIMIT_MAX_UPLOAD_SPEED.getValue() && speed > (long)maxUploadSpeed) {
            speed = maxUploadSpeed;
        }
        ArrayList<QueryReply> queryReplies = new ArrayList<QueryReply>();
        QueryReply queryReply = null;
        int port = -1;
        byte[] ip = null;
        if (isMulticast) {
            ip = this.networkManager.getNonForcedAddress();
            port = this.networkManager.getNonForcedPort();
            if (!NetworkUtils.isValidPort(port) || !NetworkUtils.isValidAddress(ip)) {
                isMulticast = false;
            }
        }
        if (!isMulticast) {
            if (isFWTransfer) {
                port = this.networkManager.getStableUDPPort();
                ip = this.networkManager.getExternalAddress();
                if (!NetworkUtils.isValidAddress(ip) || !NetworkUtils.isValidPort(port)) {
                    isFWTransfer = false;
                }
            }
            if (!isFWTransfer) {
                ip = this.networkManager.getAddress();
                port = this.networkManager.getPort();
                if (!NetworkUtils.isValidAddress(ip) || !NetworkUtils.isValidPort(port)) {
                    return Collections.emptyList();
                }
            }
        }
        if ((xmlCollectionString = LimeXMLDocumentHelper.getAggregateString(responses)) == null) {
            xmlCollectionString = "";
        }
        byte[] xmlBytes = null;
        try {
            xmlBytes = xmlCollectionString.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ueex) {
            throw new IllegalStateException(ueex);
        }
        boolean notIncoming = !this.networkManager.acceptedIncomingConnection();
        Set<Connectable> set = proxies = notIncoming ? this.connectionManager.getPushProxies() : null;
        if (xmlBytes.length > 32768) {
            LinkedList<Response[]> splitResps = new LinkedList<Response[]>();
            OutgoingQueryReplyFactoryImpl.splitAndAddResponses(splitResps, responses);
            while (!splitResps.isEmpty()) {
                Response[] currResps = (Response[])splitResps.remove(0);
                String currXML = LimeXMLDocumentHelper.getAggregateString(currResps);
                byte[] currXMLBytes = null;
                try {
                    currXMLBytes = currXML.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException ueex) {
                    throw new IllegalStateException(ueex);
                }
                if (currXMLBytes.length > 32768 && currResps.length > 1) {
                    OutgoingQueryReplyFactoryImpl.splitAndAddResponses(splitResps, currResps);
                    continue;
                }
                byte[] xmlCompressed = null;
                xmlCompressed = !currXML.equals("") ? LimeXMLUtils.compress(currXMLBytes) : DataUtils.EMPTY_BYTE_ARRAY;
                queryReply = this.queryReplyFactory.createQueryReply(guid, ttl, port, ip, speed, currResps, clientGUID, xmlCompressed, notIncoming, isBusy, hasUploaded, measuredSpeed, false, isMulticast, isFWTransfer, proxies, securityToken);
                queryReplies.add(queryReply);
            }
        } else {
            byte[] xmlCompressed = null;
            xmlCompressed = !xmlCollectionString.equals("") ? LimeXMLUtils.compress(xmlBytes) : DataUtils.EMPTY_BYTE_ARRAY;
            queryReply = this.queryReplyFactory.createQueryReply(guid, ttl, port, ip, speed, responses, clientGUID, xmlCompressed, notIncoming, isBusy, hasUploaded, measuredSpeed, false, isMulticast, isFWTransfer, proxies, securityToken);
            queryReplies.add(queryReply);
        }
        return queryReplies;
    }

    private static Response[][] splitResponses(Response[] in) {
        int i;
        int middle = in.length / 2;
        Response[][] retResps = new Response[][]{new Response[middle], new Response[in.length - middle]};
        for (i = 0; i < middle; ++i) {
            retResps[0][i] = in[i];
        }
        for (i = 0; i < in.length - middle; ++i) {
            retResps[1][i] = in[i + middle];
        }
        return retResps;
    }

    private static void splitAndAddResponses(List<Response[]> addTo, Response[] toSplit) {
        Response[][] splits = OutgoingQueryReplyFactoryImpl.splitResponses(toSplit);
        addTo.add(splits[0]);
        addTo.add(splits[1]);
    }
}

