/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.malware;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.malware.InvalidLibraryException;
import com.limegroup.gnutella.malware.NFOFile;
import com.limegroup.gnutella.malware.VirusDefinitionDownloadMemento;
import com.limegroup.gnutella.malware.VirusDefinitionDownloader;
import com.limegroup.gnutella.malware.VirusDefinitionHandler;
import com.limegroup.gnutella.malware.VirusDefinitionManager;
import com.limegroup.gnutella.malware.VirusDefinitionVersionEvent;
import com.limegroup.gnutella.malware.VirusScanException;
import com.limegroup.gnutella.malware.VirusScanner;
import com.limegroup.gnutella.malware.VirusUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.limewire.activation.api.ActivationID;
import org.limewire.activation.api.ActivationItem;
import org.limewire.activation.api.ActivationManager;
import org.limewire.activation.api.ActivationModuleEvent;
import org.limewire.core.api.malware.AntivirusUpdateType;
import org.limewire.core.api.malware.VirusUpdatesURL;
import org.limewire.core.settings.MalwareSettings;
import org.limewire.inject.EagerSingleton;
import org.limewire.io.Expand;
import org.limewire.io.InvalidDataException;
import org.limewire.lifecycle.Asynchronous;
import org.limewire.lifecycle.Join;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;

@EagerSingleton
class VirusDefinitionManagerImpl
implements VirusDefinitionManager,
Service {
    private static final Log LOG = LogFactory.getLog(VirusDefinitionManagerImpl.class);
    private static final int MAX_RETRIES = 2;
    private final File mementoFile = new File(CommonUtils.getUserSettingsDir(), "vdef.dat");
    private final File mementoBackupFile = new File(CommonUtils.getUserHomeDir(), "vdef.bak");
    private final Provider<VirusDefinitionDownloader> downloaderFactory;
    private final Provider<VirusScanner> virusScannerProvider;
    private final Provider<String> updatesURL;
    private final ScheduledExecutorService backgroundExecutor;
    private final EventListenerList<VirusDefinitionVersionEvent> listeners;
    private final AtomicBoolean checking;
    private final AtomicBoolean scheduledFutureDefinitionCheck;
    private int retries = 0;

    @Inject
    VirusDefinitionManagerImpl(Provider<VirusDefinitionDownloader> downloader, Provider<VirusScanner> virusScanner, @VirusUpdatesURL Provider<String> updatesURL, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor) {
        LOG.debug("Creating VirusDefinitionManagerImpl");
        this.downloaderFactory = downloader;
        this.virusScannerProvider = virusScanner;
        this.updatesURL = updatesURL;
        this.backgroundExecutor = backgroundExecutor;
        this.listeners = new EventListenerList();
        this.checking = new AtomicBoolean(false);
        this.scheduledFutureDefinitionCheck = new AtomicBoolean(false);
    }

    @Inject
    void register(ServiceRegistry registry, ActivationManager activationManager) {
        registry.register(this);
        activationManager.addModuleListener(new EventListener<ActivationModuleEvent>(){

            @Override
            public void handleEvent(ActivationModuleEvent event) {
                if (event.getData() == ActivationID.AVG_MODULE && event.getStatus() == ActivationItem.Status.ACTIVE) {
                    VirusDefinitionManagerImpl.this.backgroundExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            VirusDefinitionManagerImpl.this.checkForDefinitions();
                            VirusDefinitionManagerImpl.this.scheduleNextCheck();
                        }
                    });
                }
            }
        });
    }

    @Override
    public String getServiceName() {
        return "Virus Definition Service";
    }

    @Override
    public void initialize() {
        this.scheduleNextCheck();
    }

    @Override
    @Asynchronous(join=Join.NONE)
    public void start() {
        LOG.debug("Starting Virus Definition Checking..");
        if (this.isScanningAllowed()) {
            LOG.debug("Virus scanner is supported!");
            VirusDefinitionDownloadMemento memento = this.loadMemento();
            if (memento != null) {
                LOG.debug("Continuing from memento...");
                try {
                    this.startMementoDownload(memento);
                }
                catch (InvalidDataException ide) {
                    this.eraseMementos(memento);
                    LOG.debug("Invalid memento, starting full check", ide);
                    this.checkForDefinitions();
                }
            } else {
                this.checkForDefinitions();
            }
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public void addListener(EventListener<VirusDefinitionVersionEvent> listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public boolean removeListener(EventListener<VirusDefinitionVersionEvent> listener) {
        return this.listeners.removeListener(listener);
    }

    private boolean isScanningAllowed() {
        if (!this.virusScannerProvider.get().isEnabled() || !this.virusScannerProvider.get().isSupported()) {
            LOG.debug("Not supported");
            return false;
        }
        if (!MalwareSettings.CHECK_FOR_VIRUS_DEFINITION_UPDATES.getValue()) {
            LOG.debug("Checking for virus definition updates is disabled");
            return false;
        }
        return true;
    }

    VirusDefinitionDownloadMemento loadMemento() {
        if (!this.mementoFile.exists()) {
            LOG.debug("No memento file exists, unable to load a memento");
            return null;
        }
        try {
            Object read = FileUtils.readObject(this.mementoFile);
            if (read instanceof VirusDefinitionDownloadMemento) {
                VirusDefinitionDownloadMemento memento = (VirusDefinitionDownloadMemento)read;
                LOG.debugf("Loaded memento file {0}", (Object)memento);
                if (memento.getAntivirusUpdateType() == AntivirusUpdateType.FULL && memento.getIncompleteFile() != null && memento.getIncompleteFile().exists() && memento.getUri() != null) {
                    return memento;
                }
                this.eraseMementos(memento);
                return null;
            }
        }
        catch (Throwable t) {
            LOG.error("Error reading memento file", t);
        }
        this.eraseMementos(null);
        return null;
    }

    private void eraseMementos(VirusDefinitionDownloadMemento memento) {
        if (memento != null && memento.getIncompleteFile() != null) {
            memento.getIncompleteFile().delete();
        }
        this.mementoFile.delete();
        this.mementoBackupFile.delete();
    }

    private void downloadsFinished() {
        this.eraseMementos(null);
        this.checking.set(false);
    }

    @Override
    public void checkForDefinitions() {
        if (this.checking.getAndSet(true)) {
            LOG.debug("Already checking, can't check definitions");
            return;
        }
        if (!this.isScanningAllowed()) {
            LOG.debug("Won't check for definitions since scanning is not allowed");
            return;
        }
        this.fetchNfo();
    }

    private void startMementoDownload(VirusDefinitionDownloadMemento memento) throws InvalidDataException {
        if (this.checking.getAndSet(true)) {
            LOG.debug("Already checking, can't restart from memento");
            return;
        }
        assert (memento.getAntivirusUpdateType() == AntivirusUpdateType.FULL);
        VirusDefinitionDownloader downloader = this.downloaderFactory.get();
        try {
            downloader.initFromMemento(memento);
        }
        catch (Throwable t) {
            throw new InvalidDataException("Invalid memento!", t);
        }
        downloader.setAttribute("antivirus_update_type", (Object)AntivirusUpdateType.FULL, false);
        downloader.fetch(new UpdateHandler(), this.mementoFile, this.mementoBackupFile);
    }

    private void doUpdates(NFOFile file) {
        NFOFile.Entry latestFullUpdate;
        ArrayList<NFOFile.Entry> updatesToInstall = new ArrayList<NFOFile.Entry>();
        int version = this.virusScannerProvider.get().getDefinitionsVersion();
        for (NFOFile.Entry entry : file.getIncrementalEntries()) {
            if (entry.getVersion() == version + 1) {
                ++version;
                updatesToInstall.add(entry);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Scheduling incremental update " + version);
                continue;
            }
            if (entry.getVersion() <= version + 1 || !LOG.isDebugEnabled()) continue;
            LOG.debug("Non-contiguous update " + entry.getVersion());
        }
        if ((updatesToInstall.isEmpty() || updatesToInstall.size() > MalwareSettings.MAXIMUM_INCREMENTAL_UPDATES.getValue()) && !file.getFullEntries().isEmpty() && (latestFullUpdate = file.getFullEntries().last()).getVersion() > this.virusScannerProvider.get().getDefinitionsVersion()) {
            if (LOG.isDebugEnabled() && updatesToInstall.size() > MalwareSettings.MAXIMUM_INCREMENTAL_UPDATES.getValue()) {
                LOG.debug("Preferring full update over " + updatesToInstall.size() + " incremental updates (Maximum incrementals=" + MalwareSettings.MAXIMUM_INCREMENTAL_UPDATES.getValue() + ")");
            }
            updatesToInstall.clear();
            updatesToInstall.add(latestFullUpdate);
            version = latestFullUpdate.getVersion();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduling full update " + version);
            }
        }
        if (updatesToInstall.isEmpty()) {
            LOG.debug("Virus definitions are up to date");
            this.listeners.broadcast(new VirusDefinitionVersionEvent(version));
            this.downloadsFinished();
            return;
        }
        UpdatesScheduler scheduler = new UpdatesScheduler(updatesToInstall);
        scheduler.start();
    }

    private void fetchNfo() {
        try {
            URI nfo = new URI(this.updatesURL.get() + "current.nfo");
            VirusDefinitionDownloader downloader = this.downloaderFactory.get();
            downloader.setUriAndName(nfo, "current.nfo");
            downloader.setAttribute("antivirus_update_type", (Object)AntivirusUpdateType.CHECKING, false);
            downloader.fetch(new NFOHandler(), null, null);
        }
        catch (URISyntaxException e) {
            LOG.debug("Invalid URI for current.nfo", e);
            this.scheduleNextCheck();
        }
    }

    private boolean isUpdateCompatibleWithLibrary(File updateDir) throws InvalidLibraryException, IOException {
        long libraryV;
        try {
            libraryV = this.virusScannerProvider.get().getLibraryBuildVersion();
        }
        catch (IOException iox) {
            throw new InvalidLibraryException(iox);
        }
        File nfo = new File(updateDir, "version.nfo");
        String required = VirusUtils.getNfoValue(nfo, "REQUIRED_BIN_RELEASE_VERSION");
        long reqV = this.parseVersion(required);
        LOG.debugf("Library version: {0}, required version string: {1}, required version: {2}", (Object)libraryV, (Object)required, (Object)reqV);
        return libraryV > reqV;
    }

    private long parseVersion(String version) throws IOException {
        int idx = version.lastIndexOf(".");
        if (idx + 1 < version.length()) {
            try {
                return Long.parseLong(version.substring(idx + 1));
            }
            catch (NumberFormatException nfe) {
                throw new IOException("Invalid version: " + version, nfe);
            }
        }
        throw new IOException("Invalid version: " + version);
    }

    private void scheduleNextCheck() {
        if (this.scheduledFutureDefinitionCheck.getAndSet(true)) {
            LOG.debug("Already scheduled future definition check. Ignoring scheduling request.");
            return;
        }
        if (this.isScanningAllowed()) {
            Runnable check = new Runnable(){

                @Override
                public void run() {
                    if (VirusDefinitionManagerImpl.this.isScanningAllowed()) {
                        LOG.debug("Scheduled check running");
                        VirusDefinitionManagerImpl.this.scheduleNextCheck();
                        VirusDefinitionManagerImpl.this.fetchNfo();
                    } else {
                        LOG.debug("Scheduled check cancelled");
                    }
                }
            };
            LOG.debug("Scheduling next check in 24 hours");
            this.backgroundExecutor.schedule(check, 24L, TimeUnit.HOURS);
        }
    }

    private void considerRetrying() {
        if (this.virusScannerProvider.get().getDefinitionsVersion() == 0 && this.retries++ < 2) {
            LOG.debug("Retrying");
            this.eraseMementos(null);
            this.fetchNfo();
        } else {
            if (LOG.isDebugEnabled()) {
                if (this.retries - 1 >= 2) {
                    LOG.debug("Not retrying, max retries exceeded");
                } else {
                    LOG.debug("Not retrying, VDB version > 0");
                }
            }
            this.retries = 0;
            this.downloadsFinished();
        }
    }

    File getMementoFile() {
        return this.mementoFile;
    }

    class NFOHandler
    implements VirusDefinitionHandler {
        NFOHandler() {
        }

        @Override
        public void downloadSucceeded(File nfo) {
            try {
                NFOFile nfoFile = new NFOFile(nfo);
                VirusDefinitionManagerImpl.this.doUpdates(nfoFile);
            }
            catch (FileNotFoundException e) {
                LOG.debugf(e, "Unable to load file {0}", nfo);
                VirusDefinitionManagerImpl.this.considerRetrying();
            }
        }

        @Override
        public void downloadFailed(File incomplete) {
            LOG.debug("Unable to download nfo file");
            VirusDefinitionManagerImpl.this.considerRetrying();
        }
    }

    private class UpdateHandler
    implements VirusDefinitionHandler {
        private final UpdatesScheduler scheduler;
        private AntivirusUpdateType currentUpdateType;

        private UpdateHandler() {
            this.currentUpdateType = AntivirusUpdateType.FULL;
            this.scheduler = null;
        }

        private UpdateHandler(UpdatesScheduler scheduler) {
            this.scheduler = scheduler;
        }

        private void setCurrentUpdateType(AntivirusUpdateType type) {
            this.currentUpdateType = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void downloadSucceeded(File defs) {
            File temp = VirusUtils.getTemporaryDirectory();
            FileUtils.forceDeleteRecursive(temp);
            temp.mkdirs();
            temp.mkdir();
            try {
                Expand.expandFile(defs, temp, true);
                String name = FileUtils.getFilenameNoExtension(defs.getName());
                File updateDir = new File(temp, name);
                if (!updateDir.exists()) {
                    throw new IOException("Unexpected zip format");
                }
                if (!VirusDefinitionManagerImpl.this.isUpdateCompatibleWithLibrary(updateDir)) {
                    MalwareSettings.CHECK_FOR_VIRUS_DEFINITION_UPDATES.set(false);
                    throw new IOException("Update is not compatible with library");
                }
                switch (this.currentUpdateType) {
                    case INCREMENTAL: {
                        ((VirusScanner)VirusDefinitionManagerImpl.this.virusScannerProvider.get()).loadIncrementalUpdate(updateDir);
                        break;
                    }
                    case FULL: {
                        ((VirusScanner)VirusDefinitionManagerImpl.this.virusScannerProvider.get()).loadFullUpdate(updateDir);
                    }
                }
                int version = ((VirusScanner)VirusDefinitionManagerImpl.this.virusScannerProvider.get()).getDefinitionsVersion();
                VirusDefinitionManagerImpl.this.listeners.broadcast(new VirusDefinitionVersionEvent(version));
                if (this.scheduler != null) {
                    this.scheduler.notifyUpdateComplete();
                } else {
                    VirusDefinitionManagerImpl.this.fetchNfo();
                }
            }
            catch (InvalidLibraryException e) {
                LOG.debug("The library is invalid and cannot be loaded, aborting", e);
                VirusDefinitionManagerImpl.this.retries = 0;
                VirusDefinitionManagerImpl.this.downloadsFinished();
            }
            catch (IOException e) {
                LOG.debug("Error expanding or loading update", e);
                VirusDefinitionManagerImpl.this.considerRetrying();
            }
            catch (VirusScanException e) {
                LOG.debug("Error loading update", e);
                FileUtils.forceDeleteRecursive(VirusUtils.getDatabaseDirectory());
                VirusDefinitionManagerImpl.this.listeners.broadcast(new VirusDefinitionVersionEvent(0));
                VirusDefinitionManagerImpl.this.considerRetrying();
            }
            finally {
                FileUtils.forceDeleteRecursive(temp);
            }
        }

        @Override
        public void downloadFailed(File incomplete) {
            LOG.debug("Unable to download update");
            VirusDefinitionManagerImpl.this.considerRetrying();
        }
    }

    private class UpdatesScheduler {
        private final List<NFOFile.Entry> entries;
        private final int totalIncrementalUpdates;
        private final UpdateHandler handler;

        public UpdatesScheduler(List<NFOFile.Entry> entries) {
            this.entries = entries;
            this.totalIncrementalUpdates = entries.isEmpty() || entries.get(0).getType() == AntivirusUpdateType.FULL ? 0 : entries.size();
            this.handler = new UpdateHandler(this);
        }

        private void start() {
            this.processNextEntry();
        }

        private void notifyUpdateComplete() {
            this.processNextEntry();
        }

        private void processNextEntry() {
            if (this.entries.size() > 0) {
                try {
                    NFOFile.Entry entry = this.entries.remove(0);
                    this.download(entry);
                }
                catch (URISyntaxException e) {
                    LOG.debug("Invalid update URI", e);
                }
            } else {
                VirusDefinitionManagerImpl.this.downloadsFinished();
            }
        }

        private void download(NFOFile.Entry entry) throws URISyntaxException {
            URI updateURI = new URI((String)VirusDefinitionManagerImpl.this.updatesURL.get() + entry.getPath());
            VirusDefinitionDownloader downloader = (VirusDefinitionDownloader)VirusDefinitionManagerImpl.this.downloaderFactory.get();
            downloader.setUriAndName(updateURI, entry.getPath());
            this.handler.setCurrentUpdateType(entry.getType());
            downloader.setAttribute("antivirus_update_type", (Object)entry.getType(), false);
            if (entry.getType() == AntivirusUpdateType.INCREMENTAL) {
                downloader.setAttribute("antivirus_increment_count", this.totalIncrementalUpdates, false);
                downloader.setAttribute("antivirus_increment_index", this.totalIncrementalUpdates - this.entries.size(), false);
                downloader.fetch(this.handler, null, null);
            } else {
                downloader.fetch(this.handler, VirusDefinitionManagerImpl.this.mementoFile, VirusDefinitionManagerImpl.this.mementoBackupFile);
            }
        }
    }
}

