/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.limegroup.gnutella.http.HTTPHeaderValue;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public enum HTTPHeaderName {
    ALT_LOCATION("X-Alt"),
    FALT_LOCATION("X-Falt"),
    BFALT_LOCATION("X-NFalt"),
    OLD_ALT_LOCS("X-Gnutella-Alternate-Location"),
    NALTS("X-NAlt"),
    GNUTELLA_CONTENT_URN("X-Gnutella-Content-URN"),
    CONTENT_URN("X-Content-URN"),
    CONTENT_RANGE("Content-Range"),
    CONTENT_TYPE("Content-Type"),
    CONTENT_LENGTH("Content-Length"),
    ACCEPT("Accept"),
    ACCEPT_ENCODING("Accept-Encoding"),
    CONTENT_ENCODING("Content-Encoding"),
    SERVER("Server"),
    CONNECTION("Connection"),
    THEX_URI("X-Thex-URI"),
    DATE("Date"),
    AVAILABLE_RANGES("X-Available-Ranges"),
    QUEUE("X-Queue"),
    RETRY_AFTER("Retry-After"),
    CREATION_TIME("X-Create-Time"),
    FEATURES("X-Features"),
    PROXIES("X-Push-Proxy"),
    NODE("X-Node"),
    DOWNLOADED("X-Downloaded"),
    CONTENT_DISPOSITION("Content-Disposition"),
    HOST("Host"),
    USER_AGENT("User-Agent"),
    RANGE("Range"),
    CHAT("Chat"),
    FWTPORT("X-FWTP"),
    TRANSFER_ENCODING("Transfer-Encoding"),
    FW_NODE_INFO("X-FW-Node-Info"),
    NMS1("X-NMS1");

    private final String NAME;
    private final String LOWER_CASE_NAME;

    private HTTPHeaderName(String name) {
        this.NAME = name;
        this.LOWER_CASE_NAME = name.toLowerCase(Locale.US);
    }

    public boolean is(String str) {
        return str.toLowerCase(Locale.US).equals(this.LOWER_CASE_NAME);
    }

    public boolean matchesStartOfString(String str) {
        return str.toLowerCase(Locale.US).startsWith(this.LOWER_CASE_NAME);
    }

    public String httpStringValue() {
        return this.NAME;
    }

    public String toString() {
        return this.NAME;
    }

    public boolean matches(Header header) {
        return header.getName().equalsIgnoreCase(this.NAME);
    }

    public Header create(String value) {
        return new BasicHeader(this.httpStringValue(), value);
    }

    public Header create(HTTPHeaderValue value) {
        return new BasicHeader(this.httpStringValue(), value.httpStringValue());
    }
}

