/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.tigertree.HashTree;

public class ConnectionStatus {
    private final StatusType STATUS;
    private final int QUEUE_POSITION;
    private final int QUEUE_POLL_TIME;
    private final HashTree HASH_TREE;
    private final int CODE;
    private static final ConnectionStatus NO_FILE = new ConnectionStatus(StatusType.NO_FILE);
    private static final ConnectionStatus CONNECTED = new ConnectionStatus(StatusType.CONNECTED);
    private static final ConnectionStatus NO_DATA = new ConnectionStatus(StatusType.NO_DATA);
    private static final ConnectionStatus PARTIAL_DATA = new ConnectionStatus(StatusType.PARTIAL_DATA);

    private ConnectionStatus(StatusType status) {
        if (status == StatusType.QUEUED || status == StatusType.THEX_RESPONSE) {
            throw new IllegalArgumentException();
        }
        this.STATUS = status;
        this.QUEUE_POSITION = -1;
        this.QUEUE_POLL_TIME = -1;
        this.CODE = -1;
        this.HASH_TREE = null;
    }

    private ConnectionStatus(StatusType status, int queuePos, int queuePoll) {
        if (status != StatusType.QUEUED) {
            throw new IllegalArgumentException();
        }
        this.STATUS = status;
        this.QUEUE_POSITION = queuePos;
        this.QUEUE_POLL_TIME = queuePoll;
        this.CODE = -1;
        this.HASH_TREE = null;
    }

    private ConnectionStatus(StatusType status, HashTree tree) {
        if (status != StatusType.THEX_RESPONSE) {
            throw new IllegalArgumentException();
        }
        if (tree == null) {
            throw new NullPointerException("null tree");
        }
        this.STATUS = status;
        this.HASH_TREE = tree;
        this.CODE = -1;
        this.QUEUE_POSITION = -1;
        this.QUEUE_POLL_TIME = -1;
    }

    static ConnectionStatus getNoFile() {
        return NO_FILE;
    }

    static ConnectionStatus getConnected() {
        return CONNECTED;
    }

    static ConnectionStatus getNoData() {
        return NO_DATA;
    }

    static ConnectionStatus getPartialData() {
        return PARTIAL_DATA;
    }

    static ConnectionStatus getQueued(int pos, int poll) {
        poll *= 1000;
        return new ConnectionStatus(StatusType.QUEUED, pos, poll += 1000);
    }

    static ConnectionStatus getThexResponse(HashTree tree) {
        return new ConnectionStatus(StatusType.THEX_RESPONSE, tree);
    }

    StatusType getType() {
        return this.STATUS;
    }

    boolean isNoFile() {
        return this.STATUS == StatusType.NO_FILE;
    }

    public boolean isConnected() {
        return this.STATUS == StatusType.CONNECTED;
    }

    boolean isNoData() {
        return this.STATUS == StatusType.NO_DATA;
    }

    boolean isPartialData() {
        return this.STATUS == StatusType.PARTIAL_DATA;
    }

    boolean isQueued() {
        return this.STATUS == StatusType.QUEUED;
    }

    public boolean isThexResponse() {
        return this.STATUS == StatusType.THEX_RESPONSE;
    }

    int getQueuePosition() {
        if (!this.isQueued()) {
            throw new IllegalStateException();
        }
        return this.QUEUE_POSITION;
    }

    int getQueuePollTime() {
        if (!this.isQueued()) {
            throw new IllegalStateException();
        }
        return this.QUEUE_POLL_TIME;
    }

    public HashTree getHashTree() {
        if (!this.isThexResponse()) {
            throw new IllegalStateException();
        }
        return this.HASH_TREE;
    }

    public int getCode() {
        return this.CODE;
    }

    public String toString() {
        return this.STATUS.toString();
    }

    static enum StatusType {
        NO_FILE,
        QUEUED,
        CONNECTED,
        NO_DATA,
        PARTIAL_DATA,
        THEX_RESPONSE;

    }
}

