/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.ResponseFactory;
import com.limegroup.gnutella.ResponseImpl;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.library.CreationTimeCache;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.IncompleteFileDesc;
import com.limegroup.gnutella.messages.HUGEExtension;
import com.limegroup.gnutella.messages.IntervalEncoder;
import com.limegroup.gnutella.uploader.HTTPHeaderUtils;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import org.limewire.collection.BitNumbers;
import org.limewire.collection.IntervalSet;
import org.limewire.core.settings.FilterSettings;
import org.limewire.core.settings.MessageSettings;
import org.limewire.io.BadGGEPPropertyException;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.GGEP;
import org.limewire.io.InvalidDataException;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteUtils;
import org.limewire.util.NameValue;
import org.limewire.util.StringUtils;

@Singleton
public class ResponseFactoryImpl
implements ResponseFactory {
    private static final Log LOG = LogFactory.getLog(ResponseFactoryImpl.class);
    private static final byte EXT_SEPARATOR = 28;
    private static final String KBPS = "kbps";
    private static final String KHZ = "kHz";
    private final AltLocManager altLocManager;
    private final Provider<CreationTimeCache> creationTimeCache;
    private final IPFilter ipFilter;
    private final NetworkInstanceUtils networkInstanceUtils;
    private final LimeXMLDocumentFactory limeXMLDocumentFactory;

    @Inject
    public ResponseFactoryImpl(AltLocManager altLocManager, Provider<CreationTimeCache> creationTimeCache, IPFilter ipFilter, LimeXMLDocumentFactory limeXMLDocumentFactory, NetworkInstanceUtils networkInstanceUtils) {
        this.altLocManager = altLocManager;
        this.creationTimeCache = creationTimeCache;
        this.ipFilter = ipFilter;
        this.limeXMLDocumentFactory = limeXMLDocumentFactory;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public Response createResponse(long index, long size, String name, URN urn) {
        return this.createResponse(index, size, name, -1, new UrnSet(urn), null, null, null);
    }

    @Override
    public Response createResponse(long index, long size, String name, LimeXMLDocument doc, URN urn) {
        return this.createResponse(index, size, name, -1, new UrnSet(urn), doc, null, null);
    }

    @Override
    public Response createResponse(FileDesc fileDesc) {
        return this.createResponse(fileDesc, false);
    }

    @Override
    public Response createResponse(FileDesc fd, boolean includeNMS1Urn) {
        IntervalSet ranges = null;
        boolean verified = false;
        if (fd instanceof IncompleteFileDesc) {
            IncompleteFileDesc ifd = (IncompleteFileDesc)fd;
            ranges = new IntervalSet();
            verified = ifd.loadResponseRanges(ranges);
        }
        GGEPContainer container = new GGEPContainer(this.getAsIpPorts(this.altLocManager.getDirect(fd.getSHA1Urn())), this.creationTimeCache.get().getCreationTimeAsLong(fd.getSHA1Urn()), fd.getFileSize(), ranges, verified, fd.getTTROOTUrn(), includeNMS1Urn ? fd.getNMS1Urn() : null);
        LimeXMLDocument doc = this.getLimeXmlDoc(fd);
        Response response = this.createResponse(fd.getIndex(), fd.getFileSize(), fd.getFileName(), -1, fd.getUrns(), doc, container, null);
        return response;
    }

    private LimeXMLDocument getLimeXmlDoc(FileDesc fileDesc) {
        List<LimeXMLDocument> docs = fileDesc.getLimeXMLDocuments();
        if (docs.size() == 1) {
            return docs.get(0);
        }
        return null;
    }

    @Override
    public Response createFromStream(InputStream is) throws IOException {
        String next;
        int c;
        long index = ByteUtils.uint2long(ByteUtils.leb2int(is));
        long size = ByteUtils.uint2long(ByteUtils.leb2int(is));
        if ((index & 0xFFFFFFFF00000000L) != 0L) {
            throw new IOException("invalid index: " + index);
        }
        if (size < 0L) {
            throw new IOException("invalid size: " + size);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((c = is.read()) != 0) {
            if (c == -1) {
                throw new IOException("EOF before null termination");
            }
            baos.write(c);
        }
        int incomingNameByteArraySize = baos.size();
        String name = new String(baos.toByteArray(), "UTF-8");
        this.checkFilename(name);
        baos.reset();
        while ((c = is.read()) != 0) {
            if (c == -1) {
                throw new IOException("EOF before null termination");
            }
            baos.write(c);
        }
        byte[] rawMeta = baos.toByteArray();
        if (rawMeta.length == 0) {
            if (is.available() < 16) {
                throw new IOException("not enough room for the GUID");
            }
            return this.createResponse(index, size, name, incomingNameByteArraySize, null, null, null, null);
        }
        HUGEExtension huge = new HUGEExtension(rawMeta);
        Set<URN> urns = huge.getURNS();
        LimeXMLDocument doc = null;
        Iterator<String> i$ = huge.getMiscBlocks().iterator();
        while (i$.hasNext() && (doc = this.createXmlDocument(name, next = i$.next())) == null) {
        }
        GGEPContainer ggep = this.getGGEP(huge.getGGEP(), size);
        if (ggep.size64 > 0xFFFFFFFFFFL) {
            throw new IOException(" file too large " + ggep.size64);
        }
        if (ggep.size64 > Integer.MAX_VALUE) {
            size = ggep.size64;
        }
        urns = ResponseFactoryImpl.updateUrns(urns, ggep.nms1Urn);
        return this.createResponse(index, size, name, incomingNameByteArraySize, urns, doc, ggep, rawMeta);
    }

    static Set<URN> updateUrns(Set<URN> urns, URN nms1Urn) {
        if (nms1Urn == null) {
            return urns;
        }
        if (!(urns instanceof UrnSet)) {
            urns = new UrnSet(urns);
        }
        urns.add((URN)nms1Urn);
        return urns;
    }

    public Response createResponse(long index, long size, String name, int incomingNameByteArraySize, Set<? extends URN> urns, LimeXMLDocument doc, GGEPContainer ggepData, byte[] extensions) {
        if (ggepData == null) {
            ggepData = size <= Integer.MAX_VALUE ? GGEPContainer.EMPTY : new GGEPContainer(null, -1L, size, null, false, null, null);
        }
        if (extensions == null) {
            extensions = this.createExtBytes(urns, ggepData, size);
        }
        return new ResponseImpl(index, size, name, incomingNameByteArraySize, urns, doc, ggepData.locations, ggepData.createTime, extensions, ggepData.ranges, ggepData.verified);
    }

    private void checkFilename(String name) throws IOException {
        if (name.length() == 0) {
            throw new IOException("empty name in response");
        }
        if (name.indexOf(47) != -1 || name.indexOf(10) != -1 || name.indexOf(13) != -1) {
            throw new IOException("Illegal filename " + name + "contains one of [/\\n\\r]");
        }
    }

    private LimeXMLDocument createXmlDocument(String name, String ext) {
        StringTokenizer tok = new StringTokenizer(ext);
        if (tok.countTokens() < 2) {
            return null;
        }
        String first = tok.nextToken();
        String second = tok.nextToken();
        assert (first != null);
        assert (second != null);
        first = first.toLowerCase(Locale.US);
        second = second.toLowerCase(Locale.US);
        String length = "";
        String bitrate = "";
        boolean bearShare1 = false;
        boolean bearShare2 = false;
        boolean gnotella = false;
        if (second.startsWith(KBPS)) {
            bearShare1 = true;
        } else if (first.endsWith(KBPS)) {
            bearShare2 = true;
        }
        if (bearShare1) {
            bitrate = first;
        } else if (bearShare2) {
            int j = first.indexOf(KBPS);
            bitrate = first.substring(0, j);
        }
        if (bearShare1 || bearShare2) {
            while (tok.hasMoreTokens()) {
                length = tok.nextToken();
            }
        } else if (ext.endsWith(KHZ)) {
            gnotella = true;
            length = first;
            int i = second.indexOf(KBPS);
            if (i > -1) {
                bitrate = second.substring(0, i);
            } else {
                gnotella = false;
            }
        }
        try {
            Integer.parseInt(bitrate);
            Integer.parseInt(length);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        if (bearShare1 || bearShare2 || gnotella) {
            ArrayList<NameValue<String>> values = new ArrayList<NameValue<String>>(3);
            values.add(new NameValue<String>("audios__audio__title__", name));
            values.add(new NameValue<String>("audios__audio__bitrate__", bitrate));
            values.add(new NameValue<String>("audios__audio__seconds__", length));
            return this.limeXMLDocumentFactory.createLimeXMLDocument(values, "http://www.limewire.com/schemas/audio.xsd");
        }
        return null;
    }

    private byte[] createExtBytes(Set<? extends URN> urns, GGEPContainer ggep, long size) {
        try {
            if (this.isEmpty(urns) && ggep.isEmpty()) {
                return DataUtils.EMPTY_BYTE_ARRAY;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (!this.isEmpty(urns)) {
                Iterator<? extends URN> iter = urns.iterator();
                while (iter.hasNext()) {
                    URN urn = iter.next();
                    assert (urn != null) : "Null URN";
                    if (!urn.isSHA1() && MessageSettings.TTROOT_IN_GGEP.getValue() || urn.isNMS1()) continue;
                    baos.write(StringUtils.toAsciiBytes(urn.toString()));
                    if (!iter.hasNext()) continue;
                    baos.write(28);
                }
                if (!ggep.isEmpty()) {
                    baos.write(28);
                }
            }
            if (!ggep.isEmpty()) {
                this.addGGEP(baos, ggep, size);
            }
            return baos.toByteArray();
        }
        catch (IOException impossible) {
            ErrorService.error(impossible);
            return DataUtils.EMPTY_BYTE_ARRAY;
        }
    }

    private boolean isEmpty(Set<?> set) {
        return set == null || set.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<? extends IpPort> getAsIpPorts(AlternateLocationCollection<DirectAltLoc> col) {
        if (!col.hasAlternateLocations()) {
            return Collections.emptySet();
        }
        long now = System.currentTimeMillis();
        AlternateLocationCollection<DirectAltLoc> alternateLocationCollection = col;
        synchronized (alternateLocationCollection) {
            Set endpoints = null;
            int i = 0;
            int maxLocations = Math.min(10, FilterSettings.MAX_ALTS_PER_RESPONSE.getValue() - 1);
            Iterator<DirectAltLoc> iter = col.iterator();
            while (iter.hasNext() && i < maxLocations) {
                DirectAltLoc al = iter.next();
                if (al.canBeSent(2)) {
                    IpPort host = al.getHost();
                    if (this.networkInstanceUtils.isMe(host)) continue;
                    if (endpoints == null) {
                        endpoints = new IpPortSet();
                    }
                    endpoints.add(host);
                    ++i;
                    al.send(now, 2);
                    continue;
                }
                if (al.canBeSentAny()) continue;
                iter.remove();
            }
            if (endpoints == null) {
                return Collections.emptySet();
            }
            return endpoints;
        }
    }

    private void addGGEP(OutputStream out, GGEPContainer ggep, long size) throws IOException {
        if (ggep == null || ggep.locations.size() == 0 && ggep.createTime <= 0L && ggep.size64 <= Integer.MAX_VALUE && ggep.ranges == null && ggep.ttroot == null && ggep.nms1Urn == null) {
            throw new IllegalArgumentException("null or empty locations and small size");
        }
        GGEP info = new GGEP(true);
        if (ggep.locations.size() > 0) {
            byte[] output = NetworkUtils.packIpPorts(ggep.locations);
            info.put("ALT", output);
            BitNumbers bn = HTTPHeaderUtils.getTLSIndices(ggep.locations);
            if (!bn.isEmpty()) {
                info.put("ALT_TLS", bn.toByteArray());
            }
        }
        if (ggep.createTime > 0L) {
            info.put("CT", ggep.createTime / 1000L);
        }
        if (ggep.size64 > Integer.MAX_VALUE && ggep.size64 <= 0xFFFFFFFFFFL) {
            info.put("LF", ggep.size64);
        }
        if (ggep.ranges != null) {
            IntervalEncoder.encode(size, info, ggep.ranges);
            if (!ggep.verified) {
                info.put("PRU");
            }
        }
        if (ggep.ttroot != null && MessageSettings.TTROOT_IN_GGEP.getValue()) {
            info.put("TT", ggep.ttroot.getBytes());
        }
        if (ggep.nms1Urn != null) {
            info.put("NM", ggep.nms1Urn.getBytes());
        }
        info.write(out);
    }

    GGEPContainer getGGEP(GGEP ggep, long size) {
        if (ggep == null) {
            return GGEPContainer.EMPTY;
        }
        Set<? extends IpPort> locations = null;
        long createTime = -1L;
        long size64 = size;
        URN ttroot = null;
        URN nms1Urn = null;
        if (ggep.hasValueFor("ALT")) {
            byte[] tlsData = null;
            if (ggep.hasValueFor("ALT_TLS")) {
                try {
                    tlsData = ggep.getBytes("ALT_TLS");
                }
                catch (BadGGEPPropertyException ignored) {
                    // empty catch block
                }
            }
            BitNumbers bn = tlsData == null ? null : new BitNumbers(tlsData);
            try {
                locations = this.parseLocations(bn, ggep.getBytes("ALT"));
            }
            catch (BadGGEPPropertyException bad) {
                // empty catch block
            }
        }
        if (ggep.hasValueFor("CT")) {
            try {
                createTime = ggep.getLong("CT") * 1000L;
            }
            catch (BadGGEPPropertyException bad) {
                // empty catch block
            }
        }
        if (ggep.hasValueFor("LF")) {
            try {
                size64 = ggep.getLong("LF");
            }
            catch (BadGGEPPropertyException bad) {
                // empty catch block
            }
        }
        if (ggep.hasValueFor("TT")) {
            try {
                byte[] tt = ggep.get("TT");
                ttroot = URN.createTTRootFromBytes(tt);
            }
            catch (IOException bad) {
                // empty catch block
            }
        }
        if (ggep.hasValueFor("NM")) {
            try {
                byte[] nms1 = ggep.get("NM");
                nms1Urn = URN.createNMS1FromBytes(nms1);
            }
            catch (IOException ie) {
                LOG.debug("invalid non-metadata urn", ie);
            }
        }
        boolean verified = false;
        IntervalSet ranges = null;
        try {
            ranges = IntervalEncoder.decode(size64, ggep);
            verified = !ggep.hasKey("PRU");
        }
        catch (BadGGEPPropertyException ignore) {
            // empty catch block
        }
        if (locations == null && createTime == -1L && size64 <= Integer.MAX_VALUE && ranges == null && ttroot == null && nms1Urn == null) {
            return GGEPContainer.EMPTY;
        }
        return new GGEPContainer(locations, createTime, size64, ranges, verified, ttroot, nms1Urn);
    }

    private Set<? extends IpPort> parseLocations(BitNumbers tlsHosts, byte[] data) {
        IpPortSet locations = null;
        if (data.length % 6 != 0) {
            return null;
        }
        int size = data.length / 6;
        byte[] current = new byte[6];
        for (int i = 0; i < size; ++i) {
            IpPort ipp;
            System.arraycopy(data, i * 6, current, 0, 6);
            try {
                ipp = NetworkUtils.getIpPort(current, ByteOrder.LITTLE_ENDIAN);
            }
            catch (InvalidDataException ide) {
                tlsHosts = null;
                continue;
            }
            if (!this.ipFilter.allow(ipp.getAddress()) || this.networkInstanceUtils.isMe(ipp)) continue;
            if (locations == null) {
                locations = new IpPortSet();
            }
            if (tlsHosts != null && tlsHosts.isSet(i)) {
                ipp = new ConnectableImpl(ipp, true);
            }
            locations.add(ipp);
        }
        return locations;
    }

    static final class GGEPContainer {
        final Set<? extends IpPort> locations;
        final long createTime;
        final long size64;
        static final GGEPContainer EMPTY = new GGEPContainer();
        final IntervalSet ranges;
        final boolean verified;
        final URN ttroot;
        private final URN nms1Urn;

        private GGEPContainer() {
            this(null, -1L, 0L, null, false, null, null);
        }

        GGEPContainer(Set<? extends IpPort> locs, long create, long size64, IntervalSet ranges, boolean verified, URN ttroot, URN nms1Urn) {
            this.nms1Urn = nms1Urn;
            this.locations = locs == null ? Collections.emptySet() : Collections.unmodifiableSet(locs);
            this.createTime = create;
            this.size64 = size64;
            this.ranges = ranges;
            this.verified = verified;
            this.ttroot = ttroot;
            assert (ttroot == null || ttroot.isTTRoot());
            assert (nms1Urn == null || nms1Urn.isNMS1());
        }

        boolean isEmpty() {
            return this.locations.isEmpty() && this.createTime <= 0L && this.size64 <= Integer.MAX_VALUE && this.ranges == null && (this.ttroot == null || !MessageSettings.TTROOT_IN_GGEP.getValue()) && this.nms1Urn == null;
        }
    }
}

