/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import org.limewire.bittorrent.Torrent;
import org.limewire.bittorrent.TorrentInfo;
import org.limewire.bittorrent.TorrentPieceState;
import org.limewire.bittorrent.TorrentPiecesInfo;
import org.limewire.core.api.download.DownloadPiecesInfo;

class BTDownloadPiecesInfo
implements DownloadPiecesInfo {
    private final TorrentPiecesInfo piecesInfo;
    private final Torrent torrent;

    BTDownloadPiecesInfo(Torrent torrent) {
        this.torrent = torrent;
        this.piecesInfo = torrent.getPiecesInfo();
    }

    @Override
    public DownloadPiecesInfo.PieceState getPieceState(int piece) {
        return BTDownloadPiecesInfo.convertPieceState(this.piecesInfo.getPieceState(piece));
    }

    @Override
    public int getNumPieces() {
        return this.piecesInfo.getNumPieces();
    }

    @Override
    public long getPieceSize() {
        TorrentInfo info = this.torrent.getTorrentInfo();
        if (info == null) {
            return -1L;
        }
        return this.torrent.getTorrentInfo().getPieceLength();
    }

    @Override
    public int getNumPiecesCompleted() {
        return this.piecesInfo.getNumPiecesCompleted();
    }

    private static DownloadPiecesInfo.PieceState convertPieceState(TorrentPieceState state) {
        switch (state) {
            case ACTIVE: {
                return DownloadPiecesInfo.PieceState.ACTIVE;
            }
            case DOWNLOADED: {
                return DownloadPiecesInfo.PieceState.DOWNLOADED;
            }
            case PARTIAL: {
                return DownloadPiecesInfo.PieceState.PARTIAL;
            }
            case AVAILABLE: {
                return DownloadPiecesInfo.PieceState.AVAILABLE;
            }
            case UNAVAILABLE: {
                return DownloadPiecesInfo.PieceState.UNAVAILABLE;
            }
        }
        throw new IllegalArgumentException("Unknown TorrentPieceState: " + (Object)((Object)state));
    }
}

