/*==============================================================================

FICHIER     : [dvdtools.h]

DATE        : 2005/12/0001 22:05:05

CREATEUR    : [Linux!jef]

COMMENTAIRE :

================================================================================

==============================================================================*/

#ifndef __DVDTOOLS_H__
#define __DVDTOOLS_H__

#	include <stdint.h>
#	include <dvdread/dvd_reader.h>
#	include <dvdread/ifo_read.h>
#	include <dvdread/ifo_print.h>
#	include <dvdread/nav_read.h>

#define 	stAudio		0
#define		stVideo		1
#define		stSubpicture	2
#define 	stOther		3

#define MAX_PGCS	100
typedef struct {
	int vts;
	ifo_handle_t *	ifo;
	vtsi_mat_t *	vtsi_mat;
	pgcit_t *	vts_pgcit;
	int		nrPgc;
	pgc_t *		pgcs[MAX_PGCS];
	unsigned long	duree;
	int		sectors;
	int		nrSubp;
} Piste_t;


/*@$#[dvdtools.c] global proto. AutoProtoSigV1.1. date: 2009/06/03 22:23:29 */
#include "proto.h"
#ifdef __cplusplus
extern "C" {
#endif
void CreateDummyNavPack(unsigned char *buffer, unsigned int sector);
int VerifNavPack(unsigned char *p);
int MilliSeconde(dvd_time_t *dt);
int isNavPack(unsigned char *_ptr);
int IdentifyStream(unsigned char *buffer, int *packetType);
int GetStreamID(int type);
pgc_t *GetPgc(int noPisteVideo);
char *BuildChapitreString(int noPisteVideo);
void SavePalette(int noPisteVideo, char *pFile);
char *AudioLang(int noPisteVideo, int noPisteAudio);
char *SubLang(int noPisteVideo, int noSubtitle);
char *AudioFormat(int noPisteVideo, int noPisteAudio);
int AudioStreamId(int noPisteVideo, int noPisteAudio);
int MyDVDRead1Block(dvd_file_t *dvdFile, int noSect, void *buffer);
Piste_t *GetPiste(int noPisteVideo);
void RazPistes(void);
void CreateDummyPack(unsigned char *buffer);
#ifdef __cplusplus
}
#endif
/*@$% end of AutoProtoSigV1.1 (Dont remove this line) []*/
#endif	/* __DVDTOOLS_H__ */

