/* -*- mode: C++; tab-width: 4; c-basic-offset: 4; -*- */

/* AbiSource
 * 
 * Copyright (C) 2007 Philippe Milot <PhilMilot@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#ifndef _OXMLI_TYPES_H_
#define _OXMLI_TYPES_H_

// Internal includes
#include <OXML_Element.h>
#include <OXML_Section.h>

// External includes
#include <stack>
#include <vector>

typedef std::stack<OXML_SharedElement> OXMLi_ElementStack;
typedef std::stack<OXML_SharedSection> OXMLi_SectionStack;
typedef std::vector<std::string> OXMLi_ContextVector;

struct OXMLi_StartElementRequest
{
	std::string pName;
	std::map<std::string, std::string>* ppAtts;
	OXMLi_ElementStack * stck;
	OXMLi_SectionStack * sect_stck;	
	OXMLi_ContextVector * context;
	bool handled;
	bool valid;
};

struct OXMLi_EndElementRequest
{
	std::string pName;
	OXMLi_ElementStack * stck;
	OXMLi_SectionStack * sect_stck;	
	OXMLi_ContextVector * context;
	bool handled;
	bool valid;
};

struct OXMLi_CharDataRequest
{
	const gchar * buffer;
	int length;
	OXMLi_ElementStack * stck;
	OXMLi_ContextVector * context;
	bool handled;
	bool valid;
};

enum OXMLi_Keyword
{
	KEYWORD_abstractNum,
	KEYWORD_abstractNumId,
	KEYWORD_active,
	KEYWORD_activeRecord,
	KEYWORD_addressFieldName,
	KEYWORD_adjustRightInd,
	KEYWORD_alias,
	KEYWORD_aliases,
	KEYWORD_altName,
	KEYWORD_annotationRef,
	KEYWORD_attr,
	KEYWORD_autoRedefine,
	KEYWORD_autoSpaceDE,
	KEYWORD_autoSpaceDN,
	KEYWORD_b,
	KEYWORD_background, 
	KEYWORD_bar,
	KEYWORD_basedOn,
	KEYWORD_bCs,
	KEYWORD_bdr,
	KEYWORD_behavior,
	KEYWORD_behaviors,
	KEYWORD_between,
	KEYWORD_bibliography,
	KEYWORD_bidi,
	KEYWORD_bidiVisual,
	KEYWORD_body,
	KEYWORD_bookmarkEnd,
	KEYWORD_bookmarkStart,
	KEYWORD_bottom,
	KEYWORD_break,
	KEYWORD_calcOnExit,
	KEYWORD_calendar,
	KEYWORD_cantSplit,
	KEYWORD_caps,
	KEYWORD_category,
	KEYWORD_cellDel,
	KEYWORD_cellIns,
	KEYWORD_cellMerge,
	KEYWORD_charset,
	KEYWORD_checkBox,
	KEYWORD_checked,
	KEYWORD_checkErrors,
	KEYWORD_citation,
	KEYWORD_cnfStyle,
	KEYWORD_col,
	KEYWORD_colDelim,
	KEYWORD_cols,
	KEYWORD_color,
	KEYWORD_column,
	KEYWORD_comboBox,
	KEYWORD_comment,
	KEYWORD_commentRangeEnd,
	KEYWORD_commentRangeStart,
	KEYWORD_commentReference,
	KEYWORD_comments,
	KEYWORD_connectString,
	KEYWORD_contextualSpacing,
	KEYWORD_continuationSeparator,
	KEYWORD_control,
	KEYWORD_cr,
	KEYWORD_cs,
	KEYWORD_customXml,
	KEYWORD_customXmlDelRangeEnd,
	KEYWORD_customXmlDelRangeStart,
	KEYWORD_customXmlInsRangeEnd,
	KEYWORD_customXmlInsRangeStart,
	KEYWORD_customXmlMoveFromRangeEnd,
	KEYWORD_customXmlMoveFromRangeStart,
	KEYWORD_customXmlMoveToRangeEnd,
	KEYWORD_customXmlMoveToRangeStart,
	KEYWORD_customXmlPr,
	KEYWORD_dataBinding,
	KEYWORD_dataSource,
	KEYWORD_dataType,
	KEYWORD_date,
	KEYWORD_dateFormat,
	KEYWORD_dayLong,
	KEYWORD_dayShort,
	KEYWORD_ddList,
	KEYWORD_default,
	KEYWORD_del,
	KEYWORD_delInstrText,
	KEYWORD_delText,
	KEYWORD_description,
	KEYWORD_destination,
	KEYWORD_dirty,
	KEYWORD_divId,
	KEYWORD_docDefaults,
	KEYWORD_docGrid,
	KEYWORD_docPart,
	KEYWORD_docPartBody,
	KEYWORD_docPartCategory,
	KEYWORD_docPartGallery,
	KEYWORD_docPartList,
	KEYWORD_docPartObj,
	KEYWORD_docPartPr,
	KEYWORD_docParts,
	KEYWORD_docPartUnique,
	KEYWORD_document, 
	KEYWORD_doNotSuppressBlankLines,
	KEYWORD_drawing,
	KEYWORD_dropDownList,
	KEYWORD_dstrike,
	KEYWORD_dynamicAddress,
	KEYWORD_eastAsianLayout,
	KEYWORD_effect,
	KEYWORD_equation,
	KEYWORD_em,
	KEYWORD_embedBold,
	KEYWORD_embedBoldItalic,
	KEYWORD_embedItalic,
	KEYWORD_embedRegular,
	KEYWORD_embedSystemFonts,
	KEYWORD_embedTrueTypeFonts,
	KEYWORD_emboss,
	KEYWORD_enabled,
	KEYWORD_endnote,
	KEYWORD_endnotePr,
	KEYWORD_endnoteRef,
	KEYWORD_endnoteReference,
	KEYWORD_endnotes,
	KEYWORD_entryMacro,
	KEYWORD_evenAndOddHeaders,
	KEYWORD_exitMacro,
	KEYWORD_family,
	KEYWORD_ffData,
	KEYWORD_fHdr,
	KEYWORD_fieldMapData,
	KEYWORD_fitText,
	KEYWORD_fldChar,
	KEYWORD_fldData,
	KEYWORD_fldSimple,
	KEYWORD_font,
	KEYWORD_fonts,
	KEYWORD_footerReference,
	KEYWORD_footnote,
	KEYWORD_footnotePr,
	KEYWORD_footnoteRef,
	KEYWORD_footnoteReference,
	KEYWORD_footnotes,
	KEYWORD_format,
	KEYWORD_formProt,
	KEYWORD_framePr,
	KEYWORD_ftr,
	KEYWORD_gallery,
	KEYWORD_glossaryDocument,
	KEYWORD_gridAfter,
	KEYWORD_gridBefore,
	KEYWORD_gridCol,
	KEYWORD_gridSpan,
	KEYWORD_group,
	KEYWORD_guid,
	KEYWORD_hdr,
	KEYWORD_headerReference,
	KEYWORD_headerSource,
	KEYWORD_helpText,
	KEYWORD_hidden,
	KEYWORD_hideMark,
	KEYWORD_highlight,
	KEYWORD_hMerge,
	KEYWORD_hps,
	KEYWORD_hpsBaseText,
	KEYWORD_hpsRaise,
	KEYWORD_hyperlink,
	KEYWORD_i,
	KEYWORD_iCs,
	KEYWORD_id,
	KEYWORD_ilvl,
	KEYWORD_imprint,
	KEYWORD_ind,
	KEYWORD_ins,
	KEYWORD_insideH,
	KEYWORD_insideV,
	KEYWORD_instrText,
	KEYWORD_isLgl,
	KEYWORD_jc,
	KEYWORD_keepLines,
	KEYWORD_keepNext,
	KEYWORD_kern,
	KEYWORD_kinsoku,
	KEYWORD_lang,
	KEYWORD_lastRenderedPageBreak,
	KEYWORD_latentStyles,
	KEYWORD_left,
	KEYWORD_legacy,
	KEYWORD_lid,
	KEYWORD_link,
	KEYWORD_linkToQuery,
	KEYWORD_listEntry,
	KEYWORD_listItem,
	KEYWORD_lock,
	KEYWORD_locked,
	KEYWORD_lnNumType,
	KEYWORD_lsdException,
	KEYWORD_lvl,
	KEYWORD_lvlJc,
	KEYWORD_lvlOverride,
	KEYWORD_lvlPicBulletId,
	KEYWORD_lvlRestart,
	KEYWORD_lvlText,
	KEYWORD_mailAsAttachment,
	KEYWORD_mailMerge,
	KEYWORD_mailSubject,
	KEYWORD_mainDocumentType,
	KEYWORD_mappedName,
	KEYWORD_maxLength,
	KEYWORD_mirrorIndents,
	KEYWORD_monthLong,
	KEYWORD_monthShort,
	KEYWORD_moveFrom,
	KEYWORD_moveFromRangeEnd,
	KEYWORD_moveFromRangeStart,
	KEYWORD_moveTo,
	KEYWORD_moveToRangeEnd,
	KEYWORD_moveToRangeStart,
	KEYWORD_movie,
	KEYWORD_multiLevelType,
	KEYWORD_name,
	KEYWORD_next,
	KEYWORD_noBreakHyphen,
	KEYWORD_noEndnote,
	KEYWORD_noProof,
	KEYWORD_notTrueType,
	KEYWORD_noWrap,
	KEYWORD_nsid,
	KEYWORD_num,
	KEYWORD_numbering,
	KEYWORD_numberingChange,
	KEYWORD_numFmt,
	KEYWORD_numId,
	KEYWORD_numIdMacAtCleanup,
	KEYWORD_numPicBullet,
	KEYWORD_numPr,
	KEYWORD_numRestart,
	KEYWORD_numStart,
	KEYWORD_numStyleLink,
	KEYWORD_object,
	KEYWORD_odso,
	KEYWORD_oMath,
	KEYWORD_outline,
	KEYWORD_outlineLvl,
	KEYWORD_overflowPunct,
	KEYWORD_p,
	KEYWORD_pageBreakBefore,
	KEYWORD_panose1,
	KEYWORD_paperSrc,
	KEYWORD_pBdr,
	KEYWORD_permEnd,
	KEYWORD_permStart,
	KEYWORD_personal,
	KEYWORD_personalCompose,
	KEYWORD_personalReply,
	KEYWORD_pgBorders,
	KEYWORD_pgMar,
	KEYWORD_pgNum,
	KEYWORD_pgNumType,
	KEYWORD_pgSz,
	KEYWORD_pict,
	KEYWORD_picture,
	KEYWORD_pitch,
	KEYWORD_placeholder,
	KEYWORD_pPr,
	KEYWORD_pPrChange,
	KEYWORD_pPrDefault,
	KEYWORD_pos,
	KEYWORD_position,
	KEYWORD_printerSettings,
	KEYWORD_proofErr,
	KEYWORD_pStyle,
	KEYWORD_ptab,
	KEYWORD_qFormat,
	KEYWORD_query,
	KEYWORD_result,
	KEYWORD_right,
	KEYWORD_r,
	KEYWORD_recipientData,
	KEYWORD_recipients,
	KEYWORD_rFonts,
	KEYWORD_richText,
	KEYWORD_rPr,
	KEYWORD_rPrChange,
	KEYWORD_rPrDefault,
	KEYWORD_rsid,
	KEYWORD_rStyle,
	KEYWORD_rt,
	KEYWORD_rtl,
	KEYWORD_rtlGutter,
	KEYWORD_ruby,
	KEYWORD_rubyAlign,
	KEYWORD_rubyBase,
	KEYWORD_rubyPr,
	KEYWORD_saveSubsetFonts,
	KEYWORD_sdt,
	KEYWORD_sdtContent,
	KEYWORD_sdtEndPr,
	KEYWORD_sdtPr,
	KEYWORD_sectPr,
	KEYWORD_sectPrChange,
	KEYWORD_semiHidden,
	KEYWORD_separator,
	KEYWORD_shadow,
	KEYWORD_shd,
	KEYWORD_showingPlcHdr,
	KEYWORD_sig,
	KEYWORD_size,
	KEYWORD_sizeAuto,
	KEYWORD_smallCaps,
	KEYWORD_smartTag,
	KEYWORD_smartTagPr,
	KEYWORD_snapToGrid,
	KEYWORD_softHyphen,
	KEYWORD_spacing,
	KEYWORD_specVanish,
	KEYWORD_src,
	KEYWORD_start,
	KEYWORD_startOverride,
	KEYWORD_statusText,
	KEYWORD_storeMappedDataAs,
	KEYWORD_strike,
	KEYWORD_style,
	KEYWORD_styleLink,
	KEYWORD_styles,
	KEYWORD_suff,
	KEYWORD_suppressAutoHypens,
	KEYWORD_suppressLineNumbers,
	KEYWORD_suppressOverlap,
	KEYWORD_sym,
	KEYWORD_sz,
	KEYWORD_szCs,
	KEYWORD_t,
	KEYWORD_tab,
	KEYWORD_table,
	KEYWORD_tabs,
	KEYWORD_tag,
	KEYWORD_tbl,
	KEYWORD_tblBorders,
	KEYWORD_tblCellMar,
	KEYWORD_tblCellSpacing,
	KEYWORD_tblGrid,
	KEYWORD_tblGridChange,
	KEYWORD_tblHeader,
	KEYWORD_tblInd,
	KEYWORD_tblLayout,
	KEYWORD_tblLook,
	KEYWORD_tblOverlap,
	KEYWORD_tblpPr,
	KEYWORD_tblPr,
	KEYWORD_tblPrChange,
	KEYWORD_tblPrEx,
	KEYWORD_tblPrExChange,
	KEYWORD_tblStyle,
	KEYWORD_tblStylePr,
	KEYWORD_tblStyleColBandSize,
	KEYWORD_tblStyleRowBandSize,
	KEYWORD_tblW,
	KEYWORD_tc,
	KEYWORD_tcBorders,
	KEYWORD_tcFitText,
	KEYWORD_tcMar,
	KEYWORD_tcPr,
	KEYWORD_tcPrChange,
	KEYWORD_tcW,
	KEYWORD_temporary,
	KEYWORD_text,
	KEYWORD_textAlignment,
	KEYWORD_textboxTightWrap,
	KEYWORD_textDirection,
	KEYWORD_textInput,
	KEYWORD_titlePg,
	KEYWORD_tl2br,
	KEYWORD_tmpl,
	KEYWORD_top,
	KEYWORD_topLinePunct,
	KEYWORD_tr,
	KEYWORD_tr2bl,
	KEYWORD_trHeight,
	KEYWORD_trPr,
	KEYWORD_trPrChange,
	KEYWORD_type,
	KEYWORD_types,
	KEYWORD_u,
	KEYWORD_udl,
	KEYWORD_uiPriority,
	KEYWORD_unhideWhenUsed,
	KEYWORD_uniqueTag,
	KEYWORD_vAlign,
	KEYWORD_vanish,
	KEYWORD_vertAlign,
	KEYWORD_viewMergedData,
	KEYWORD_vMerge,
	KEYWORD_yearLong,
	KEYWORD_yearShort,
	KEYWORD_w,
	KEYWORD_wAfter,
	KEYWORD_wBefore,
	KEYWORD_webHidden,
	KEYWORD_widowControl,
	KEYWORD_wordWrap
};

#endif //_OXMLI_TYPES_H_

