/*
 * Decompiled with CFR 0.152.
 */
package org.rubycoder.gsm;

import org.rubycoder.gsm.InvalidGSMFrameException;

public final class GSMDecoder {
    private static final byte GSM_MAGIC = 13;
    private static final int[] FAC = new int[]{18431, 20479, 22527, 24575, 26623, 28671, 30719, Short.MAX_VALUE};
    private static final int[] QLB = new int[]{3277, 11469, 21299, Short.MAX_VALUE};
    private static final int MIN_WORD = Short.MIN_VALUE;
    private static final int MAX_WORD = Short.MAX_VALUE;
    private final int[] dp0 = new int[280];
    private int[] u = new int[8];
    private final int[][] LARpp = new int[2][8];
    private int j;
    private int nrp;
    private final int[] v = new int[9];
    private int msr;

    public void GSM() {
        this.nrp = 40;
    }

    public final int[] decode(byte[] c) throws InvalidGSMFrameException {
        int[] s = new int[160];
        this.decode(c, s);
        return s;
    }

    public final void decode(byte[] c, int[] s) throws InvalidGSMFrameException {
        if (c.length != 33) {
            throw new InvalidGSMFrameException();
        }
        int i = 0;
        if ((c[i] >> 4 & 0xF) != 13) {
            throw new InvalidGSMFrameException();
        }
        int[] LARc = new int[8];
        int[] Nc = new int[4];
        int[] Mc = new int[4];
        int[] bc = new int[4];
        int[] xmaxc = new int[4];
        int[] xmc = new int[52];
        LARc[0] = (c[i++] & 0xF) << 2;
        LARc[0] = LARc[0] | c[i] >> 6 & 3;
        LARc[1] = c[i++] & 0x3F;
        LARc[2] = c[i] >> 3 & 0x1F;
        LARc[3] = (c[i++] & 7) << 2;
        LARc[3] = LARc[3] | c[i] >> 6 & 3;
        LARc[4] = c[i] >> 2 & 0xF;
        LARc[5] = (c[i++] & 3) << 2;
        LARc[5] = LARc[5] | c[i] >> 6 & 3;
        LARc[6] = c[i] >> 3 & 7;
        LARc[7] = c[i++] & 7;
        Nc[0] = c[i] >> 1 & 0x7F;
        bc[0] = (c[i++] & 1) << 1;
        bc[0] = bc[0] | c[i] >> 7 & 1;
        Mc[0] = c[i] >> 5 & 3;
        xmaxc[0] = (c[i++] & 0x1F) << 1;
        xmaxc[0] = xmaxc[0] | c[i] >> 7 & 1;
        xmc[0] = c[i] >> 4 & 7;
        xmc[1] = c[i] >> 1 & 7;
        xmc[2] = (c[i++] & 1) << 2;
        xmc[2] = xmc[2] | c[i] >> 6 & 3;
        xmc[3] = c[i] >> 3 & 7;
        xmc[4] = c[i++] & 7;
        xmc[5] = c[i] >> 5 & 7;
        xmc[6] = c[i] >> 2 & 7;
        xmc[7] = (c[i++] & 3) << 1;
        xmc[7] = xmc[7] | c[i] >> 7 & 1;
        xmc[8] = c[i] >> 4 & 7;
        xmc[9] = c[i] >> 1 & 7;
        xmc[10] = (c[i++] & 1) << 2;
        xmc[10] = xmc[10] | c[i] >> 6 & 3;
        xmc[11] = c[i] >> 3 & 7;
        xmc[12] = c[i++] & 7;
        Nc[1] = c[i] >> 1 & 0x7F;
        bc[1] = (c[i++] & 1) << 1;
        bc[1] = bc[1] | c[i] >> 7 & 1;
        Mc[1] = c[i] >> 5 & 3;
        xmaxc[1] = (c[i++] & 0x1F) << 1;
        xmaxc[1] = xmaxc[1] | c[i] >> 7 & 1;
        xmc[13] = c[i] >> 4 & 7;
        xmc[14] = c[i] >> 1 & 7;
        xmc[15] = (c[i++] & 1) << 2;
        xmc[15] = xmc[15] | c[i] >> 6 & 3;
        xmc[16] = c[i] >> 3 & 7;
        xmc[17] = c[i++] & 7;
        xmc[18] = c[i] >> 5 & 7;
        xmc[19] = c[i] >> 2 & 7;
        xmc[20] = (c[i++] & 3) << 1;
        xmc[20] = xmc[20] | c[i] >> 7 & 1;
        xmc[21] = c[i] >> 4 & 7;
        xmc[22] = c[i] >> 1 & 7;
        xmc[23] = (c[i++] & 1) << 2;
        xmc[23] = xmc[23] | c[i] >> 6 & 3;
        xmc[24] = c[i] >> 3 & 7;
        xmc[25] = c[i++] & 7;
        Nc[2] = c[i] >> 1 & 0x7F;
        bc[2] = (c[i++] & 1) << 1;
        bc[2] = bc[2] | c[i] >> 7 & 1;
        Mc[2] = c[i] >> 5 & 3;
        xmaxc[2] = (c[i++] & 0x1F) << 1;
        xmaxc[2] = xmaxc[2] | c[i] >> 7 & 1;
        xmc[26] = c[i] >> 4 & 7;
        xmc[27] = c[i] >> 1 & 7;
        xmc[28] = (c[i++] & 1) << 2;
        xmc[28] = xmc[28] | c[i] >> 6 & 3;
        xmc[29] = c[i] >> 3 & 7;
        xmc[30] = c[i++] & 7;
        xmc[31] = c[i] >> 5 & 7;
        xmc[32] = c[i] >> 2 & 7;
        xmc[33] = (c[i++] & 3) << 1;
        xmc[33] = xmc[33] | c[i] >> 7 & 1;
        xmc[34] = c[i] >> 4 & 7;
        xmc[35] = c[i] >> 1 & 7;
        xmc[36] = (c[i++] & 1) << 2;
        xmc[36] = xmc[36] | c[i] >> 6 & 3;
        xmc[37] = c[i] >> 3 & 7;
        xmc[38] = c[i++] & 7;
        Nc[3] = c[i] >> 1 & 0x7F;
        bc[3] = (c[i++] & 1) << 1;
        bc[3] = bc[3] | c[i] >> 7 & 1;
        Mc[3] = c[i] >> 5 & 3;
        xmaxc[3] = (c[i++] & 0x1F) << 1;
        xmaxc[3] = xmaxc[3] | c[i] >> 7 & 1;
        xmc[39] = c[i] >> 4 & 7;
        xmc[40] = c[i] >> 1 & 7;
        xmc[41] = (c[i++] & 1) << 2;
        xmc[41] = xmc[41] | c[i] >> 6 & 3;
        xmc[42] = c[i] >> 3 & 7;
        xmc[43] = c[i++] & 7;
        xmc[44] = c[i] >> 5 & 7;
        xmc[45] = c[i] >> 2 & 7;
        xmc[46] = (c[i++] & 3) << 1;
        xmc[46] = xmc[46] | c[i] >> 7 & 1;
        xmc[47] = c[i] >> 4 & 7;
        xmc[48] = c[i] >> 1 & 7;
        xmc[49] = (c[i++] & 1) << 2;
        xmc[49] = xmc[49] | c[i] >> 6 & 3;
        xmc[50] = c[i] >> 3 & 7;
        xmc[51] = c[i] & 7;
        this.decoder(LARc, Nc, bc, Mc, xmaxc, xmc, s);
    }

    public static void print(String name, int[] data) {
        System.out.print("[" + name + ":");
        for (int i = 0; i < data.length; ++i) {
            System.out.print("" + data[i]);
            if (i < data.length - 1) {
                System.out.print(",");
                continue;
            }
            System.out.println("]");
        }
    }

    public static void print(String name, int data) {
        System.out.println("[" + name + ":" + data + "]");
    }

    private void decoder(int[] LARcr, int[] Ncr, int[] bcr, int[] Mcr, int[] xmaxcr, int[] xMcr, int[] s) {
        int[] erp = new int[40];
        int[] wt = new int[160];
        for (int j = 0; j < 4; ++j) {
            this.RPEDecoding(xmaxcr[j], Mcr[j], xMcr, j * 13, erp);
            this.longTermSynthesisFiltering(Ncr[j], bcr[j], erp, this.dp0);
            for (int k = 0; k < 40; ++k) {
                wt[j * 40 + k] = this.dp0[120 + k];
            }
        }
        this.shortTermSynthesisFilter(LARcr, wt, s);
        this.postprocessing(s);
    }

    private void RPEDecoding(int xmaxcr, int Mcr, int[] xMcr, int xMcrOffset, int[] erp) {
        int[] xMp = new int[13];
        int[] expAndMant = this.xmaxcToExpAndMant(xmaxcr);
        this.APCMInverseQuantization(xMcr, xMcrOffset, expAndMant[0], expAndMant[1], xMp);
        GSMDecoder.RPE_grid_positioning(Mcr, xMp, erp);
    }

    private int[] xmaxcToExpAndMant(int xmaxc) {
        int mant;
        int exp = 0;
        if (xmaxc > 15) {
            exp = (xmaxc >> 3) - 1;
        }
        if ((mant = xmaxc - (exp << 3)) == 0) {
            exp = -4;
            mant = 7;
        } else {
            while (mant <= 7) {
                mant = mant << 1 | 1;
                --exp;
            }
            mant -= 8;
        }
        int[] result = new int[]{exp, mant};
        return result;
    }

    private void APCMInverseQuantization(int[] xMc, int xMcOffset, int exp, int mant, int[] xMp) {
        int temp1 = FAC[mant];
        int temp2 = GSMDecoder.sub(6, exp);
        int temp3 = GSMDecoder.asl(1, GSMDecoder.sub(temp2, 1));
        int p = 0;
        int i = 13;
        while (i-- > 0) {
            int temp = (xMc[xMcOffset++] << 1) - 7;
            temp <<= 12;
            temp = GSMDecoder.mult_r(temp1, temp);
            temp = GSMDecoder.add(temp, temp3);
            xMp[p++] = GSMDecoder.asr(temp, temp2);
        }
    }

    private static int saturate(int x) {
        return x < Short.MIN_VALUE ? Short.MIN_VALUE : (x > Short.MAX_VALUE ? Short.MAX_VALUE : x);
    }

    private static int sub(int a, int b) {
        int diff = a - b;
        return GSMDecoder.saturate(diff);
    }

    private static int add(int a, int b) {
        int sum = a + b;
        return GSMDecoder.saturate(sum);
    }

    private static int asl(int a, int n) {
        if (n >= 16) {
            return 0;
        }
        if (n <= -16) {
            return a < 0 ? -1 : 0;
        }
        if (n < 0) {
            return GSMDecoder.asr(a, -n);
        }
        return a << n;
    }

    private static int asr(int a, int n) {
        if (n >= 16) {
            return a < 0 ? -1 : 0;
        }
        if (n <= -16) {
            return 0;
        }
        if (n < 0) {
            return a << -n;
        }
        return a >> n;
    }

    private static int mult_r(int a, int b) {
        if (b == Short.MIN_VALUE && a == Short.MIN_VALUE) {
            return Short.MAX_VALUE;
        }
        int prod = a * b + 16384;
        return GSMDecoder.saturate(prod >> 15);
    }

    private void longTermSynthesisFiltering(int Ncr, int bcr, int[] erp, int[] dp0) {
        int k;
        int Nr;
        this.nrp = Nr = Ncr < 40 || Ncr > 120 ? this.nrp : Ncr;
        int brp = QLB[bcr];
        for (k = 0; k <= 39; ++k) {
            int drpp = GSMDecoder.mult_r(brp, dp0[120 + (k - Nr)]);
            dp0[120 + k] = GSMDecoder.add(erp[k], drpp);
        }
        for (k = 0; k <= 119; ++k) {
            dp0[k] = dp0[40 + k];
        }
    }

    private void shortTermSynthesisFilter(int[] LARcr, int[] wt, int[] s) {
        int[] LARpp_j = this.LARpp[this.j];
        int[] LARpp_j_1 = this.LARpp[this.j ^= 1];
        int[] LARp = new int[8];
        GSMDecoder.decodingOfTheCodedLogAreaRatios(LARcr, LARpp_j);
        GSMDecoder.Coefficients_0_12(LARpp_j_1, LARpp_j, LARp);
        GSMDecoder.LARp_to_rp(LARp);
        this.shortTermSynthesisFiltering(LARp, 13, wt, s, 0);
        GSMDecoder.Coefficients_13_26(LARpp_j_1, LARpp_j, LARp);
        GSMDecoder.LARp_to_rp(LARp);
        this.shortTermSynthesisFiltering(LARp, 14, wt, s, 13);
        GSMDecoder.Coefficients_27_39(LARpp_j_1, LARpp_j, LARp);
        GSMDecoder.LARp_to_rp(LARp);
        this.shortTermSynthesisFiltering(LARp, 13, wt, s, 27);
        GSMDecoder.Coefficients_40_159(LARpp_j, LARp);
        GSMDecoder.LARp_to_rp(LARp);
        this.shortTermSynthesisFiltering(LARp, 120, wt, s, 40);
    }

    private static void decodingOfTheCodedLogAreaRatios(int[] LARc, int[] LARpp) {
        int temp1 = GSMDecoder.add(LARc[0], -32) << 10;
        temp1 = GSMDecoder.mult_r(13107, temp1);
        LARpp[0] = GSMDecoder.add(temp1, temp1);
        temp1 = GSMDecoder.add(LARc[1], -32) << 10;
        temp1 = GSMDecoder.mult_r(13107, temp1);
        LARpp[1] = GSMDecoder.add(temp1, temp1);
        temp1 = GSMDecoder.add(LARc[2], -16) << 10;
        temp1 = GSMDecoder.sub(temp1, 4096);
        temp1 = GSMDecoder.mult_r(13107, temp1);
        LARpp[2] = GSMDecoder.add(temp1, temp1);
        temp1 = GSMDecoder.add(LARc[3], -16) << 10;
        temp1 = GSMDecoder.sub(temp1, -5120);
        temp1 = GSMDecoder.mult_r(13107, temp1);
        LARpp[3] = GSMDecoder.add(temp1, temp1);
        temp1 = GSMDecoder.add(LARc[4], -8) << 10;
        temp1 = GSMDecoder.sub(temp1, 188);
        temp1 = GSMDecoder.mult_r(19223, temp1);
        LARpp[4] = GSMDecoder.add(temp1, temp1);
        temp1 = GSMDecoder.add(LARc[5], -8) << 10;
        temp1 = GSMDecoder.sub(temp1, -3584);
        temp1 = GSMDecoder.mult_r(17476, temp1);
        LARpp[5] = GSMDecoder.add(temp1, temp1);
        temp1 = GSMDecoder.add(LARc[6], -4) << 10;
        temp1 = GSMDecoder.sub(temp1, -682);
        temp1 = GSMDecoder.mult_r(31454, temp1);
        LARpp[6] = GSMDecoder.add(temp1, temp1);
        temp1 = GSMDecoder.add(LARc[7], -4) << 10;
        temp1 = GSMDecoder.sub(temp1, -2288);
        temp1 = GSMDecoder.mult_r(29708, temp1);
        LARpp[7] = GSMDecoder.add(temp1, temp1);
    }

    private static void Coefficients_0_12(int[] LARpp_j_1, int[] LARpp_j, int[] LARp) {
        for (int i = 0; i < 8; ++i) {
            LARp[i] = GSMDecoder.add(LARpp_j_1[i] >> 2, LARpp_j[i] >> 2);
            LARp[i] = GSMDecoder.add(LARp[i], LARpp_j_1[i] >> 1);
        }
    }

    private static void Coefficients_13_26(int[] LARpp_j_1, int[] LARpp_j, int[] LARp) {
        for (int i = 0; i < 8; ++i) {
            LARp[i] = GSMDecoder.add(LARpp_j_1[i] >> 1, LARpp_j[i] >> 1);
        }
    }

    private static void Coefficients_27_39(int[] LARpp_j_1, int[] LARpp_j, int[] LARp) {
        for (int i = 0; i < 8; ++i) {
            LARp[i] = GSMDecoder.add(LARpp_j_1[i] >> 2, LARpp_j[i] >> 2);
            LARp[i] = GSMDecoder.add(LARp[i], LARpp_j[i] >> 1);
        }
    }

    private static void Coefficients_40_159(int[] LARpp_j, int[] LARp) {
        for (int i = 0; i < 8; ++i) {
            LARp[i] = LARpp_j[i];
        }
    }

    private static void LARp_to_rp(int[] LARp) {
        for (int i = 0; i < 8; ++i) {
            int temp;
            if (LARp[i] < 0) {
                int n = temp = LARp[i] == Short.MIN_VALUE ? Short.MAX_VALUE : -LARp[i];
                LARp[i] = -(temp < 11059 ? temp << 1 : (temp < 20070 ? temp + 11059 : GSMDecoder.add(temp >> 2, 26112)));
                continue;
            }
            temp = LARp[i];
            LARp[i] = temp < 11059 ? temp << 1 : (temp < 20070 ? temp + 11059 : GSMDecoder.add(temp >> 2, 26112));
        }
    }

    private void shortTermSynthesisFiltering(int[] rrp, int k, int[] wt, int[] sr, int off) {
        int woff = off;
        int soff = off;
        while (k-- > 0) {
            int sri = wt[woff++];
            int i = 8;
            while (i-- > 0) {
                int tmp1 = rrp[i];
                int tmp2 = this.v[i];
                tmp2 = tmp1 == Short.MIN_VALUE && tmp2 == Short.MIN_VALUE ? Short.MAX_VALUE : GSMDecoder.saturate(tmp1 * tmp2 + 16384 >> 15);
                sri = GSMDecoder.sub(sri, tmp2);
                tmp1 = tmp1 == Short.MIN_VALUE && sri == Short.MIN_VALUE ? Short.MAX_VALUE : GSMDecoder.saturate(tmp1 * sri + 16384 >> 15);
                this.v[i + 1] = GSMDecoder.add(this.v[i], tmp1);
            }
            sr[soff++] = this.v[0] = sri;
        }
    }

    private void postprocessing(int[] s) {
        int soff = 0;
        int k = 160;
        while (k-- > 0) {
            int tmp = GSMDecoder.mult_r(this.msr, 28180);
            this.msr = GSMDecoder.add(s[soff], tmp);
            s[soff] = GSMDecoder.saturate(GSMDecoder.add(this.msr, this.msr) & 0xFFFFFFF8);
            ++soff;
        }
    }

    private static void RPE_grid_positioning(int Mc, int[] xMp, int[] ep) {
        int i = 13;
        int epo = 0;
        int po = 0;
        switch (Mc) {
            case 3: {
                ep[epo++] = 0;
            }
            case 2: {
                ep[epo++] = 0;
            }
            case 1: {
                ep[epo++] = 0;
            }
            case 0: {
                ep[epo++] = xMp[po++];
                --i;
            }
        }
        do {
            ep[epo++] = 0;
            ep[epo++] = 0;
            ep[epo++] = xMp[po++];
        } while (--i > 0);
        while (++Mc < 4) {
            ep[epo++] = 0;
        }
    }
}

