/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.xmpp.client.impl;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jivesoftware.smack.packet.Presence;
import org.limewire.friend.api.FriendPresence;
import org.limewire.friend.api.feature.FeatureEvent;
import org.limewire.friend.impl.AbstractFriend;
import org.limewire.friend.impl.AbstractFriendPresence;
import org.limewire.listener.EventBroadcaster;

class PresenceImpl
extends AbstractFriendPresence
implements FriendPresence {
    private final AbstractFriend friend;
    private final String jid;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private FriendPresence.Type type;
    private String status;
    private int priority;
    private FriendPresence.Mode mode;

    PresenceImpl(Presence presence, AbstractFriend friend, EventBroadcaster<FeatureEvent> featureBroadcaster) {
        super(featureBroadcaster);
        this.friend = friend;
        this.jid = presence.getFrom();
        this.update(presence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Presence presence) {
        this.rwLock.writeLock().lock();
        try {
            this.type = FriendPresence.Type.valueOf(presence.getType().toString());
            this.status = presence.getStatus();
            this.priority = presence.getPriority();
            this.mode = presence.getMode() != null ? FriendPresence.Mode.valueOf(presence.getMode().toString()) : FriendPresence.Mode.available;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public String getPresenceId() {
        return this.jid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FriendPresence.Type getType() {
        this.rwLock.readLock().lock();
        try {
            FriendPresence.Type type = this.type;
            return type;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStatus() {
        this.rwLock.readLock().lock();
        try {
            String string = this.status;
            return string;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPriority() {
        this.rwLock.readLock().lock();
        try {
            int n = this.priority;
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FriendPresence.Mode getMode() {
        this.rwLock.readLock().lock();
        try {
            FriendPresence.Mode mode = this.mode;
            return mode;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public String toString() {
        return this.getPresenceId() + " for " + this.friend.toString();
    }

    @Override
    public AbstractFriend getFriend() {
        return this.friend;
    }
}

