/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class BufferUtils {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);

    public static ByteBuffer getEmptyBuffer() {
        return EMPTY_BUFFER;
    }

    public static long delete(ByteBuffer buffer, long amountToDelete) {
        if ((long)buffer.position() <= amountToDelete) {
            amountToDelete -= (long)buffer.position();
            buffer.clear();
        } else {
            buffer.flip();
            buffer.position((int)amountToDelete);
            buffer.compact();
            amountToDelete = 0L;
        }
        return amountToDelete;
    }

    public static int readAll(ByteBuffer bufferSrc, ReadableByteChannel channelSrc, ByteBuffer dst) throws IOException {
        BufferUtils.transfer(bufferSrc, dst, true);
        int read = 0;
        while (dst.hasRemaining() && (read = channelSrc.read(dst)) > 0) {
        }
        return read;
    }

    public static int transfer(ByteBuffer src, ByteBuffer dst) {
        return BufferUtils.transfer(src, dst, true);
    }

    public static int transfer(ByteBuffer src, ByteBuffer dst, boolean needsFlip) {
        int read = 0;
        if (src != null) {
            if (needsFlip) {
                if (src.position() > 0) {
                    src.flip();
                    read = BufferUtils.doTransfer(src, dst);
                    if (src.hasRemaining()) {
                        src.compact();
                    } else {
                        src.clear();
                    }
                }
            } else if (src.hasRemaining()) {
                read = BufferUtils.doTransfer(src, dst);
            }
        }
        return read;
    }

    public static long transfer(ByteBuffer from, ByteBuffer[] to, int offset, int length, boolean needsFlip) {
        long read = 0L;
        for (int i = offset; i < offset + length; ++i) {
            read += (long)BufferUtils.transfer(from, to[i], needsFlip);
        }
        return read;
    }

    private static int doTransfer(ByteBuffer src, ByteBuffer dst) {
        int read = 0;
        int remaining = src.remaining();
        int toRemaining = dst.remaining();
        if (toRemaining >= remaining) {
            dst.put(src);
            read += remaining;
        } else {
            int limit = src.limit();
            int position = src.position();
            src.limit(position + toRemaining);
            dst.put(src);
            read += toRemaining;
            src.limit(limit);
        }
        return read;
    }

    public static boolean readLine(ByteBuffer src, StringBuilder dst) {
        int c = -1;
        block4: while (src.hasRemaining()) {
            c = src.get();
            switch (c) {
                case 10: {
                    return true;
                }
                case 13: {
                    continue block4;
                }
            }
            dst.append((char)c);
        }
        return false;
    }

    public static int transfer(ByteBuffer src, StringBuilder dst) {
        int written = 0;
        while (src.hasRemaining()) {
            dst.append((char)src.get());
            ++written;
        }
        return written;
    }
}

