/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.util;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import javax.swing.JOptionPane;
import org.limewire.concurrent.ManagedThread;
import org.limewire.core.api.Category;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.ui.swing.components.FocusJOptionPane;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.SwingUtils;
import org.limewire.util.OSUtils;
import org.limewire.util.SystemUtils;

public final class NativeLaunchUtils {
    private static final Log LOG = LogFactory.getLog(NativeLaunchUtils.class);

    private NativeLaunchUtils() {
    }

    public static void openURL(final String url) {
        ManagedThread managedThread = new ManagedThread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (OSUtils.isWindows()) {
                        NativeLaunchUtils.openURLWindows(url);
                    } else if (OSUtils.isMacOSX()) {
                        NativeLaunchUtils.openURLMac(url);
                    } else {
                        NativeLaunchUtils.openURLLinux(url);
                    }
                }
                catch (IOException iox) {
                    try {
                        Desktop.getDesktop().browse(new URI(url));
                    }
                    catch (Throwable t) {
                        NativeLaunchUtils.logException(I18n.tr("Unable to open URL"), I18n.tr("Open URL"), new Exception(t));
                    }
                }
            }
        });
        managedThread.start();
    }

    private static Process openURLLinux(String url) throws IOException {
        return NativeLaunchUtils.exec("xdg-open", url);
    }

    private static void openURLWindows(String url) throws IOException {
        SystemUtils.openURL(url);
    }

    private static void openURLMac(String url) throws IOException {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (URISyntaxException e) {
            throw new IOException();
        }
    }

    public static void safeLaunchFile(File file, CategoryManager categoryManager) {
        Category category = categoryManager.getCategoryForFile(file);
        if (category == Category.PROGRAM || category == Category.OTHER) {
            NativeLaunchUtils.launchExplorer(file);
        } else {
            NativeLaunchUtils.launchFile(file);
        }
    }

    private static void launchFile(final File file) {
        ManagedThread managedThread = new ManagedThread(new Runnable(){

            @Override
            public void run() {
                try {
                    NativeLaunchUtils.launchFileImpl(file);
                }
                catch (LaunchException lex) {
                    NativeLaunchUtils.logException(I18n.tr("Unable to open file: {0}", file.getName()), I18n.tr("Open File"), lex);
                }
                catch (IOException iox) {
                    NativeLaunchUtils.logException(I18n.tr("Unable to open file: {0}", file.getName()), I18n.tr("Open File"), iox);
                }
                catch (SecurityException ex) {
                    NativeLaunchUtils.logException(I18n.tr("Unable to open file: {0}", file.getName()), I18n.tr("Open File"), ex);
                }
            }
        });
        managedThread.start();
    }

    private static void launchFileImpl(File file) throws IOException, SecurityException {
        String path = file.getCanonicalPath();
        String extCheckString = path.toLowerCase(Locale.US);
        if (extCheckString.endsWith(".exe") || extCheckString.endsWith(".vbs") || extCheckString.endsWith(".lnk") || extCheckString.endsWith(".bat") || extCheckString.endsWith(".sys") || extCheckString.endsWith(".com")) {
            throw new SecurityException();
        }
        NativeLaunchUtils.openFile(file);
    }

    private static void openFile(File file) throws IOException {
        String path = file.getCanonicalPath();
        try {
            if (OSUtils.isWindows()) {
                NativeLaunchUtils.launchFileWindows(path);
            } else if (OSUtils.isMacOSX()) {
                NativeLaunchUtils.launchFileMacOSX(path);
            } else {
                NativeLaunchUtils.launchFileLinux(path);
            }
        }
        catch (IOException e) {
            try {
                Desktop.getDesktop().open(file);
            }
            catch (Throwable t) {
                throw new IOException(t);
            }
        }
    }

    public static Process launchExplorer(File file) {
        try {
            return NativeLaunchUtils.launchExplorerImpl(file);
        }
        catch (LaunchException lex) {
            NativeLaunchUtils.logException(I18n.tr("Unable to locate file: {0}", file.getName()), I18n.tr("Locate File"), lex);
            return null;
        }
        catch (SecurityException ex) {
            NativeLaunchUtils.logException(I18n.tr("Unable to locate file: {0}", file.getName()), I18n.tr("Locate File"), ex);
            return null;
        }
        catch (IOException iox) {
            NativeLaunchUtils.logException(I18n.tr("Unable to locate file: {0}", file.getName()), I18n.tr("Locate File"), iox);
            return null;
        }
    }

    private static Process launchExplorerImpl(File file) throws IOException, SecurityException {
        if (OSUtils.isWindows()) {
            String explorePath = file.getPath();
            try {
                explorePath = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            explorePath = "\"" + explorePath + "\"";
            if (file.isDirectory()) {
                SystemUtils.openFile("explorer", explorePath);
            } else {
                SystemUtils.openFile("explorer", "/select," + explorePath);
            }
        } else {
            if (OSUtils.isMacOSX()) {
                return NativeLaunchUtils.exec(NativeLaunchUtils.selectFileCommand(file));
            }
            if (OSUtils.isLinux()) {
                return NativeLaunchUtils.exec(NativeLaunchUtils.selectFileCommandLinux(file));
            }
        }
        return null;
    }

    private static String[] selectFileCommandLinux(File file) {
        String path = null;
        File parentDir = file.isDirectory() ? file : file.getParentFile();
        try {
            path = parentDir.getCanonicalPath();
        }
        catch (IOException err) {
            path = parentDir.getAbsolutePath();
        }
        return new String[]{"xdg-open", path};
    }

    private static Process launchFileLinux(String path) throws IOException {
        return NativeLaunchUtils.exec("xdg-open", path);
    }

    private static int launchFileWindows(String path) throws IOException {
        return SystemUtils.openFile(path);
    }

    private static Process launchFileMacOSX(String filename) throws IOException {
        Process process = NativeLaunchUtils.exec("open", filename);
        try {
            process.waitFor();
            if (process.exitValue() == 1) {
                String message = I18n.tr("The file ") + new File(filename).getName() + I18n.tr(" could not be opened! There are no registered applications on your system for this file type.");
                String title = I18n.tr("File cannot be opened");
                JOptionPane.showMessageDialog(GuiUtils.getMainFrame(), message, title, 0);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return process;
    }

    private static String[] selectFileCommand(File file) {
        String path = null;
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException err) {
            path = file.getAbsolutePath();
        }
        String[] command = new String[]{"osascript", "-e", "set unixPath to \"" + path + "\"", "-e", "set hfsPath to POSIX file unixPath", "-e", "tell application \"Finder\"", "-e", "activate", "-e", "select hfsPath", "-e", "end tell"};
        return command;
    }

    private static Process exec(String ... commands) throws LaunchException {
        ProcessBuilder pb = new ProcessBuilder(commands);
        try {
            return pb.start();
        }
        catch (IOException e) {
            throw new LaunchException(e, commands);
        }
    }

    private static void logException(final String userMessage, final String title, Exception ex) {
        LOG.error(userMessage, ex);
        SwingUtils.invokeNowOrLater(new Runnable(){

            @Override
            public void run() {
                FocusJOptionPane.showMessageDialog(GuiUtils.getMainFrame(), userMessage, title, 1);
            }
        });
    }

    public static class LaunchException
    extends IOException {
        private final String[] command;

        public LaunchException(IOException cause, String ... command) {
            this.command = command;
            this.initCause(cause);
        }

        public LaunchException(String ... command) {
            this.command = command;
        }

        public String[] getCommand() {
            return this.command;
        }
    }
}

