/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.lang.reflect.Field;
import java.math.RoundingMode;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.ComponentUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.application.Application;
import org.jdesktop.application.SingleFrameApplication;
import org.limewire.i18n.I18nMarker;
import org.limewire.ui.swing.mainframe.AppFrame;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.NativeLaunchUtils;
import org.limewire.ui.swing.util.WindowsUtils;
import org.limewire.util.OSUtils;

public class GuiUtils {
    private static final Log LOG = LogFactory.getLog(GuiUtils.class);
    private static NumberFormat NUMBER_FORMAT0;
    private static NumberFormat NUMBER_FORMAT1;
    private static DateFormat DATETIME_FORMAT;
    public static String KBPERSEC_FORMAT;

    static void setLocale(Locale locale) {
        NUMBER_FORMAT0 = NumberFormat.getNumberInstance(locale);
        NUMBER_FORMAT0.setMaximumFractionDigits(1);
        NUMBER_FORMAT0.setMinimumFractionDigits(0);
        NUMBER_FORMAT0.setGroupingUsed(true);
        NUMBER_FORMAT0.setRoundingMode(RoundingMode.HALF_UP);
        NUMBER_FORMAT1 = NumberFormat.getNumberInstance(locale);
        NUMBER_FORMAT1.setMaximumFractionDigits(2);
        NUMBER_FORMAT1.setMinimumFractionDigits(2);
        NUMBER_FORMAT1.setGroupingUsed(true);
        NUMBER_FORMAT1.setRoundingMode(RoundingMode.HALF_UP);
        DATETIME_FORMAT = DateFormat.getDateTimeInstance(2, 2, locale);
    }

    public static String toLocalizedInteger(long value) {
        return NUMBER_FORMAT0.format(value);
    }

    public static String toKilobytes(long bytes) {
        if (bytes < 0L) {
            return I18n.tr(SizeUnit.KILOBYTES.getFormatString(), "?");
        }
        long kbytes = bytes / 1024L;
        if ((bytes & 0x200L) != 0L || bytes > 0L && bytes < 1024L) {
            ++kbytes;
        }
        return I18n.tr(SizeUnit.KILOBYTES.getFormatString(), NUMBER_FORMAT0.format(kbytes));
    }

    public static String formatUnitFromBytes(long bytes) {
        return GuiUtils.toUnit(bytes, SizeUnit.values());
    }

    private static boolean isInRange(long value, Unit unit) {
        return value < unit.getMagnitude();
    }

    private static String toUnit(long value, Unit[] unitSet) {
        if (value < 0L) {
            return I18n.tr(SizeUnit.KILOBYTES.getFormatString(), "?");
        }
        long unitValue = 1L;
        String unitName = "?";
        for (Unit unit : unitSet) {
            if (!GuiUtils.isInRange(value, unit)) continue;
            unitValue = unit.getUnitValue();
            unitName = unit.getFormatString();
            break;
        }
        NumberFormat numberFormat = value < 0x100000L ? NUMBER_FORMAT0 : NUMBER_FORMAT1;
        try {
            return I18n.tr(unitName, numberFormat.format((double)value / (double)unitValue));
        }
        catch (ArithmeticException ae) {
            return I18n.tr(unitName, 0);
        }
    }

    public static String formatBytes(long bytes) {
        if (bytes < 0L) {
            return I18n.tr(SizeUnit.BYTES.getFormatString(), "?");
        }
        NumberFormat numberFormat = NUMBER_FORMAT0;
        try {
            return I18n.tr(SizeUnit.BYTES.getFormatString(), numberFormat.format(bytes));
        }
        catch (ArithmeticException ae) {
            return I18n.tr(SizeUnit.BYTES.getFormatString(), 0);
        }
    }

    public static String formatKilobytesPerSec(double rate) {
        return I18n.tr(SpeedUnit.KBSEC.getFormatString(), NUMBER_FORMAT0.format(rate));
    }

    public static String formatUnitFromBytesPerSec(long bytesPerSec) {
        return GuiUtils.toUnit(bytesPerSec, SpeedUnit.values());
    }

    public static String msec2DateTime(long milliseconds) {
        Date d = new Date(milliseconds);
        return DATETIME_FORMAT.format(d);
    }

    public static JFrame getMainFrame() {
        if (AppFrame.isStarted()) {
            Application app = Application.getInstance();
            if (app instanceof SingleFrameApplication) {
                return ((SingleFrameApplication)app).getMainFrame();
            }
            return null;
        }
        return null;
    }

    public static Frame getParentFrame(Component component) {
        Container ancestor;
        if (component instanceof JComponent && (ancestor = ((JComponent)component).getTopLevelAncestor()) instanceof Frame) {
            return (Frame)ancestor;
        }
        return GuiUtils.getMainFrame();
    }

    public static void assignResources(Object object) {
        Application.getInstance().getContext().getResourceMap(AppFrame.class).injectFields(object);
    }

    public static String colorToHex(Color colorCode) {
        int r = colorCode.getRed();
        int g = colorCode.getGreen();
        int b = colorCode.getBlue();
        return GuiUtils.toHex(r) + GuiUtils.toHex(g) + GuiUtils.toHex(b);
    }

    public static String toHex(int i) {
        String hex = Integer.toHexString(i).toUpperCase(Locale.US);
        if (hex.length() == 1) {
            return "0" + hex;
        }
        return hex;
    }

    public static ComponentUI getNativeUI(JComponent c) {
        ComponentUI ret = null;
        String name = UIManager.getSystemLookAndFeelClassName();
        if (name != null) {
            try {
                Class<?> clazz = Class.forName(name);
                LookAndFeel lf = (LookAndFeel)clazz.newInstance();
                lf.initialize();
                UIDefaults def = lf.getDefaults();
                ret = def.getUI(c);
            }
            catch (ExceptionInInitializerError e) {
            }
            catch (ClassNotFoundException e) {
            }
            catch (LinkageError e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InstantiationException e) {
            }
            catch (SecurityException e) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (ret == null) {
            ret = UIManager.getUI(c);
        }
        return ret;
    }

    public static String restrictWidth(String text, int width) {
        return "<html><table width=\"" + width + "\"><tr><td>" + text + "</td></tr></table></html>";
    }

    public static int getCodeForCharKey(String str) {
        int charCode = -1;
        String charStr = str.toUpperCase(Locale.US);
        if (charStr.length() > 1) {
            return -1;
        }
        try {
            Field charField = KeyEvent.class.getField("VK_" + charStr);
            charCode = charField.getInt(KeyEvent.class);
        }
        catch (NoSuchFieldException e) {
            LOG.error("can't get key for: " + charStr, e);
        }
        catch (SecurityException e) {
            LOG.error("can't get key for: " + charStr, e);
        }
        catch (IllegalAccessException e) {
            LOG.error("can't get key for: " + charStr, e);
        }
        return charCode;
    }

    private static int getAmpersandPosition(String text) {
        int index = -1;
        while (!((index = text.indexOf(38, index + 1)) == -1 || index < text.length() - 1 && Character.isLetterOrDigit(text.charAt(index + 1)))) {
        }
        return index;
    }

    public static String stripAmpersand(String text) {
        int index = GuiUtils.getAmpersandPosition(text);
        if (index >= 0) {
            return text.substring(0, index) + text.substring(index + 1);
        }
        return text;
    }

    public static int getMnemonicKeyCode(String text) {
        int index = GuiUtils.getAmpersandPosition(text);
        if (index >= 0) {
            return GuiUtils.getCodeForCharKey(text.substring(index + 1, index + 2));
        }
        return -1;
    }

    public static boolean shouldShowStartOnStartupWindow() {
        return OSUtils.isMacOSX() || WindowsUtils.isLoginStatusAvailable();
    }

    public static String toQualityStringShort(long qualityScore) {
        if (qualityScore <= 1L) {
            return I18n.trc("Poor (media quality)", "Poor");
        }
        if (qualityScore == 2L) {
            return I18n.trc("Good (media quality)", "Good");
        }
        return I18n.trc("Excellent (media quality)", "Excellent");
    }

    public static String toQualityString(long qualityScore) {
        if (qualityScore <= 1L) {
            return I18n.tr("Poor Quality");
        }
        if (qualityScore == 2L) {
            return I18n.tr("Good Quality");
        }
        return I18n.tr("Excellent Quality");
    }

    public static HyperlinkListener getHyperlinkListener() {
        return new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                URL url;
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (url = e.getURL()) != null) {
                    NativeLaunchUtils.openURL(url.toExternalForm());
                }
            }
        };
    }

    public static Action getDisposeAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Window parent = ae.getSource() instanceof Window ? (Window)ae.getSource() : SwingUtilities.getWindowAncestor((Component)ae.getSource());
                if (parent != null) {
                    parent.dispatchEvent(new WindowEvent(parent, 201));
                }
            }
        };
    }

    public static void addHideAction(JDialog jd) {
        GuiUtils.addHideAction(jd.getRootPane());
    }

    public static void addHideAction(JComponent jc) {
        InputMap map = jc.getInputMap(1);
        map.put(GuiUtils.getHideKeystroke(), "limewire.hideWindow");
        jc.getActionMap().put("limewire.hideWindow", GuiUtils.getDisposeAction());
    }

    public static KeyStroke getHideKeystroke() {
        if (OSUtils.isMacOSX()) {
            return KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        }
        return KeyStroke.getKeyStroke(27, 0);
    }

    public static Point getScreenCenterPoint(Component comp) {
        Dimension dimension = comp.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int appWidth = Math.min(screenSize.width, dimension.width);
        int appHeight = Math.min(screenSize.height - 40, dimension.height);
        return new Point((screenSize.width - appWidth) / 2, (screenSize.height - appHeight) / 2);
    }

    public static boolean canDisplay(Font f, String s) {
        int upTo = f.canDisplayUpTo(s);
        return upTo >= s.length() || upTo == -1;
    }

    public static void hideAndDisposeAllWindows() {
        for (Window window : Window.getWindows()) {
            try {
                window.setVisible(false);
                window.dispose();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
    }

    static {
        KBPERSEC_FORMAT = SpeedUnit.KBSEC.getFormatString();
        GuiUtils.setLocale(Locale.getDefault());
    }

    private static enum SpeedUnit implements Unit
    {
        BPSEC(I18nMarker.marktr("{0} B/s"), 1024L, 1L),
        KBSEC(I18nMarker.marktr("{0} KB/s"), 0x100000L, 1024L),
        MBSEC(I18nMarker.marktr("{0} MB/s"), 0x40000000L, 0x100000L),
        GBSEC(I18nMarker.marktr("{0} GB/s"), 0x10000000000L, 0x40000000L),
        TBSEC(I18nMarker.marktr("{0} TB/s"), Long.MAX_VALUE, 0x10000000000L);

        private final String text;
        private final long magnitude;
        private final long unitValue;

        private SpeedUnit(String text, long magnitude, long unitValue) {
            this.text = text;
            this.magnitude = magnitude;
            this.unitValue = unitValue;
        }

        @Override
        public String getFormatString() {
            return this.text;
        }

        @Override
        public long getMagnitude() {
            return this.magnitude;
        }

        @Override
        public long getUnitValue() {
            return this.unitValue;
        }
    }

    private static enum SizeUnit implements Unit
    {
        BYTES(I18nMarker.marktr("{0} bytes"), 1024L, 1L),
        KILOBYTES(I18nMarker.marktr("{0} KB"), 0x100000L, 1024L),
        MEGABYTES(I18nMarker.marktr("{0} MB"), 0x40000000L, 0x100000L),
        GIGABYTES(I18nMarker.marktr("{0} GB"), 0x10000000000L, 0x40000000L),
        TERABYTES(I18nMarker.marktr("{0} TB"), Long.MAX_VALUE, 0x10000000000L);

        private final String text;
        private final long magnitude;
        private final long unitValue;

        private SizeUnit(String text, long magnitude, long unitValue) {
            this.text = text;
            this.magnitude = magnitude;
            this.unitValue = unitValue;
        }

        @Override
        public String getFormatString() {
            return this.text;
        }

        @Override
        public long getMagnitude() {
            return this.magnitude;
        }

        @Override
        public long getUnitValue() {
            return this.unitValue;
        }
    }

    private static interface Unit {
        public String getFormatString();

        public long getMagnitude();

        public long getUnitValue();
    }
}

